#pragma once
/*
 * This file is part of the libCEC(R) library.
 *
 * libCEC(R) is Copyright (C) 2011 Pulse-Eight Limited.  All rights reserved.
 * libCEC(R) is an original work, containing original code.
 *
 * libCEC(R) is a trademark of Pulse-Eight Limited.
 *
 * This program is dual-licensed; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 * Alternatively, you can license this library under a commercial license,
 * please contact Pulse-Eight Licensing for more information.
 *
 * For more information contact:
 * Pulse-Eight Licensing       <license@pulse-eight.com>
 *     http://www.pulse-eight.com/
 *     http://www.pulse-eight.net/
 */

typedef enum
{
  CEC_ABORT_REASON_UNRECOGNIZED_OPCODE = 0,
  CEC_ABORT_REASON_NOT_IN_CORRECT_MODE_TO_RESPOND = 1,
  CEC_ABORT_REASON_CANNOT_PROVIDE_SOURCE = 2,
  CEC_ABORT_REASON_INVALID_OPERAND = 3,
  CEC_ABORT_REASON_REFUSED = 4
} ECecAbortReason;

typedef enum
{
  CEC_ANALOGUE_BROADCAST_TYPE_CABLE = 0x00,
  CEC_ANALOGUE_BROADCAST_TYPE_SATELLITE = 0x01,
  CEC_ANALOGUE_BROADCAST_TYPE_TERRESTIAL = 0x02
} ECecAnalogueBroadcastType;

typedef enum
{
  CEC_AUDIO_RATE_RATE_CONTROL_OFF = 0,
  CEC_AUDIO_RATE_STANDARD_RATE_100 = 1,
  CEC_AUDIO_RATE_FAST_RATE_MAX_101 = 2,
  CEC_AUDIO_RATE_SLOW_RATE_MIN_99 = 3,
  CEC_AUDIO_RATE_STANDARD_RATE_100_0 = 4,
  CEC_AUDIO_RATE_FAST_RATE_MAX_100_1 = 5,
  CEC_AUDIO_RATE_SLOW_RATE_MIN_99_9 = 6
} ECecAudioRate;

typedef enum
{
  CEC_AUDIO_MUTE_STATUS_MASK = 0x80,
  CEC_AUDIO_VOLUME_STATUS_MASK = 0x7F,
  CEC_AUDIO_VOLUME_MIN = 0x00,
  CEC_AUDIO_VOLUME_MAX = 0x64,
  CEC_AUDIO_VOLUME_STATUS_UNKNOWN = 0x7F
} ECecAudioStatus;

typedef enum
{
  CEC_FALSE = 0,
  CEC_TRUE = 1
} ECecBoolean;

typedef enum
{
  CEC_VERSION_1_2 = 0x01,
  CEC_VERSION_1_2A = 0x02,
  CEC_VERSION_1_3 = 0x03,
  CEC_VERSION_1_3A = 0x04
} ECecVersion;

typedef enum
{
  CEC_CHANNEL_NUMBER_FORMAT_MASK = 0xFC000000,
  CEC_1_PART_CHANNEL_NUMBER = 0x04000000,
  CEC_2_PART_CHANNEL_NUMBER = 0x08000000,
  CEC_MAJOR_CHANNEL_NUMBER_MASK = 0x3FF0000,
  CEC_MINOR_CHANNEL_NUMBER_MASK = 0xFFFF
} ECecChannelIdentifier;

typedef enum
{
  CEC_DESK_CONTROL_MODE_SKIP_FORWARD_WIND = 1,
  CEC_DESK_CONTROL_MODE_SKIP_REVERSE_REWIND = 2,
  CEC_DESK_CONTROL_MODE_STOP = 3,
  CEC_DESK_CONTROL_MODE_EJECT = 4
} ECecDeskControlMode;

typedef enum
{
  CEC_DECK_INFO_PLAY = 0x11,
  CEC_DECK_INFO_RECORD = 0x12,
  CEC_DECK_INFO_PLAY_REVERSE = 0x13,
  CEC_DECK_INFO_STILL = 0x14,
  CEC_DECK_INFO_SLOW = 0x15,
  CEC_DECK_INFO_SLOW_REVERSE = 0x16,
  CEC_DECK_INFO_FAST_FORWARD = 0x17,
  CEC_DECK_INFO_FAST_REVERSE = 0x18,
  CEC_DECK_INFO_NO_MEDIA = 0x19,
  CEC_DECK_INFO_STOP = 0x1A,
  CEC_DECK_INFO_SKIP_FORWARD_WIND = 0x1B,
  CEC_DECK_INFO_SKIP_REVERSE_REWIND = 0x1C,
  CEC_DECK_INFO_INDEX_SEARCH_FORWARD = 0x1D,
  CEC_DECK_INFO_INDEX_SEARCH_REVERSE = 0x1E,
  CEC_DECK_INFO_OTHER_STATUS = 0x1F
} ECecDeckInfo;

typedef enum
{
  CEC_DEVICE_TYPE_TV = 0,
  CEC_DEVICE_TYPE_RECORDING_DEVICE = 1,
  CEC_DEVICE_TYPE_RESERVED = 2,
  CEC_DEVICE_TYPE_TUNER = 3,
  CEC_DEVICE_TYPE_PLAYBACK_DEVICE = 4,
  CEC_DEVICE_TYPE_AUDIO_SYSTEM = 5
} ECecDeviceType;

typedef enum
{
  CEC_DISPLAY_CONTROL_DISPLAY_FOR_DEFAULT_TIME = 0x00,
  CEC_DISPLAY_CONTROL_DISPLAY_UNTIL_CLEARED = 0x40,
  CEC_DISPLAY_CONTROL_CLEAR_PREVIOUS_MESSAGE = 0x80,
  CEC_DISPLAY_CONTROL_RESERVED_FOR_FUTURE_USE = 0xC0
} ECecDisplayControl;

typedef enum
{
  CEC_EXTERNAL_SOURCE_SPECIFIER_EXTERNAL_PLUG = 4,
  CEC_EXTERNAL_SOURCE_SPECIFIER_EXTERNAL_PHYSICAL_ADDRESS = 5
} ECecExternalSourceSpecifier;

typedef enum
{
  CEC_MENU_REQUEST_TYPE_ACTIVATE = 0,
  CEC_MENU_REQUEST_TYPE_DEACTIVATE = 1,
  CEC_MENU_REQUEST_TYPE_QUERY = 2
} ECecMenuRequestType;

typedef enum
{
  CEC_MENU_STATE_ACTIVATED = 0,
  CEC_MENU_STATE_DEACTIVATED = 1
} ECecMenuState;

typedef enum
{
  CEC_PLAY_MODE_PLAY_FORWARD = 0x24,
  CEC_PLAY_MODE_PLAY_REVERSE = 0x20,
  CEC_PLAY_MODE_PLAY_STILL = 0x25,
  CEC_PLAY_MODE_FAST_FORWARD_MIN_SPEED = 0x05,
  CEC_PLAY_MODE_FAST_FORWARD_MEDIUM_SPEED = 0x06,
  CEC_PLAY_MODE_FAST_FORWARD_MAX_SPEED = 0x07,
  CEC_PLAY_MODE_FAST_REVERSE_MIN_SPEED = 0x09,
  CEC_PLAY_MODE_FAST_REVERSE_MEDIUM_SPEED = 0x0A,
  CEC_PLAY_MODE_FAST_REVERSE_MAX_SPEED = 0x0B,
  CEC_PLAY_MODE_SLOW_FORWARD_MIN_SPEED = 0x15,
  CEC_PLAY_MODE_SLOW_FORWARD_MEDIUM_SPEED = 0x16,
  CEC_PLAY_MODE_SLOW_FORWARD_MAX_SPEED = 0x17,
  CEC_PLAY_MODE_SLOW_REVERSE_MIN_SPEED = 0x19,
  CEC_PLAY_MODE_SLOW_REVERSE_MEDIUM_SPEED = 0x1A,
  CEC_PLAY_MODE_SLOW_REVERSE_MAX_SPEED = 0x1B
} ECecPlayMode;

typedef enum
{
  CEC_POWER_STATUS_ON = 0x00,
  CEC_POWER_STATUS_STANDBY = 0x01,
  CEC_POWER_STATUS_IN_TRANSITION_STANDBY_TO_ON = 0x02,
  CEC_POWER_STATUS_IN_TRANSITION_ON_TO_STANDBY = 0x03
} ECecPowerStatus;

typedef enum
{
  CEC_RECORD_SOURCE_TYPE_OWN_SOURCE = 1,
  CEC_RECORD_SOURCE_TYPE_DIGITAL_SERVICE = 2,
  CEC_RECORD_SOURCE_TYPE_ANALOGUE_SERVICE = 3,
  CEC_RECORD_SOURCE_TYPE_EXTERNAL_PLUS = 4,
  CEC_RECORD_SOURCE_TYPE_EXTERNAL_PHYSICAL_ADDRESS = 5
} ECecRecordSourceType;

typedef enum
{
  CEC_RECORD_STATUS_INFO_RECORDING_CURRENTLY_SELECTED_SOURCE = 0x01,
  CEC_RECORD_STATUS_INFO_RECORDING_DIGITAL_SERVICE = 0x02,
  CEC_RECORD_STATUS_INFO_RECORDING_ANALOGUE_SERVICE = 0x03,
  CEC_RECORD_STATUS_INFO_RECORDING_EXTERNAL_INPUT = 0x04,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_UNABLE_TO_RECORD_DIGITAL_SERVICE = 0x05,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_UNABLE_TO_RECORD_ANALOGUE_SERVICE = 0x06,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_UNABLE_TO_SELECT_REQUIRED_SERVICE = 0x07,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_INVALID_EXTERNAL_PLUG_NUMBER = 0x09,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_INVALID_EXTERNAL_ADDRESS = 0x0A,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_CA_SYSTEM_NOT_SUPPORTED = 0x0B,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_NO_OR_INSUFFICIENT_ENTITLEMENTS = 0x0C,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_NOT_ALLOWED_TO_COPY_SOURCE = 0x0D,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_NO_FURTHER_COPIES_ALLOWED = 0x0E,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_NO_MEDIA = 0x10,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_PLAYING = 0x11,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_ALREADY_RECORDING = 0x12,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_MEDIA_PROTECTED = 0x13,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_NO_SOURCE_SIGNAL = 0x14,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_MEDIA_PROBLEM = 0x15,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_NOT_ENOUGH_SPACE_AVAILABLE = 0x16,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_PARENTAL_LOCK_ON = 0x17,
  CEC_RECORD_STATUS_INFO_RECORDING_TERMINATED_NORMALLY = 0x1A,
  CEC_RECORD_STATUS_INFO_RECORDING_HAS_ALREADY_TERMINATED = 0x1B,
  CEC_RECORD_STATUS_INFO_NO_RECORDING_OTHER_REASON = 0x1F
} ECecRecordStatusInfo;

typedef enum
{
  CEC_RECORDING_SEQUENCE_SUNDAY = 0x01,
  CEC_RECORDING_SEQUENCE_MONDAY = 0x02,
  CEC_RECORDING_SEQUENCE_TUESDAY = 0x04,
  CEC_RECORDING_SEQUENCE_WEDNESDAY = 0x08,
  CEC_RECORDING_SEQUENCE_THURSDAY = 0x10,
  CEC_RECORDING_SEQUENCE_FRIDAY = 0x20,
  CEC_RECORDING_SEQUENCE_SATURDAY = 0x40,
  CEC_RECORDING_SEQUENCE_ONCE_ONLY = 0x00
} ECecRecordingSequence;

typedef enum
{
  CEC_STATUS_REQUEST_ON = 1,
  CEC_STATUS_REQUEST_OFF = 2,
  CEC_STATUS_REQUEST_ONCE = 3
} ECecStatusRequest;

typedef enum
{
  CEC_SYSTEM_AUDIO_STATUS_OFF = 0,
  CEC_SYSTEM_AUDIO_STATUS_ON = 1
} ECecSystemAudioStatus;

typedef enum
{
  CEC_TIMER_CLEARED_STATUS_DATA_TIMER_NOT_CLEARED_RECORDING = 0x00,
  CEC_TIMER_CLEARED_STATUS_DATA_TIMER_NOT_CLEARED_NO_MATCHING = 0x01,
  CEC_TIMER_CLEARED_STATUS_DATA_TIMER_NOT_CLEARED_NO_INF0_AVAILABLE = 0x02,
  CEC_TIMER_CLEARED_STATUS_DATA_TIMER_CLEARED = 0x80
} ECecTimerClearedStatusData;

typedef enum
{
  CEC_TIMER_OVERLAP_WARNING_NO_OVERLAP = 0,
  CEC_TIMER_OVERLAP_WARNING_TIMER_BLOCKS_OVERLAP = 1
} ECecTimerOverlapWarning;

typedef enum
{
  CEC_MEDIA_INFO_MEDIA_PRESENT_AND_NOT_PROTECTED = 0x00,
  CEC_MEDIA_INFO_MEDIA_PRESENT_BUT_PROTECTED = 0x01,
  CEC_MEDIA_INFO_MEDIA_NOT_PRESENT = 0x02,
  CEC_MEDIA_INFO_FUTURE_USE = 0x03
} ECecMediaInfo;

typedef enum
{
  CEC_PROGRAMMED_INDICATOR_NOT_PROGRAMMED = 0,
  CEC_PROGRAMMED_INDICATOR_PROGRAMMED = 1
} ECecProgrammedIndicator;

typedef enum
{
  CEC_PROGRAMMED_INFO_FUTURE_USE = 0x0,
  CEC_PROGRAMMED_INFO_ENOUGH_SPACE_AVAILABLE_FOR_RECORDING = 0x08,
  CEC_PROGRAMMED_INFO_NOT_ENOUGH_SPACE_AVAILABLE_FOR_RECORDING = 0x09,
  CEC_PROGRAMMED_INFO_MAY_NOT_BE_ENOUGH_SPACE_AVAILABLE = 0x0B,
  CEC_PROGRAMMED_INFO_NO_MEDIA_INFO_AVAILABLE = 0x0A
} ECecProgrammedInfo;

typedef enum
{
  CEC_NOT_PROGRAMMED_ERROR_INFO_FUTURE_USE = 0x0,
  CEC_NOT_PROGRAMMED_ERROR_INFO_NO_FREE_TIMER_AVAILABLE = 0x01,
  CEC_NOT_PROGRAMMED_ERROR_INFO_DATE_OUT_OF_RANGE = 0x02,
  CEC_NOT_PROGRAMMED_ERROR_INFO_RECORDING_SEQUENCE_ERROR = 0x03,
  CEC_NOT_PROGRAMMED_ERROR_INFO_INVALID_EXTERNAL_PLUG_NUMBER = 0x04,
  CEC_NOT_PROGRAMMED_ERROR_INFO_INVALID_EXTERNAL_PHYSICAL_ADDRESS = 0x05,
  CEC_NOT_PROGRAMMED_ERROR_INFO_CA_SYSTEM_NOT_SUPPORTED = 0x06,
  CEC_NOT_PROGRAMMED_ERROR_INFO_NO_OR_INSUFFICIENT_CA_ENTITLEMENTS = 0x07,
  CEC_NOT_PROGRAMMED_ERROR_INFO_DOES_NOT_SUPPORT_RESOLUTION = 0x08,
  CEC_NOT_PROGRAMMED_ERROR_INFO_PARENTAL_LOCK_ON = 0x09,
  CEC_NOT_PROGRAMMED_ERROR_INFO_CLOCK_FAILURE = 0x0A,
  CEC_NOT_PROGRAMMED_ERROR_INFO_RESERVED_FOR_FUTURE_USE_START = 0x0B,
  CEC_NOT_PROGRAMMED_ERROR_INFO_RESERVED_FOR_FUTURE_USE_END = 0x0D,
  CEC_NOT_PROGRAMMED_ERROR_INFO_DUPLICATE_ALREADY_PROGRAMMED = 0x0E
} ECecNotProgrammedErrorInfo;

typedef enum
{
  CEC_RECORDING_FLAG_NOT_BEING_USED_FOR_RECORDING = 0,
  CEC_RECORDING_FLAG_BEING_USED_FOR_RECORDING = 1
} ECecRecordingFlag;

typedef enum
{
  CEC_TUNER_DISPLAY_INFO_DISPLAYING_DIGITAL_TUNER = 0,
  CEC_TUNER_DISPLAY_INFO_NOT_DISPLAYING_TUNER = 1,
  CEC_TUNER_DISPLAY_INFO_DISPLAYING_ANALOGUE_TUNER = 2
} ECecTunerDisplayInfo;


typedef enum
{
  CEC_BROADCAST_SYSTEM_PAL_B_G = 0,
  CEC_BROADCAST_SYSTEM_SECAM_L1 = 1,
  CEC_BROADCAST_SYSTEM_PAL_M = 2,
  CEC_BROADCAST_SYSTEM_NTSC_M = 3,
  CEC_BROADCAST_SYSTEM_PAL_I = 4,
  CEC_BROADCAST_SYSTEM_SECAM_DK = 5,
  CEC_BROADCAST_SYSTEM_SECAM_B_G = 6,
  CEC_BROADCAST_SYSTEM_SECAM_L2 = 7,
  CEC_BROADCAST_SYSTEM_PAL_DK = 8,
  CEC_BROADCAST_SYSTEM_OTHER_SYSTEM = 30
} ECecBroadcastSystem;

#define MSGSTART                     0xFF
#define MSGEND                       0xFE
#define MSGESC                       0xFD
#define ESCOFFSET                    3
