/* client functions auto-generated by pidl */

#include "includes.h"
#include <tevent.h>
#include "lib/util/tevent_ntstatus.h"
#include "librpc/gen_ndr/ndr_oxidresolver.h"
#include "librpc/gen_ndr/ndr_oxidresolver_c.h"

/* IOXIDResolver - client functions generated by pidl */

struct dcerpc_ResolveOxid_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ResolveOxid_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ResolveOxid_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ResolveOxid *r)
{
	struct tevent_req *req;
	struct dcerpc_ResolveOxid_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ResolveOxid_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_RESOLVEOXID, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ResolveOxid_r_done, req);

	return req;
}

static void dcerpc_ResolveOxid_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ResolveOxid_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ResolveOxid_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ResolveOxid_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ResolveOxid_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ResolveOxid *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_RESOLVEOXID, mem_ctx, r);

	return status;
}

struct dcerpc_ResolveOxid_state {
	struct ResolveOxid orig;
	struct ResolveOxid tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ResolveOxid_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ResolveOxid_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   uint64_t _pOxid /* [in]  */,
					   uint16_t _cRequestedProtseqs /* [in]  */,
					   uint16_t *_arRequestedProtseqs /* [in] [size_is(cRequestedProtseqs)] */,
					   struct DUALSTRINGARRAY **_ppdsaOxidBindings /* [out] [ref] */,
					   struct GUID *_pipidRemUnknown /* [out] [ref] */,
					   uint32_t *_pAuthnHint /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_ResolveOxid_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ResolveOxid_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pOxid = _pOxid;
	state->orig.in.cRequestedProtseqs = _cRequestedProtseqs;
	state->orig.in.arRequestedProtseqs = _arRequestedProtseqs;

	/* Out parameters */
	state->orig.out.ppdsaOxidBindings = _ppdsaOxidBindings;
	state->orig.out.pipidRemUnknown = _pipidRemUnknown;
	state->orig.out.pAuthnHint = _pAuthnHint;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ResolveOxid_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ResolveOxid_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ResolveOxid_done, req);
	return req;
}

static void dcerpc_ResolveOxid_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ResolveOxid_state *state = tevent_req_data(
		req, struct dcerpc_ResolveOxid_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ResolveOxid_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.ppdsaOxidBindings = *state->tmp.out.ppdsaOxidBindings;
	*state->orig.out.pipidRemUnknown = *state->tmp.out.pipidRemUnknown;
	*state->orig.out.pAuthnHint = *state->tmp.out.pAuthnHint;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ResolveOxid_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dcerpc_ResolveOxid_state *state = tevent_req_data(
		req, struct dcerpc_ResolveOxid_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ResolveOxid(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    uint64_t _pOxid /* [in]  */,
			    uint16_t _cRequestedProtseqs /* [in]  */,
			    uint16_t *_arRequestedProtseqs /* [in] [size_is(cRequestedProtseqs)] */,
			    struct DUALSTRINGARRAY **_ppdsaOxidBindings /* [out] [ref] */,
			    struct GUID *_pipidRemUnknown /* [out] [ref] */,
			    uint32_t *_pAuthnHint /* [out] [ref] */,
			    WERROR *result)
{
	struct ResolveOxid r;
	NTSTATUS status;

	/* In parameters */
	r.in.pOxid = _pOxid;
	r.in.cRequestedProtseqs = _cRequestedProtseqs;
	r.in.arRequestedProtseqs = _arRequestedProtseqs;

	status = dcerpc_ResolveOxid_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_ppdsaOxidBindings = *r.out.ppdsaOxidBindings;
	*_pipidRemUnknown = *r.out.pipidRemUnknown;
	*_pAuthnHint = *r.out.pAuthnHint;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_SimplePing_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_SimplePing_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_SimplePing_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct SimplePing *r)
{
	struct tevent_req *req;
	struct dcerpc_SimplePing_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_SimplePing_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_SIMPLEPING, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_SimplePing_r_done, req);

	return req;
}

static void dcerpc_SimplePing_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_SimplePing_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_SimplePing_r_state *state =
		tevent_req_data(req,
		struct dcerpc_SimplePing_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_SimplePing_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct SimplePing *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_SIMPLEPING, mem_ctx, r);

	return status;
}

struct dcerpc_SimplePing_state {
	struct SimplePing orig;
	struct SimplePing tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_SimplePing_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_SimplePing_send(TALLOC_CTX *mem_ctx,
					  struct tevent_context *ev,
					  struct dcerpc_binding_handle *h,
					  uint64_t *_SetId /* [in] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_SimplePing_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_SimplePing_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.SetId = _SetId;

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_SimplePing_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_SimplePing_done, req);
	return req;
}

static void dcerpc_SimplePing_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_SimplePing_state *state = tevent_req_data(
		req, struct dcerpc_SimplePing_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_SimplePing_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_SimplePing_recv(struct tevent_req *req,
				TALLOC_CTX *mem_ctx,
				WERROR *result)
{
	struct dcerpc_SimplePing_state *state = tevent_req_data(
		req, struct dcerpc_SimplePing_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_SimplePing(struct dcerpc_binding_handle *h,
			   TALLOC_CTX *mem_ctx,
			   uint64_t *_SetId /* [in] [ref] */,
			   WERROR *result)
{
	struct SimplePing r;
	NTSTATUS status;

	/* In parameters */
	r.in.SetId = _SetId;

	status = dcerpc_SimplePing_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ComplexPing_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ComplexPing_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ComplexPing_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ComplexPing *r)
{
	struct tevent_req *req;
	struct dcerpc_ComplexPing_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ComplexPing_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_COMPLEXPING, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ComplexPing_r_done, req);

	return req;
}

static void dcerpc_ComplexPing_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ComplexPing_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ComplexPing_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ComplexPing_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ComplexPing_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ComplexPing *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_COMPLEXPING, mem_ctx, r);

	return status;
}

struct dcerpc_ComplexPing_state {
	struct ComplexPing orig;
	struct ComplexPing tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ComplexPing_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ComplexPing_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h,
					   uint64_t *_SetId /* [in,out] [ref] */,
					   uint16_t _SequenceNum /* [in]  */,
					   uint16_t _cAddToSet /* [in]  */,
					   uint16_t _cDelFromSet /* [in]  */,
					   struct GUID *_AddToSet /* [in] [size_is(cAddToSet)] */,
					   struct GUID *_DelFromSet /* [in] [size_is(cDelFromSet)] */,
					   uint16_t *_PingBackoffFactor /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_ComplexPing_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ComplexPing_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.SetId = _SetId;
	state->orig.in.SequenceNum = _SequenceNum;
	state->orig.in.cAddToSet = _cAddToSet;
	state->orig.in.cDelFromSet = _cDelFromSet;
	state->orig.in.AddToSet = _AddToSet;
	state->orig.in.DelFromSet = _DelFromSet;

	/* Out parameters */
	state->orig.out.SetId = _SetId;
	state->orig.out.PingBackoffFactor = _PingBackoffFactor;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ComplexPing_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ComplexPing_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ComplexPing_done, req);
	return req;
}

static void dcerpc_ComplexPing_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ComplexPing_state *state = tevent_req_data(
		req, struct dcerpc_ComplexPing_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ComplexPing_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.SetId = *state->tmp.out.SetId;
	*state->orig.out.PingBackoffFactor = *state->tmp.out.PingBackoffFactor;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ComplexPing_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dcerpc_ComplexPing_state *state = tevent_req_data(
		req, struct dcerpc_ComplexPing_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ComplexPing(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    uint64_t *_SetId /* [in,out] [ref] */,
			    uint16_t _SequenceNum /* [in]  */,
			    uint16_t _cAddToSet /* [in]  */,
			    uint16_t _cDelFromSet /* [in]  */,
			    struct GUID *_AddToSet /* [in] [size_is(cAddToSet)] */,
			    struct GUID *_DelFromSet /* [in] [size_is(cDelFromSet)] */,
			    uint16_t *_PingBackoffFactor /* [out] [ref] */,
			    WERROR *result)
{
	struct ComplexPing r;
	NTSTATUS status;

	/* In parameters */
	r.in.SetId = _SetId;
	r.in.SequenceNum = _SequenceNum;
	r.in.cAddToSet = _cAddToSet;
	r.in.cDelFromSet = _cDelFromSet;
	r.in.AddToSet = _AddToSet;
	r.in.DelFromSet = _DelFromSet;

	status = dcerpc_ComplexPing_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_SetId = *r.out.SetId;
	*_PingBackoffFactor = *r.out.PingBackoffFactor;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ServerAlive_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ServerAlive_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ServerAlive_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ServerAlive *r)
{
	struct tevent_req *req;
	struct dcerpc_ServerAlive_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ServerAlive_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = NULL;

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_SERVERALIVE, state, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ServerAlive_r_done, req);

	return req;
}

static void dcerpc_ServerAlive_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ServerAlive_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ServerAlive_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ServerAlive_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ServerAlive_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ServerAlive *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_SERVERALIVE, mem_ctx, r);

	return status;
}

struct dcerpc_ServerAlive_state {
	struct ServerAlive orig;
	struct ServerAlive tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ServerAlive_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ServerAlive_send(TALLOC_CTX *mem_ctx,
					   struct tevent_context *ev,
					   struct dcerpc_binding_handle *h)
{
	struct tevent_req *req;
	struct dcerpc_ServerAlive_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ServerAlive_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ServerAlive_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ServerAlive_done, req);
	return req;
}

static void dcerpc_ServerAlive_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ServerAlive_state *state = tevent_req_data(
		req, struct dcerpc_ServerAlive_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ServerAlive_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ServerAlive_recv(struct tevent_req *req,
				 TALLOC_CTX *mem_ctx,
				 WERROR *result)
{
	struct dcerpc_ServerAlive_state *state = tevent_req_data(
		req, struct dcerpc_ServerAlive_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ServerAlive(struct dcerpc_binding_handle *h,
			    TALLOC_CTX *mem_ctx,
			    WERROR *result)
{
	struct ServerAlive r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_ServerAlive_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ResolveOxid2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ResolveOxid2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ResolveOxid2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ResolveOxid2 *r)
{
	struct tevent_req *req;
	struct dcerpc_ResolveOxid2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ResolveOxid2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_RESOLVEOXID2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ResolveOxid2_r_done, req);

	return req;
}

static void dcerpc_ResolveOxid2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ResolveOxid2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ResolveOxid2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ResolveOxid2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ResolveOxid2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ResolveOxid2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_RESOLVEOXID2, mem_ctx, r);

	return status;
}

struct dcerpc_ResolveOxid2_state {
	struct ResolveOxid2 orig;
	struct ResolveOxid2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ResolveOxid2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ResolveOxid2_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    uint64_t _pOxid /* [in]  */,
					    uint16_t _cRequestedProtseqs /* [in]  */,
					    uint16_t *_arRequestedProtseqs /* [in] [size_is(cRequestedProtseqs)] */,
					    struct DUALSTRINGARRAY **_pdsaOxidBindings /* [out] [ref] */,
					    struct GUID *_ipidRemUnknown /* [out] [ref] */,
					    uint32_t *_AuthnHint /* [out] [ref] */,
					    struct COMVERSION *_ComVersion /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_ResolveOxid2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ResolveOxid2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */
	state->orig.in.pOxid = _pOxid;
	state->orig.in.cRequestedProtseqs = _cRequestedProtseqs;
	state->orig.in.arRequestedProtseqs = _arRequestedProtseqs;

	/* Out parameters */
	state->orig.out.pdsaOxidBindings = _pdsaOxidBindings;
	state->orig.out.ipidRemUnknown = _ipidRemUnknown;
	state->orig.out.AuthnHint = _AuthnHint;
	state->orig.out.ComVersion = _ComVersion;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ResolveOxid2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ResolveOxid2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ResolveOxid2_done, req);
	return req;
}

static void dcerpc_ResolveOxid2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ResolveOxid2_state *state = tevent_req_data(
		req, struct dcerpc_ResolveOxid2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ResolveOxid2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.pdsaOxidBindings = *state->tmp.out.pdsaOxidBindings;
	*state->orig.out.ipidRemUnknown = *state->tmp.out.ipidRemUnknown;
	*state->orig.out.AuthnHint = *state->tmp.out.AuthnHint;
	*state->orig.out.ComVersion = *state->tmp.out.ComVersion;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ResolveOxid2_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  WERROR *result)
{
	struct dcerpc_ResolveOxid2_state *state = tevent_req_data(
		req, struct dcerpc_ResolveOxid2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ResolveOxid2(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     uint64_t _pOxid /* [in]  */,
			     uint16_t _cRequestedProtseqs /* [in]  */,
			     uint16_t *_arRequestedProtseqs /* [in] [size_is(cRequestedProtseqs)] */,
			     struct DUALSTRINGARRAY **_pdsaOxidBindings /* [out] [ref] */,
			     struct GUID *_ipidRemUnknown /* [out] [ref] */,
			     uint32_t *_AuthnHint /* [out] [ref] */,
			     struct COMVERSION *_ComVersion /* [out] [ref] */,
			     WERROR *result)
{
	struct ResolveOxid2 r;
	NTSTATUS status;

	/* In parameters */
	r.in.pOxid = _pOxid;
	r.in.cRequestedProtseqs = _cRequestedProtseqs;
	r.in.arRequestedProtseqs = _arRequestedProtseqs;

	status = dcerpc_ResolveOxid2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_pdsaOxidBindings = *r.out.pdsaOxidBindings;
	*_ipidRemUnknown = *r.out.ipidRemUnknown;
	*_AuthnHint = *r.out.AuthnHint;
	*_ComVersion = *r.out.ComVersion;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

struct dcerpc_ServerAlive2_r_state {
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ServerAlive2_r_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ServerAlive2_r_send(TALLOC_CTX *mem_ctx,
	struct tevent_context *ev,
	struct dcerpc_binding_handle *h,
	struct ServerAlive2 *r)
{
	struct tevent_req *req;
	struct dcerpc_ServerAlive2_r_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ServerAlive2_r_state);
	if (req == NULL) {
		return NULL;
	}

	state->out_mem_ctx = talloc_new(state);
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	subreq = dcerpc_binding_handle_call_send(state, ev, h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_SERVERALIVE2, state->out_mem_ctx, r);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ServerAlive2_r_done, req);

	return req;
}

static void dcerpc_ServerAlive2_r_done(struct tevent_req *subreq)
{
	struct tevent_req *req =
		tevent_req_callback_data(subreq,
		struct tevent_req);
	NTSTATUS status;

	status = dcerpc_binding_handle_call_recv(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	tevent_req_done(req);
}

NTSTATUS dcerpc_ServerAlive2_r_recv(struct tevent_req *req, TALLOC_CTX *mem_ctx)
{
	struct dcerpc_ServerAlive2_r_state *state =
		tevent_req_data(req,
		struct dcerpc_ServerAlive2_r_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	talloc_steal(mem_ctx, state->out_mem_ctx);

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ServerAlive2_r(struct dcerpc_binding_handle *h, TALLOC_CTX *mem_ctx, struct ServerAlive2 *r)
{
	NTSTATUS status;

	status = dcerpc_binding_handle_call(h,
			NULL, &ndr_table_IOXIDResolver,
			NDR_SERVERALIVE2, mem_ctx, r);

	return status;
}

struct dcerpc_ServerAlive2_state {
	struct ServerAlive2 orig;
	struct ServerAlive2 tmp;
	TALLOC_CTX *out_mem_ctx;
};

static void dcerpc_ServerAlive2_done(struct tevent_req *subreq);

struct tevent_req *dcerpc_ServerAlive2_send(TALLOC_CTX *mem_ctx,
					    struct tevent_context *ev,
					    struct dcerpc_binding_handle *h,
					    struct COMINFO *_info /* [out] [ref] */,
					    struct DUALSTRINGARRAY *_dualstring /* [out] [ref] */,
					    uint8_t *_unknown2 /* [out] [ref] */,
					    uint8_t *_unknown3 /* [out] [ref] */,
					    uint8_t *_unknown4 /* [out] [ref] */)
{
	struct tevent_req *req;
	struct dcerpc_ServerAlive2_state *state;
	struct tevent_req *subreq;

	req = tevent_req_create(mem_ctx, &state,
				struct dcerpc_ServerAlive2_state);
	if (req == NULL) {
		return NULL;
	}
	state->out_mem_ctx = NULL;

	/* In parameters */

	/* Out parameters */
	state->orig.out.info = _info;
	state->orig.out.dualstring = _dualstring;
	state->orig.out.unknown2 = _unknown2;
	state->orig.out.unknown3 = _unknown3;
	state->orig.out.unknown4 = _unknown4;

	/* Result */
	ZERO_STRUCT(state->orig.out.result);

	state->out_mem_ctx = talloc_named_const(state, 0,
			     "dcerpc_ServerAlive2_out_memory");
	if (tevent_req_nomem(state->out_mem_ctx, req)) {
		return tevent_req_post(req, ev);
	}

	/* make a temporary copy, that we pass to the dispatch function */
	state->tmp = state->orig;

	subreq = dcerpc_ServerAlive2_r_send(state, ev, h, &state->tmp);
	if (tevent_req_nomem(subreq, req)) {
		return tevent_req_post(req, ev);
	}
	tevent_req_set_callback(subreq, dcerpc_ServerAlive2_done, req);
	return req;
}

static void dcerpc_ServerAlive2_done(struct tevent_req *subreq)
{
	struct tevent_req *req = tevent_req_callback_data(
		subreq, struct tevent_req);
	struct dcerpc_ServerAlive2_state *state = tevent_req_data(
		req, struct dcerpc_ServerAlive2_state);
	NTSTATUS status;
	TALLOC_CTX *mem_ctx;

	if (state->out_mem_ctx) {
		mem_ctx = state->out_mem_ctx;
	} else {
		mem_ctx = state;
	}

	status = dcerpc_ServerAlive2_r_recv(subreq, mem_ctx);
	TALLOC_FREE(subreq);
	if (!NT_STATUS_IS_OK(status)) {
		tevent_req_nterror(req, status);
		return;
	}

	/* Copy out parameters */
	*state->orig.out.info = *state->tmp.out.info;
	*state->orig.out.dualstring = *state->tmp.out.dualstring;
	*state->orig.out.unknown2 = *state->tmp.out.unknown2;
	*state->orig.out.unknown3 = *state->tmp.out.unknown3;
	*state->orig.out.unknown4 = *state->tmp.out.unknown4;

	/* Copy result */
	state->orig.out.result = state->tmp.out.result;

	/* Reset temporary structure */
	ZERO_STRUCT(state->tmp);

	tevent_req_done(req);
}

NTSTATUS dcerpc_ServerAlive2_recv(struct tevent_req *req,
				  TALLOC_CTX *mem_ctx,
				  WERROR *result)
{
	struct dcerpc_ServerAlive2_state *state = tevent_req_data(
		req, struct dcerpc_ServerAlive2_state);
	NTSTATUS status;

	if (tevent_req_is_nterror(req, &status)) {
		tevent_req_received(req);
		return status;
	}

	/* Steal possible out parameters to the callers context */
	talloc_steal(mem_ctx, state->out_mem_ctx);

	/* Return result */
	*result = state->orig.out.result;

	tevent_req_received(req);
	return NT_STATUS_OK;
}

NTSTATUS dcerpc_ServerAlive2(struct dcerpc_binding_handle *h,
			     TALLOC_CTX *mem_ctx,
			     struct COMINFO *_info /* [out] [ref] */,
			     struct DUALSTRINGARRAY *_dualstring /* [out] [ref] */,
			     uint8_t *_unknown2 /* [out] [ref] */,
			     uint8_t *_unknown3 /* [out] [ref] */,
			     uint8_t *_unknown4 /* [out] [ref] */,
			     WERROR *result)
{
	struct ServerAlive2 r;
	NTSTATUS status;

	/* In parameters */

	status = dcerpc_ServerAlive2_r(h, mem_ctx, &r);
	if (!NT_STATUS_IS_OK(status)) {
		return status;
	}

	/* Return variables */
	*_info = *r.out.info;
	*_dualstring = *r.out.dualstring;
	*_unknown2 = *r.out.unknown2;
	*_unknown3 = *r.out.unknown3;
	*_unknown4 = *r.out.unknown4;

	/* Return result */
	*result = r.out.result;

	return NT_STATUS_OK;
}

