/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.common.programs;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Date;
import org.videolan.vlma.common.programs.IVlProgram;

public class VlProgram
implements IVlProgram,
Serializable {
    private Date liveStart;
    private int liveInterval;
    private int liveLength;
    private int liveRepetitions;
    private int priority;
    private String sapName;
    private InetAddress player;
    private InetAddress ip;
    private String sapGroup;
    private boolean broadcastState;

    public String getSapGroup() {
        return this.sapGroup;
    }

    public void setSapGroup(String sapGroup) {
        this.sapGroup = sapGroup;
    }

    public InetAddress getIp() {
        return this.ip;
    }

    public void setIp(InetAddress ip) {
        this.ip = ip;
    }

    public int getLiveInterval() {
        return this.liveInterval;
    }

    public void setLiveInterval(int liveInterval) {
        this.liveInterval = liveInterval;
    }

    public int getLiveLength() {
        return this.liveLength;
    }

    public void setLiveLength(int liveLength) {
        this.liveLength = liveLength;
    }

    public int getLiveRepetitions() {
        return this.liveRepetitions;
    }

    public void setLiveRepetitions(int liveRepetitions) {
        this.liveRepetitions = liveRepetitions;
    }

    public Date getLiveStart() {
        return this.liveStart;
    }

    public void setLiveStart(Date liveStart) {
        this.liveStart = liveStart;
    }

    public VlProgram() {
        this.setLiveInterval(-1);
        this.setLiveRepetitions(1);
        this.setLiveLength(-1);
        this.liveStart = new Date();
        this.setIp(null);
        this.setPriority(50);
        this.setPlayer(null);
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isTimeToPlay() {
        long now = System.currentTimeMillis();
        long when = this.getLiveStart().getTime();
        if (this.getLiveInterval() > 0) {
            return now >= when && (now - when) % (long)this.getLiveInterval() < (long)this.getLiveLength();
        }
        return now >= when;
    }

    public InetAddress getPlayer() {
        return this.player;
    }

    public String getPlayerHostName() {
        return this.player.getHostName();
    }

    public void setPlayer(InetAddress player) {
        this.player = player;
    }

    public String getSapName() {
        return this.sapName;
    }

    public void setSapName(String sapName) {
        this.sapName = sapName;
    }

    public void setBroadcastState(boolean broadcastStateGiven) {
        this.broadcastState = broadcastStateGiven;
    }

    public boolean getBroadcastState() {
        return this.broadcastState;
    }
}

