/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.awt.EventQueue;
import java.io.File;
import java.util.LinkedList;
import javax.tv.xlet.Xlet;
import org.dvb.application.AppID;
import org.dvb.application.AppStateChangeEvent;
import org.dvb.application.AppStateChangeEventListener;
import org.dvb.application.DVBJProxy;
import org.videolan.BDJClassLoader;
import org.videolan.BDJXletContext;
import org.videolan.Logger;

class BDJAppProxy
implements DVBJProxy,
Runnable {
    private BDJXletContext context;
    private Xlet xlet;
    private int state;
    private LinkedList listeners = new LinkedList();
    private LinkedList cmds = new LinkedList();
    private Thread thread;
    private static final Logger logger = Logger.getLogger(BDJAppProxy.class.getName());

    protected static BDJAppProxy newInstance(BDJXletContext context) {
        BDJAppProxy proxy = new BDJAppProxy(context);
        proxy.startThread();
        return proxy;
    }

    private void startThread() {
        this.thread = new Thread(this.context.getThreadGroup(), this, "BDJAppProxy");
        this.thread.setDaemon(true);
        this.thread.start();
        while (this.context.getEventQueue() == null) {
            Thread.yield();
        }
    }

    private BDJAppProxy(BDJXletContext context) {
        this.context = context;
        this.state = 2;
    }

    public int getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        AppCommand cmd = new AppCommand(0, null);
        LinkedList linkedList = this.cmds;
        synchronized (linkedList) {
            this.cmds.addLast(cmd);
            this.cmds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        AppCommand cmd = new AppCommand(1, null);
        LinkedList linkedList = this.cmds;
        synchronized (linkedList) {
            this.cmds.addLast(cmd);
            this.cmds.notifyAll();
        }
    }

    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String[] args) {
        AppCommand cmd = new AppCommand(2, args);
        LinkedList linkedList = this.cmds;
        synchronized (linkedList) {
            this.cmds.addLast(cmd);
            this.cmds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean force, int timeout) {
        AppCommand cmd = new AppCommand(3, new Boolean(force));
        LinkedList linkedList = this.cmds;
        synchronized (linkedList) {
            this.cmds.addLast(cmd);
            this.cmds.notifyAll();
        }
        if (timeout > 0 && !cmd.waitDone(timeout)) {
            logger.error("stop() timeout: Xlet " + this.context.getThreadGroup().getName());
        }
    }

    public void stop(boolean force) {
        this.stop(force, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        AppCommand cmd = new AppCommand(4, null);
        LinkedList linkedList = this.cmds;
        synchronized (linkedList) {
            this.cmds.addLast(cmd);
            this.cmds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        AppCommand cmd = new AppCommand(5, null);
        LinkedList linkedList = this.cmds;
        synchronized (linkedList) {
            this.cmds.addLast(cmd);
            this.cmds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDestroyed() {
        AppCommand cmd = new AppCommand(6, null);
        LinkedList linkedList = this.cmds;
        synchronized (linkedList) {
            this.cmds.addLast(cmd);
            this.cmds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyPaused() {
        AppCommand cmd = new AppCommand(7, null);
        LinkedList linkedList = this.cmds;
        synchronized (linkedList) {
            this.cmds.addLast(cmd);
            this.cmds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        AppCommand cmd = new AppCommand(3, new Boolean(true));
        LinkedList linkedList = this.cmds;
        synchronized (linkedList) {
            this.cmds.addLast(cmd);
            this.cmds.addLast(null);
            this.cmds.notifyAll();
        }
        if (!cmd.waitDone(5000)) {
            logger.error("release(): STOP timeout, killing Xlet " + this.context.getThreadGroup().getName());
        }
        String persistentOrg = System.getProperty("dvb.persistent.root") + File.separator + (String)this.context.getXletProperty("dvb.org.id") + File.separator;
        String persistentApp = persistentOrg + (String)this.context.getXletProperty("dvb.app.id");
        this.context.release();
        if (new File(persistentApp).delete()) {
            new File(persistentOrg).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppStateChangeEventListener(AppStateChangeEventListener listener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppStateChangeEventListener(AppStateChangeEventListener listener) {
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(int fromState, int toState, boolean hasFailed) {
        LinkedList list;
        LinkedList linkedList = this.listeners;
        synchronized (linkedList) {
            list = (LinkedList)this.listeners.clone();
        }
        AppStateChangeEvent event = new AppStateChangeEvent((AppID)this.context.getXletProperty("org.dvb.application.appid"), fromState, toState, this, hasFailed);
        for (int i = 0; i < list.size(); ++i) {
            ((AppStateChangeEventListener)list.get(i)).stateChange(event);
        }
    }

    protected BDJXletContext getXletContext() {
        return this.context;
    }

    private boolean doLoad() {
        if (this.state == 2) {
            try {
                this.xlet = ((BDJClassLoader)this.context.getClassLoader()).loadXlet();
                this.state = 5;
                return true;
            }
            catch (Throwable e) {
                logger.error("doLoad() failed: " + e + "\n" + Logger.dumpStack(e));
                this.state = 8;
            }
        }
        return false;
    }

    private boolean doInit() {
        if (this.state == 2 && !this.doLoad()) {
            return false;
        }
        if (this.state == 5) {
            try {
                String persistent = System.getProperty("dvb.persistent.root") + File.separator + (String)this.context.getXletProperty("dvb.org.id") + File.separator + (String)this.context.getXletProperty("dvb.app.id");
                new File(persistent).mkdirs();
                this.xlet.initXlet(this.context);
                this.state = 3;
                return true;
            }
            catch (Throwable e) {
                logger.error("doInit() failed: " + e + "\n" + Logger.dumpStack(e));
                this.state = 8;
            }
        }
        return false;
    }

    private boolean doStart(String[] args) {
        if (!(this.state != 2 && this.state != 5 || this.doInit())) {
            return false;
        }
        if (this.state == 3) {
            try {
                if (args != null) {
                    this.context.setArgs(args);
                }
                this.xlet.startXlet();
                this.state = 0;
                return true;
            }
            catch (Throwable e) {
                logger.error("doStart() failed: " + e + "\n" + Logger.dumpStack(e));
                this.state = 8;
            }
        }
        return false;
    }

    private boolean doStop(boolean force) {
        if (this.state == 8) {
            return false;
        }
        if (this.state != 2 && this.state != 5) {
            try {
                this.xlet.destroyXlet(force);
                this.context.closeSockets();
                this.context.getThreadGroup().waitForShutdown(1000, 1 + this.context.numEventQueueThreads());
                this.context.exitXlet();
            }
            catch (Throwable e) {
                logger.error("doStop() failed: " + e + "\n" + Logger.dumpStack(e));
                this.state = 8;
                return false;
            }
        }
        this.xlet = null;
        this.state = 1;
        return true;
    }

    private boolean doPause() {
        if (this.state == 0) {
            try {
                this.xlet.pauseXlet();
                this.state = 3;
                return true;
            }
            catch (Throwable e) {
                logger.error("doPause() failed: " + e + "\n" + Logger.dumpStack(e));
                this.state = 8;
            }
        }
        return false;
    }

    private boolean doResume() {
        if (this.state == 3) {
            try {
                this.xlet.startXlet();
                this.state = 0;
                return true;
            }
            catch (Throwable e) {
                logger.error("doResume() failed: " + e + "\n" + Logger.dumpStack(e));
                this.state = 8;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.context.getEventQueue() == null) {
            this.context.setEventQueue(new EventQueue());
        }
        while (true) {
            boolean ret;
            int toState;
            AppCommand cmd;
            LinkedList linkedList = this.cmds;
            synchronized (linkedList) {
                while (this.cmds.isEmpty()) {
                    try {
                        this.cmds.wait();
                    }
                    catch (InterruptedException e) {}
                }
                cmd = (AppCommand)this.cmds.removeFirst();
            }
            if (cmd == null) {
                return;
            }
            int fromState = this.state;
            switch (cmd.getCommand()) {
                case 0: {
                    toState = 5;
                    ret = this.doLoad();
                    break;
                }
                case 1: {
                    toState = 3;
                    ret = this.doInit();
                    break;
                }
                case 2: {
                    toState = 0;
                    Object args = cmd.getArgument();
                    ret = this.doStart(args == null ? null : (String[])args);
                    break;
                }
                case 3: {
                    toState = 1;
                    ret = this.doStop((Boolean)cmd.getArgument());
                    break;
                }
                case 4: {
                    toState = 3;
                    ret = this.doPause();
                    break;
                }
                case 5: {
                    toState = 0;
                    ret = this.doResume();
                    break;
                }
                case 6: {
                    toState = 1;
                    this.state = 1;
                    ret = true;
                    break;
                }
                case 7: {
                    toState = 3;
                    this.state = 3;
                    ret = true;
                    break;
                }
                default: {
                    return;
                }
            }
            this.notifyListeners(fromState, toState, !ret);
            cmd.release();
            if (this.state != 1) continue;
            this.state = 2;
        }
    }

    private class AppCommand {
        public static final int CMD_LOAD = 0;
        public static final int CMD_INIT = 1;
        public static final int CMD_START = 2;
        public static final int CMD_STOP = 3;
        public static final int CMD_PAUSE = 4;
        public static final int CMD_RESUME = 5;
        public static final int CMD_NOTIFY_DESTROYED = 6;
        public static final int CMD_NOTIFY_PAUSED = 7;
        private int cmd;
        private Object arg;
        private boolean done = false;

        public AppCommand(int cmd, Object arg) {
            this.cmd = cmd;
            this.arg = arg;
        }

        public int getCommand() {
            return this.cmd;
        }

        public Object getArgument() {
            return this.arg;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitDone(int timeoutMs) {
            AppCommand appCommand = this;
            synchronized (appCommand) {
                while (!this.done) {
                    try {
                        if (timeoutMs < 1) {
                            this.wait();
                            continue;
                        }
                        this.wait(timeoutMs);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                return this.done;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            AppCommand appCommand = this;
            synchronized (appCommand) {
                this.done = true;
                this.notifyAll();
            }
        }
    }
}

