/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.text.DecimalFormat;

public class TitleInfo {
    private int title;
    private int objType;
    private int playbackType;
    private String bdjoName = null;
    private int hdmvOID = -1;
    public static final int OBJ_TYPE_HDMV = 1;
    public static final int OBJ_TYPE_BDJ = 2;
    public static final int HDMV_PLAYBACK_TYPE_MOVIE = 0;
    public static final int HDMV_PLAYBACK_TYPE_INTERACTIVE = 1;
    public static final int BDJ_PLAYBACK_TYPE_MOVIE = 2;
    public static final int BDJ_PLAYBACK_TYPE_INTERACTIVE = 3;

    public TitleInfo(int title, int objType, int playbackType, int idRef) {
        this.title = title;
        this.objType = objType;
        this.playbackType = playbackType;
        if (objType == 2) {
            this.bdjoName = new DecimalFormat("00000").format(idRef);
        } else {
            this.hdmvOID = idRef;
        }
    }

    public int getTitleNum() {
        return this.title;
    }

    public int getPlaybackType() {
        return this.playbackType;
    }

    public String getBdjoName() {
        return this.bdjoName;
    }

    public int getHdmvOID() {
        return this.hdmvOID;
    }

    public boolean isBdj() {
        return this.objType == 2;
    }

    public boolean isHdmv() {
        return this.objType == 1;
    }
}

