/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.40 from the
 * contents of Brotli.xs. Do not edit this file, edit Brotli.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "Brotli.xs"
#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include <brotli/decode.h>
#include <brotli/encode.h>

#define BUFFER_SIZE 1048576

typedef struct brotli_decoder {
    BrotliDecoderState *decoder;
}* IO__Uncompress__Brotli;

typedef struct brotli_encoder {
    BrotliEncoderState *encoder;
}* IO__Compress__Brotli;


#line 32 "Brotli.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 176 "Brotli.c"

XS_EUPXS(XS_IO__Uncompress__Brotli_unbro); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_IO__Uncompress__Brotli_unbro)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "buffer, decoded_size");
    {
	SV*	buffer = ST(0)
;
	size_t	decoded_size = (size_t)SvUV(ST(1))
;
#line 30 "Brotli.xs"
    STRLEN encoded_size;
    uint8_t *encoded_buffer, *decoded_buffer;
#line 192 "Brotli.c"
	SV *	RETVAL;
#line 33 "Brotli.xs"
    encoded_buffer = (uint8_t*) SvPV(buffer, encoded_size);
    Newx(decoded_buffer, decoded_size, uint8_t);
    if(!BrotliDecoderDecompress(encoded_size, encoded_buffer, &decoded_size, decoded_buffer)){
        croak("Error in BrotliDecoderDecompress");
    }
    RETVAL = newSV(0);
    sv_usepvn(RETVAL, decoded_buffer, decoded_size);
#line 202 "Brotli.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_IO__Uncompress__Brotli_create); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_IO__Uncompress__Brotli_create)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	SV*	class = ST(0)
;
	IO__Uncompress__Brotli	RETVAL;
#line 47 "Brotli.xs"
    Newx(RETVAL, 1, struct brotli_decoder);
    RETVAL->decoder = BrotliDecoderCreateInstance(NULL, NULL, NULL);
#line 223 "Brotli.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "IO::Uncompress::Brotli", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_IO__Uncompress__Brotli_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_IO__Uncompress__Brotli_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	IO__Uncompress__Brotli	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(IO__Uncompress__Brotli,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"IO::Uncompress::Brotli::DESTROY",
			"self")
;
#line 56 "Brotli.xs"
    BrotliDecoderDestroyInstance(self->decoder);
    Safefree(self);
#line 256 "Brotli.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_IO__Uncompress__Brotli_decompress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_IO__Uncompress__Brotli_decompress)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, in");
    {
	IO__Uncompress__Brotli	self;
	SV*	in = ST(1)
;
#line 64 "Brotli.xs"
    uint8_t *next_in, *next_out, *buffer;
    size_t available_in, available_out;
    BrotliDecoderResult result;
#line 276 "Brotli.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "IO::Uncompress::Brotli")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(IO__Uncompress__Brotli,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			"IO::Uncompress::Brotli::decompress",
			"self", "IO::Uncompress::Brotli")
;
#line 68 "Brotli.xs"
    next_in = (uint8_t*) SvPV(in, available_in);
    Newx(buffer, BUFFER_SIZE, uint8_t);
    RETVAL = newSVpv("", 0);
    result = BROTLI_DECODER_RESULT_NEEDS_MORE_OUTPUT;
    while(result == BROTLI_DECODER_RESULT_NEEDS_MORE_OUTPUT) {
        next_out = buffer;
        available_out=BUFFER_SIZE;
        result = BrotliDecoderDecompressStream( self->decoder,
                                                &available_in,
                                                (const uint8_t**) &next_in,
                                                &available_out,
                                                &next_out,
                                                NULL );
        if(!result){
            Safefree(buffer);
            croak("Error in BrotliDecoderDecompressStream");
        }
        sv_catpvn(RETVAL, (const char*)buffer, BUFFER_SIZE-available_out);
    }
    Safefree(buffer);
#line 309 "Brotli.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_IO__Compress__Brotli_bro); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_IO__Compress__Brotli_bro)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "buffer, quality=BROTLI_DEFAULT_QUALITY, lgwin=BROTLI_DEFAULT_WINDOW");
    {
	SV*	buffer = ST(0)
;
	U32	quality;
	U32	lgwin;
#line 101 "Brotli.xs"
    size_t encoded_size;
    STRLEN decoded_size;
    uint8_t *encoded_buffer, *decoded_buffer;
    BROTLI_BOOL result;
#line 333 "Brotli.c"
	SV *	RETVAL;

	if (items < 2)
	    quality = BROTLI_DEFAULT_QUALITY;
	else {
	    quality = (unsigned long)SvUV(ST(1))
;
	}

	if (items < 3)
	    lgwin = BROTLI_DEFAULT_WINDOW;
	else {
	    lgwin = (unsigned long)SvUV(ST(2))
;
	}
#line 106 "Brotli.xs"
    if( quality < BROTLI_MIN_QUALITY || quality > BROTLI_MAX_QUALITY ) {
        croak("Invalid quality value");
    }
    if( lgwin < BROTLI_MIN_WINDOW_BITS || lgwin > BROTLI_MAX_WINDOW_BITS ) {
        croak("Invalid window value");
    }
    decoded_buffer = (uint8_t*) SvPV(buffer, decoded_size);
    encoded_size = BrotliEncoderMaxCompressedSize(decoded_size);
    if(!encoded_size){
        croak("Compressed size overflow");
    }
    Newx(encoded_buffer, encoded_size+1, uint8_t);
    result = BrotliEncoderCompress( quality,
                                    lgwin,
                                    BROTLI_DEFAULT_MODE,
                                    decoded_size,
                                    decoded_buffer,
                                    &encoded_size,
                                    encoded_buffer );
    if(!result){
        Safefree(buffer);
        croak("Error in BrotliEncoderCompress");
    }
    encoded_buffer[encoded_size]=0;
    RETVAL = newSV(0);
    sv_usepvn_flags(RETVAL, encoded_buffer, encoded_size, SV_SMAGIC | SV_HAS_TRAILING_NUL);
#line 376 "Brotli.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_IO__Compress__Brotli_create); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_IO__Compress__Brotli_create)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
	SV*	class = ST(0)
;
	IO__Compress__Brotli	RETVAL;
#line 139 "Brotli.xs"
    Newx(RETVAL, 1, struct brotli_encoder);
    RETVAL->encoder = BrotliEncoderCreateInstance(NULL, NULL, NULL);
#line 397 "Brotli.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "IO::Compress::Brotli", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_IO__Compress__Brotli_BrotliEncoderSetParameter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_IO__Compress__Brotli_BrotliEncoderSetParameter)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, value");
    {
	IO__Compress__Brotli	self;
	U32	value = (unsigned long)SvUV(ST(1))
;
#line 152 "Brotli.xs"
    BrotliEncoderParameter param;
#line 422 "Brotli.c"
	bool	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "IO::Compress::Brotli")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(IO__Compress__Brotli,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			GvNAME(CvGV(cv)),
			"self", "IO::Compress::Brotli")
;
#line 154 "Brotli.xs"
    switch(ix){
    case 0:
        croak("BrotliEncoderSetParameter may not be called directly");
        break;
    case 1:
        if( value < BROTLI_MIN_WINDOW_BITS || value > BROTLI_MAX_WINDOW_BITS ) {
            croak("Invalid window value");
        }
        param = BROTLI_PARAM_LGWIN;
        break;
    case 2:
        if( value < BROTLI_MIN_QUALITY || value > BROTLI_MAX_QUALITY ) {
            croak("Invalid quality value");
        }
        param = BROTLI_PARAM_QUALITY;
        break;
    case 3:
        /* Validation done on Perl side */
        param = BROTLI_PARAM_MODE;
        break;
    default:
        croak("Impossible ix in BrotliEncoderSetParameter");
        break;
    }
#line 459 "Brotli.c"

	RETVAL = BrotliEncoderSetParameter(self->encoder, param, value);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_IO__Compress__Brotli__compress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_IO__Compress__Brotli__compress)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, in = &PL_sv_undef");
    {
	IO__Compress__Brotli	self;
	SV*	in;
#line 190 "Brotli.xs"
    uint8_t *next_in, *next_out, *buffer;
    size_t available_in, available_out;
    BROTLI_BOOL result;
    BrotliEncoderOperation op;
#line 483 "Brotli.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "IO::Compress::Brotli")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(IO__Compress__Brotli,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not of type %s",
			GvNAME(CvGV(cv)),
			"self", "IO::Compress::Brotli")
;

	if (items < 2)
	    in = &PL_sv_undef;
	else {
	    in = ST(1)
;
	}
#line 195 "Brotli.xs"
    switch(ix) {
    case 0:
        croak("_compress may not be called directly");
        break;
    case 1:
        op = BROTLI_OPERATION_PROCESS;
        break;
    case 2:
        op = BROTLI_OPERATION_FLUSH;
        break;
    case 3:
        op = BROTLI_OPERATION_FINISH;
        break;
    default:
        croak("Impossible ix in _compress");
        break;
    }

    Newx(buffer, BUFFER_SIZE, uint8_t);
    if(in == &PL_sv_undef)
        next_in = (uint8_t*) buffer, available_in = 0;
    else
        next_in = (uint8_t*) SvPV(in, available_in);
    RETVAL = newSVpv("", 0);
    while(1) {
        next_out = buffer;
        available_out = BUFFER_SIZE;
        result = BrotliEncoderCompressStream( self->encoder,
                                              (BrotliEncoderOperation) op,
                                              &available_in,
                                              (const uint8_t**) &next_in,
                                              &available_out,
                                              &next_out,
                                              NULL );
        if(!result) {
            Safefree(buffer);
            croak("Error in BrotliEncoderCompressStream");
        }

        if( available_out != BUFFER_SIZE ) {
            sv_catpvn(RETVAL, (const char*)buffer, BUFFER_SIZE-available_out);
        }

        if(
            BrotliEncoderIsFinished(self->encoder) ||
            (!available_in && !BrotliEncoderHasMoreOutput(self->encoder))
        ) break;
    }
    Safefree(buffer);
#line 552 "Brotli.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_IO__Compress__Brotli_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_IO__Compress__Brotli_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	IO__Compress__Brotli	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(IO__Compress__Brotli,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"IO::Compress::Brotli::DESTROY",
			"self")
;
#line 251 "Brotli.xs"
    BrotliEncoderDestroyInstance(self->encoder);
    Safefree(self);
#line 581 "Brotli.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_IO__Compress__Brotli); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_IO__Compress__Brotli)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("IO::Uncompress::Brotli::unbro", XS_IO__Uncompress__Brotli_unbro, file, "$$");
        (void)newXSproto_portable("IO::Uncompress::Brotli::create", XS_IO__Uncompress__Brotli_create, file, "$");
        (void)newXSproto_portable("IO::Uncompress::Brotli::DESTROY", XS_IO__Uncompress__Brotli_DESTROY, file, "$");
        (void)newXSproto_portable("IO::Uncompress::Brotli::decompress", XS_IO__Uncompress__Brotli_decompress, file, "$$");
        (void)newXSproto_portable("IO::Compress::Brotli::bro", XS_IO__Compress__Brotli_bro, file, "$;$$");
        (void)newXSproto_portable("IO::Compress::Brotli::create", XS_IO__Compress__Brotli_create, file, "$");
        cv = newXSproto_portable("IO::Compress::Brotli::BrotliEncoderSetParameter", XS_IO__Compress__Brotli_BrotliEncoderSetParameter, file, "$$");
        XSANY.any_i32 = 0;
        cv = newXSproto_portable("IO::Compress::Brotli::_mode", XS_IO__Compress__Brotli_BrotliEncoderSetParameter, file, "$$");
        XSANY.any_i32 = 3;
        cv = newXSproto_portable("IO::Compress::Brotli::quality", XS_IO__Compress__Brotli_BrotliEncoderSetParameter, file, "$$");
        XSANY.any_i32 = 2;
        cv = newXSproto_portable("IO::Compress::Brotli::window", XS_IO__Compress__Brotli_BrotliEncoderSetParameter, file, "$$");
        XSANY.any_i32 = 1;
        cv = newXSproto_portable("IO::Compress::Brotli::_compress", XS_IO__Compress__Brotli__compress, file, "$;$");
        XSANY.any_i32 = 0;
        cv = newXSproto_portable("IO::Compress::Brotli::compress", XS_IO__Compress__Brotli__compress, file, "$;$");
        XSANY.any_i32 = 1;
        cv = newXSproto_portable("IO::Compress::Brotli::finish", XS_IO__Compress__Brotli__compress, file, "$;$");
        XSANY.any_i32 = 3;
        cv = newXSproto_portable("IO::Compress::Brotli::flush", XS_IO__Compress__Brotli__compress, file, "$;$");
        XSANY.any_i32 = 2;
        (void)newXSproto_portable("IO::Compress::Brotli::DESTROY", XS_IO__Compress__Brotli_DESTROY, file, "$");
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

