<?php
/**
 * This file display the additional tools
 *
 * This file is part of the b2evolution/evocms project - {@link http://b2evolution.net/}.
 * See also {@link https://github.com/b2evolution/b2evolution}.
 *
 * @license GNU GPL v2 - {@link http://b2evolution.net/about/gnu-gpl-license}
 *
 * @copyright (c)2003-2020 by Francois Planque - {@link http://fplanque.com/}.
 * Parts of this file are copyright (c)2005 by Daniel HAHLER - {@link http://thequod.de/contact}.
 *
 * @package admin
 */

if( !defined('EVO_MAIN_INIT') ) die( 'Please, do not access this page directly.' );

global $Plugins, $template_log_title, $template_action, $admin_url;
global $deferred_AdminToolActions;

$block_item_Widget = new Widget( 'block_item' );
$show_back_button = true;

if( !empty( $template_action ) )
{ // Execute action inside template to display a process in real rime
	$block_item_Widget->title = isset( $template_log_title ) ? T_('Log for').': '.$template_log_title : T_('Log');
	$block_item_Widget->disp_template_replaced( 'block_start' );

	// Turn off the output buffering to do the correct work of the function flush()
	@ini_set( 'output_buffering', 'off' );
	evo_flush();

	switch( $template_action )
	{
		case 'del_itemprecache':
			// Clear pre-rendered item cache (DB)
			dbm_delete_itemprecache();
			break;

		case 'del_commentprecache':
			// Clear pre-rendered comment cache (DB)
			dbm_delete_commentprecache();
			break;

		case 'del_messageprecache':
			// Clear pre-rendered message cache (DB)
			dbm_delete_messageprecache();
			break;

		case 'del_pagecache':
			// Delete the page cache /blogs/cache
			dbm_delete_pagecache();
			break;

		case 'del_filecache':
			// delete the thumbnail cahces .evocache
			dbm_delete_filecache();
			break;

		case 'repair_cache':
			// Repair cache
			dbm_repair_cache();
			break;



		case 'optimize_tables':
			// Optimize MyISAM & InnoDB tables
			dbm_optimize_tables();
			break;

		case 'check_tables':
			// Check ALL database tables
			dbm_check_tables();
			break;

		case 'analyze_tables':
			// Analize ALL database tables
			dbm_analyze_tables();
			break;

		case 'delete_orphan_comments':
			// delete orphan orphan comments with no matching Item
			dbm_delete_orphan_comments();
			break;

		case 'delete_orphan_comment_uploads':
			// delete orphan comment upload, older than 24 hours
			dbm_delete_orphan_comment_uploads();
			break;

		case 'delete_orphan_files':
			// delete orphan File objects with no matching file on disk:
			$delete_files = param( 'delete_files', 'integer' ); // Should we try to delete the found orphan files?
			$delete_linked = param( 'delete_linked', 'integer' ); // Should we delete the found orphan files together with links?
			dbm_delete_orphan_files( $delete_files, $delete_linked );
			break;

		case 'delete_orphan_file_roots':
			// delete orphan file roots with no matching Blog or User entry in the database
			dbm_delete_orphan_file_roots();
			break;

		case 'prune_hits_sessions':
			// Prune old hits & sessions
			load_class( 'sessions/model/_hitlist.class.php', 'Hitlist' );
			$result = Hitlist::dbprune( false, false ); // will prune once per day, according to Settings
			print_log( nl2br( $result['message'] ), $result['result'] );
			break;

		case 'recreate_itemslugs':
			// Recreate all item slugs (change title-[0-9] canonical slugs to a slug generated from current title). Old slugs will still work, but redirect to the new one.
			dbm_recreate_itemslugs();
			break;

		case 'recreate_autogenerated_excerpts':
			// Re-create all autogenerated excerpts
			dbm_recreate_autogenerated_excerpts();
			break;

		case 'convert_item_content_separators':
			// Convert item content separators to new format
			dbm_convert_item_content_separators();
			break;

		case 'delete_item_versions':
			// Delete all item versions
			dbm_delete_item_versions();
			break;

		case 'resize_all_images':
			// Resize all images in the media directory
			tool_resize_all_images();
			break;

		case 'del_broken_posts':
			// Delete all broken posts that have no matching category
			dbm_delete_broken_posts();
			break;

		case 'utf8check':
			// CHECK DB tables for expecting COLLATION
			db_check_utf8_ascii( false );
			?>
			<p>
				<a href="<?php echo regenerate_url( 'action', 'action=utf8upgrade&amp;'.url_crumb( 'tools' ) ); ?>" class="btn btn-primary"><?php echo T_('Proceed with normalization procedure!'); ?></a>
				<a href="<?php echo $admin_url; ?>?ctrl=tools" class="btn btn-default"><?php echo T_('Cancel'); ?></a>
			</p>
			<?php
			break;

		case 'utf8upgrade':
			// Upgrade DB to UTF-8
			db_upgrade_to_utf8_ascii( false );
			break;

		case 'deferred_admin_tool_action':
			foreach( $deferred_AdminToolActions as $plugin_ID => $method )
			{
				$plugin_params = array();
				$Plugins->call_method( $plugin_ID, $method, $plugin_params );
			}
			break;
	}
	$block_item_Widget->disp_template_raw( 'block_end' );
}


if( check_user_perm( 'users', 'edit' ) && empty( $action ) )
{ // Setting to lock system
	global $Settings;

	$Form = new Form( NULL, 'settings_checkchanges' );
	$Form->begin_form( 'fform' );

	$Form->add_crumb( 'tools' );
	$Form->hidden( 'ctrl', 'tools' );
	$Form->hidden( 'action', 'update_tools' );

	$Form->begin_fieldset( T_('Locking down b2evolution for maintenance, upgrade or server switching...').get_manual_link('system-lock') );

		$Form->checkbox_input( 'system_lock', $Settings->get('system_lock'), T_('Lock system'), array(
				'note' => T_('check this to prevent login (except for admins) and sending comments/messages. This prevents the DB from receiving updates (other than logging)').'<br />'.
				          T_('Note: for a more complete lock down, rename the file /conf/_maintenance.html to /conf/maintenance.html (complete lock) or /conf/imaintenance.html (gives access to /install)') ) );

	if( check_user_perm( 'options', 'edit' ) )
	{
		$Form->buttons( array( array( 'submit', 'submit', T_('Save Changes!'), 'SaveButton' ) ) );
	}

	$Form->end_fieldset();

	$Form->end_form();
}

// TODO: dh> this should really be a separate permission.. ("tools", "exec") or similar!
if( check_user_perm( 'options', 'edit' ) )
{ // default admin actions:
	global $Settings;

	if( empty( $action ) )
	{
		$block_item_Widget->title = T_('Cache management');
		// dh> TODO: add link to delete all caches at once?
		$block_item_Widget->disp_template_replaced( 'block_start' );
		echo '<ul>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=del_itemprecache&amp;'.url_crumb( 'tools' ) ).'">'.T_('Clear pre-rendered item cache (DB)').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=del_commentprecache&amp;'.url_crumb( 'tools' ) ).'">'.T_('Clear pre-rendered comment cache (DB)').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=del_messageprecache&amp;'.url_crumb( 'tools' ) ).'">'.T_('Clear pre-rendered message cache (DB)').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=del_filecache&amp;'.url_crumb( 'tools' ) ).'">'.T_('Clear thumbnail caches (_evocache directories)').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=del_pagecache&amp;'.url_crumb( 'tools' ) ).'">'.T_('Clear full page caches (/_cache/* directories)').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=repair_cache&amp;'.url_crumb( 'tools' ) ).'">'.T_('Repair /_cache/* directory structure').'</a></li>';
		echo '</ul>';
		$block_item_Widget->disp_template_raw( 'block_end' );
	}

	if( empty( $action ) )
	{
		$block_item_Widget->title = T_('Database management');
		$block_item_Widget->disp_template_replaced( 'block_start' );
		echo '<ul>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=check_tables&amp;'.url_crumb( 'tools' ) ).'">'.T_('CHECK database tables').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=optimize_tables&amp;'.url_crumb( 'tools' ) ).'">'.T_('OPTIMIZE database tables').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=analyze_tables&amp;'.url_crumb( 'tools' ) ).'">'.T_('ANALYZE database tables').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=utf8check&amp;'.url_crumb( 'tools' ) ).'">'.T_('Check/Convert/Normalize the charsets/collations used by the DB (UTF-8 / ASCII)').'</a></li>';
		// echo '<li><a href="'.regenerate_url('action', 'action=backup_db').'">'.T_('Backup database').'</a></li>';
		echo '</ul>';
		$block_item_Widget->disp_template_raw( 'block_end' );
	}

	if( empty( $action ) )
	{
		$block_item_Widget->title = T_('Cleanup tools');
		$block_item_Widget->disp_template_replaced( 'block_start' );
		echo '<ul>';
		echo '<li><a href="'.$admin_url.'?ctrl=itemtags&amp;action=cleanup&amp;'.url_crumb( 'tag' ).'">'.T_('Find and delete all orphan Tag entries (not used anywhere) - DB only.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=find_broken_posts&amp;'.url_crumb( 'tools' ) ).'">'.T_('Find all broken posts (with no matching Category) + Option to delete with related objects - DB only.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=find_broken_slugs&amp;'.url_crumb( 'tools')).'">'.T_('Find all broken slugs (with no matching Item) + Option to delete - DB only.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=delete_orphan_comments&amp;'.url_crumb( 'tools' ) ).'">'.T_('Find and delete all orphan Comments (with no matching Item) - Disk &amp; DB.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=delete_orphan_comment_uploads&amp;'.url_crumb( 'tools' ) ).'">'.T_('Find and delete all orphan comment Uploads - Disk &amp; DB.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=show_orphan_files_form&amp;'.url_crumb( 'tools' ) ).'">'.T_('Find and delete all orphan File objects (with no matching file on disk) - DB only.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=delete_orphan_file_roots&amp;'.url_crumb( 'tools' ) ).'">'.T_('Find and delete all orphan file roots (with no matching Collection or User) and all of their content recursively - Disk &amp; DB.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=prune_hits_sessions&amp;'.url_crumb( 'tools' ) ).'">'.T_('Prune old hits &amp; sessions (includes OPTIMIZE) - DB only.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=recreate_itemslugs&amp;'.url_crumb( 'tools' ) ).'">'.T_('Recreate all item Slugs (change title-[0-9] canonical slugs to a slug generated from current title). Old slugs will still work, but will redirect to the new ones - DB only.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=recreate_autogenerated_excerpts&amp;'.url_crumb( 'tools' ) ).'">'.T_('Recreate autogenerated excerpts - DB only.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=convert_item_content_separators&amp;'.url_crumb( 'tools' ) ).'">'.T_('Convert item content separators to [teaserbreak] and [pagebreak] - DB only.').'</a></li>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=delete_item_versions&amp;'.url_crumb( 'tools' ) ).'">'.T_('Remove all Item version - DB only.').'</a></li>';
		echo '</ul>';
		$block_item_Widget->disp_template_raw( 'block_end' );
	}

	if( empty( $action ) )
	{
		$block_item_Widget->title = T_('Other tools');
		$block_item_Widget->disp_template_replaced( 'block_start' );
		echo '<ul>';
		echo '<li><a href="'.regenerate_url( 'action', 'action=resize_all_images&amp;'.url_crumb( 'tools' ) ).'">'.T_('Resize all images in the media directory').'</a></li>';
		echo '</ul>';
		$block_item_Widget->disp_template_raw( 'block_end' );
	}
}

// We should load GeoIP plugin here even if it is disabled now, because action 'geoip_download' may be requested
$Plugins->load_plugin_by_classname( 'geoip_plugin' );

// Event AdminToolPayload for each Plugin:
$tool_plugins = $Plugins->get_list_by_event( 'AdminToolPayload' );
foreach( $tool_plugins as $loop_Plugin )
{
	if( empty( $action ) || $loop_Plugin->is_plugin_action( $action ) && empty( $template_action ) )
	{
		$block_item_Widget->title = format_to_output( $loop_Plugin->name );
		$block_item_Widget->disp_template_replaced( 'block_start' );
		$params = array();
		$Plugins->call_method_if_active( $loop_Plugin->ID, 'AdminToolPayload', $params );
		$block_item_Widget->disp_template_raw( 'block_end' );
	}
}

if( ! empty( $action ) && in_array( $action, array( 'show_delete_item_versions', 'utf8check' ) ) )
{ // these actions do not require a back to tools menu button
		$show_back_button = false;
}

if( ! empty( $action ) && $show_back_button )
{
	echo '<div class="form-group">';
	echo '<a href="'.$admin_url.'?ctrl=tools" class="btn btn-primary">'.T_('Back to tools menu').'</a>';
	echo '</div>';
}

?>