<?php
require_once(dirname(__FILE__) . '/../../shell_tester.php');
require_once(dirname(__FILE__) . '/../../mock_objects.php');
require_once(dirname(__FILE__) . '/../../xml.php');
require_once(dirname(__FILE__) . '/../../autorun.php');

class VisualTestOfErrors extends UnitTestCase
{
    public function testErrorDisplay()
    {
        $this->dump('Four exceptions...');
        trigger_error('Default');
        trigger_error('Error', E_USER_ERROR);
        trigger_error('Warning', E_USER_WARNING);
        trigger_error('Notice', E_USER_NOTICE);
    }

    public function testErrorTrap()
    {
        $this->dump('Pass...');
        $this->expectError();
        trigger_error('Error');
    }
    
    public function testUnusedErrorExpectationsCauseFailures()
    {
        $this->dump('Two failures...');
        $this->expectError('Some error');
        $this->expectError();
    }

    public function testErrorTextIsSentImmediately()
    {
        $this->dump('One failure...');
        $this->expectError('Error');
        trigger_error('Error almost');
        $this->dump('This should lie between the two errors');
        trigger_error('Error after');
    }
}

class VisualTestOfExceptions extends UnitTestCase
{
    public function testExceptionTrap()
    {
        $this->dump('One exception...');
        $this->ouch();
        $this->fail('Should not be here');
    }

    public function testExceptionExpectationShowsErrorWhenNoException()
    {
        $this->dump('One failure...');
        $this->expectException('SomeException');
        $this->expectException('LaterException');
    }

    public function testExceptionExpectationShowsPassWhenException()
    {
        $this->dump('Pass...');
        $this->expectException();
        $this->ouch();
    }

    public function ouch()
    {
        eval('throw new Exception("Ouch!");');
    }
}

class OpaqueContainer
{
    private $stuff;
    private $value;

    public function __construct($value)
    {
        $this->value = $value;
    }
}

class VisualTestOfObjectComparison extends UnitTestCase
{
    public function testDifferenceBetweenPrivateMembersCanBeDescribed()
    {
        $this->assertIdentical(new OpaqueContainer(1), new OpaqueContainer(2));
    }
}
