#################################################
#
#  (C) 2011 Timothy Pearson
#  kb9vqf (AT) pearsoncomputing.net
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################


# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


check_type_size( "int" SIZEOF_INT BUILTIN_TYPES_ONLY )
check_type_size( "long" SIZEOF_LONG BUILTIN_TYPES_ONLY )

check_include_file( stdint.h HAVE_STDINT_H )
check_include_file( systems.h HAVE_SYSTEMS_H )
check_include_file( linux/inotify.h HAVE_INOTIFY )

check_function_exists( statvfs HAVE_STATVFS )

if (SQLITE_INCLUDE_DIR AND SQLITE_LIBRARIES)
    set(SQLITE_FOUND TRUE)
else (SQLITE_INCLUDE_DIR AND SQLITE_LIBRARIES)
 include(UsePkgConfig)
 pkgconfig(sqlite3 _sqliteincdir _sqlitelibdir _sqlitelinkflags _sqlitecflags)

 find_path(SQLITE_INCLUDE_DIR sqlite3.h
   ${_sqliteincdir}
   /usr/include
   /usr/local/include
  )
 find_library(SQLITE_LIBRARIES NAMES sqlite3
   PATHS
   ${_sqlitelibdir}
   /usr/lib
   /usr/local/lib
 )

 if (SQLITE_INCLUDE_DIR AND SQLITE_LIBRARIES)
   set(SQLITE_FOUND TRUE)
 endif (SQLITE_INCLUDE_DIR AND SQLITE_LIBRARIES)

 if (SQLITE_FOUND)
   message(STATUS "Found sqlite3: ${SQLITE_LIBRARIES}")
 else (SQLITE_FOUND)
   message(STATUS "Could not find sqlite3")
   add_definitions(-DNO_SQLITE3)
 endif (SQLITE_FOUND)

 mark_as_advanced(SQLITE_LIBRARIES SQLITE_INCLUDE_DIR)

endif (SQLITE_INCLUDE_DIR AND SQLITE_LIBRARIES)

set(SUBVERSIONFOUND)
set(SUBVERSION_ALL_LIBS)

include (CheckIncludeFiles)

#search libraries for UNIX
if (UNIX)

  macro(find_sub_lib targetvar libname)
    if (SUBVERSION_INSTALL_PATH)
        find_library(${targetvar} ${libname}
            PATHS
            ${SUBVERSION_INSTALL_PATH}/lib
            NO_DEFAULT_PATH
        )
    endif(SUBVERSION_INSTALL_PATH)
    find_library(${targetvar} ${libname}
        PATHS
        /usr/lib
        /usr/local/lib
        )
  endmacro(find_sub_lib)

  if (SUBVERSION_INSTALL_PATH)
    find_path(SUBVERSION_INCLUDE_DIR svn_client.h
        PATHS
        ${SUBVERSION_INSTALL_PATH}/include/subversion-1
        NO_DEFAULT_PATH
    )
  endif (SUBVERSION_INSTALL_PATH)
  find_path(SUBVERSION_INCLUDE_DIR svn_client.h
        /usr/include/subversion-1
        /usr/local/include/subversion-1)

  find_sub_lib(SUBVERSION_CLIENTLIB svn_client-1)
  find_sub_lib(SUBVERSION_REPOSITORYLIB svn_repos-1)
  find_sub_lib(SUBVERSION_WCLIB svn_wc-1)
  find_sub_lib(SUBVERSION_FSLIB svn_fs-1)
  find_sub_lib(SUBVERSION_SUBRLIB svn_subr-1)
  find_sub_lib(SUBVERSION_RALIB svn_ra-1)
  find_sub_lib(SUBVERSION_DIFFLIB svn_diff-1)

  find_program(APR_CONFIG NAMES apr-config apr-1-config
    PATHS
    /usr/local/apr/bin
  )

  find_program(APU_CONFIG NAMES apu-config apu-1-config
    PATHS
    /usr/local/apr/bin
  )

  if(NOT APR_CONFIG)
    message(SEND_ERROR "Error: no apr-config found")
  endif(NOT APR_CONFIG)

  if(NOT APU_CONFIG)
    message(SEND_ERROR "Error: no apu-config found")
  endif(NOT APU_CONFIG)

  execute_process(COMMAND ${APR_CONFIG} --includedir OUTPUT_VARIABLE APR_INCLUDE_DIR_INT)
  string(STRIP "${APR_INCLUDE_DIR_INT}" APR_INCLUDE_DIR_INT)

  pkg_search_module( APR apr-1 )
  if( NOT APR_FOUND )
    tde_message_fatal( "apr-1 is required, but was not found on your system" )
  endif( )

  execute_process(COMMAND ${APU_CONFIG} --includedir OUTPUT_VARIABLE APU_INCLUDE_DIR_INT)
  string(STRIP "${APU_INCLUDE_DIR_INT}" APU_INCLUDE_DIR_INT)
  set(APR_INCLUDE_DIR "${APR_INCLUDE_DIR_INT}" CACHE INTERNAL "")
  set(APU_INCLUDE_DIR "${APU_INCLUDE_DIR_INT}" CACHE INTERNAL "")

  execute_process(COMMAND ${APR_CONFIG} --cppflags OUTPUT_VARIABLE APR_CPP_FLAGS_INT)
  execute_process(COMMAND ${APU_CONFIG} --includes OUTPUT_VARIABLE APU_CPP_FLAGS_INT)
  string(STRIP "${APR_CPP_FLAGS_INT}" APR_CPP_FLAGS_INT)
  string(STRIP "${APU_CPP_FLAGS_INT}" APU_CPP_FLAGS_INT)
  set(APR_CPP_FLAGS "${APR_CPP_FLAGS_INT}" CACHE INTERNAL "")
  set(APU_CPP_FLAGS "${APU_CPP_FLAGS_INT}" CACHE INTERNAL "")

  execute_process(COMMAND ${APR_CONFIG} --ldflags --libs --link-ld OUTPUT_VARIABLE APR_EXTRA_LIBFLAGS_INT)
  execute_process(COMMAND ${APU_CONFIG} --ldflags --libs --link-ld OUTPUT_VARIABLE APU_EXTRA_LIBFLAGS_INT)
  string(STRIP "${APR_EXTRA_LIBFLAGS_INT}" APR_EXTRA_LIBFLAGS_INT)
  string(STRIP "${APU_EXTRA_LIBFLAGS_INT}" APU_EXTRA_LIBFLAGS_INT)
  set(APR_EXTRA_LIBFLAGS "${APR_EXTRA_LIBFLAGS_INT}" CACHE INTERNAL "")
  set(APU_EXTRA_LIBFLAGS "${APU_EXTRA_LIBFLAGS_INT}" CACHE INTERNAL "")

  check_include_files(execinfo.h HAS_BACKTRACE_H)

endif (UNIX)

#search libaries for Windows
if (WIN32)

  # search for pathes
  find_path (SUBVERSION_BIN_DIR svn.exe
    "$ENV{ProgramFiles}/Subversion/bin"
  )

  find_path (SUBVERSION_INCLUDE_DIR svn_client.h
    "$ENV{ProgramFiles}/Subversion/include"
  )

  find_path(APR_INCLUDE_DIR apr.h
    "$ENV{ProgramFiles}/Subversion/include/apr"
  )

  find_path(APU_INCLUDE_DIR apu.h
    "$ENV{ProgramFiles}/Subversion/include/apr-util"
  )

  # search for libraries
  find_library(APR_LIB libapr
    "$ENV{ProgramFiles}/Subversion/lib/apr"
  )

  find_library(APRICONV_LIB libapriconv
    "$ENV{ProgramFiles}/Subversion/lib/apr-iconv"
  )

  find_library(APU_LIB libaprutil
    "$ENV{ProgramFiles}/Subversion/lib/apr-util"
  )

  find_library(APU_XMLLIB xml
    "$ENV{ProgramFiles}/Subversion/lib/apr-util"
  )

  find_library(NEON_LIB libneon
    "$ENV{ProgramFiles}/Subversion/lib/neon"
  )

  find_library(NEON_ZLIBSTATLIB zlibstat
    "$ENV{ProgramFiles}/Subversion/lib/neon"
  )

  find_library(INTL3LIB intl3_svn
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(DB44_LIB libdb44
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_CLIENTLIB libsvn_client-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_DELTALIB libsvn_delta-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_DIFFLIB libsvn_diff-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_FSBASELIB libsvn_fs_base-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_FSFSLIB libsvn_fs_fs-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_FSUTILLIB libsvn_fs_util-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_FSLIB libsvn_fs-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_RALOCALLIB libsvn_ra_local-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_RANEONLIB libsvn_ra_neon-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_RASVNLIB libsvn_ra_svn-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_RALIB libsvn_ra-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_REPOSITORYLIB libsvn_repos-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_SUBRLIB libsvn_subr-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  find_library(SUBVERSION_WCLIB libsvn_wc-1
    "$ENV{ProgramFiles}/Subversion/lib"
  )

  set(APR_EXTRA_LIBFLAGS )
  set(APU_EXTRA_LIBFLAGS )


  # check found libraries
  if (NOT APR_LIB)
    message(SEND_ERROR "No apr lib found!")
  else (NOT APR_LIB)
    message(STATUS "Found apr lib: ${APR_LIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${APR_LIB})
  endif(NOT APR_LIB)

  if (NOT APRICONV_LIB)
    message(SEND_ERROR "No apriconv lib found!")
  else (NOT APRICONV_LIB)
    message(STATUS "Found apriconv lib: ${APRICONV_LIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${APRICONV_LIB})
  endif(NOT APRICONV_LIB)

  if (NOT APU_LIB)
    message(SEND_ERROR "No aprutil lib found!")
  else (NOT APU_LIB)
    message(STATUS "Found aprutil lib: ${APU_LIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${APU_LIB})
  endif(NOT APU_LIB)

  if (NOT APU_XMLLIB)
    message(SEND_ERROR "No xml lib found!")
  else (NOT APU_XMLLIB)
    message(STATUS "Found xml lib: ${APU_XMLLIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${APU_XMLLIB})
  endif(NOT APU_XMLLIB)

  if (NOT NEON_LIB)
    message(SEND_ERROR "No neon lib found!")
  else (NOT NEON_LIB)
    message(STATUS "Found neon lib: ${NEON_LIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${NEON_LIB})
  endif(NOT NEON_LIB)

  if (NOT NEON_ZLIBSTATLIB)
    message(SEND_ERROR "No zlibstat lib found!")
  else (NOT APRICONV_LIB)
    message(STATUS "Found zlibstat lib: ${NEON_ZLIBSTATLIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${NEON_ZLIBSTATLIB})
  endif(NOT NEON_ZLIBSTATLIB)

  if (NOT INTL3LIB)
    message(SEND_ERROR "No intl3 lib found!")
  else (NOT INTL3LIB)
    message(STATUS "Found intl3 lib: ${INTL3LIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${INTL3LIB})
  endif(NOT INTL3LIB)

  if (NOT DB44_LIB)
    message(SEND_ERROR "No db44 lib found!")
  else (NOT DB44_LIB)
    message(STATUS "Found db44 lib: ${DB44_LIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${DB44_LIB})
  endif(NOT DB44_LIB)

  if (NOT SUBVERSION_DELTALIB)
    message(SEND_ERROR "No subversion delta lib found!")
  else (NOT SUBVERSION_DELTALIB)
    message(STATUS "Found subversion delta lib: ${SUBVERSION_DELTALIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_DELTALIB})
  endif(NOT SUBVERSION_DELTALIB)

  if (NOT SUBVERSION_FSBASELIB)
    message(SEND_ERROR "No subversion fs base lib found!")
  else (NOT SUBVERSION_FSBASELIB)
    message(STATUS "Found subversion fs base lib: ${SUBVERSION_FSBASELIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_FSBASELIB})
  endif(NOT SUBVERSION_FSBASELIB)

  if (NOT SUBVERSION_FSFSLIB)
    message(SEND_ERROR "No subversion fs fs lib found!")
  else (NOT SUBVERSION_FSFSLIB)
    message(STATUS "Found subversion fs fs lib: ${SUBVERSION_FSFSLIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_FSFSLIB})
  endif(NOT SUBVERSION_FSFSLIB)

  if (NOT SUBVERSION_FSUTILLIB)
    message(SEND_ERROR "No subversion fs util lib found!")
  else (NOT SUBVERSION_FSUTILLIB)
    message(STATUS "Found subversion fs util lib: ${SUBVERSION_FSUTILLIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_FSUTILLIB})
  endif(NOT SUBVERSION_FSUTILLIB)

  if (NOT SUBVERSION_RALOCALLIB)
    message(SEND_ERROR "No subversion ra local lib found!")
  else (NOT SUBVERSION_RALOCALLIB)
    message(STATUS "Found subversion ra local lib: ${SUBVERSION_RALOCALLIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_RALOCALLIB})
  endif(NOT SUBVERSION_RALOCALLIB)

  if (NOT SUBVERSION_RANEONLIB)
    message(SEND_ERROR "No subversion ra neon lib found!")
  else (NOT SUBVERSION_RANEONLIB)
    message(STATUS "Found subversion ra neon lib: ${SUBVERSION_RANEONLIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_RANEONLIB})
  endif(NOT SUBVERSION_RANEONLIB)

  if (NOT SUBVERSION_RASVNLIB)
    message(SEND_ERROR "No subversion ra svn lib found!")
  else (NOT SUBVERSION_RASVNLIB)
    message(STATUS "Found subversion ra svn lib: ${SUBVERSION_RASVNLIB}")
    set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_RASVNLIB})
  endif(NOT SUBVERSION_RASVNLIB)

endif (WIN32)


if(NOT SUBVERSION_INCLUDE_DIR)
  message(SEND_ERROR "No subversion includes found!")
else(NOT SUBVERSION_INCLUDE_DIR)
  message(STATUS "Found subversion include: ${SUBVERSION_INCLUDE_DIR}")
endif(NOT SUBVERSION_INCLUDE_DIR)

if (NOT SUBVERSION_CLIENTLIB)
 message(SEND_ERROR "No subversion client libs found!")
else (NOT SUBVERSION_CLIENTLIB)
 message(STATUS "Found subversion client lib: ${SUBVERSION_CLIENTLIB}")
 set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_CLIENTLIB})
endif(NOT SUBVERSION_CLIENTLIB)

if (NOT SUBVERSION_DIFFLIB)
 message(SEND_ERROR "No subversion diff lib found!")
else (NOT SUBVERSION_DIFFLIB)
 message(STATUS "Found subversion diff lib: ${SUBVERSION_DIFFLIB}")
 set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_DIFFLIB})
endif(NOT SUBVERSION_DIFFLIB)

if (NOT SUBVERSION_FSLIB)
 message(SEND_ERROR "No subversion fs lib found!")
else (NOT SUBVERSION_FSLIB)
 message(STATUS "Found subversion fs lib: ${SUBVERSION_FSLIB}")
 set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_FSLIB})
endif(NOT SUBVERSION_FSLIB)

if (NOT SUBVERSION_RALIB)
 message(SEND_ERROR "No subversion ra lib found!")
else (NOT SUBVERSION_RALIB)
 message(STATUS "Found subversion ra lib: ${SUBVERSION_RALIB}")
 set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_RALIB})
endif(NOT SUBVERSION_RALIB)

if (NOT SUBVERSION_REPOSITORYLIB)
 message(SEND_ERROR "No subversion repository lib found!")
else (NOT SUBVERSION_REPOSITORYLIB)
 message(STATUS "Found subversion repository lib: ${SUBVERSION_REPOSITORYLIB}")
 set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_REPOSITORYLIB})
endif(NOT SUBVERSION_REPOSITORYLIB)

if (NOT SUBVERSION_SUBRLIB)
 message(SEND_ERROR "No subversion subr lib found!")
else (NOT SUBVERSION_SUBRLIB)
 message(STATUS "Found subversion subr lib: ${SUBVERSION_SUBRLIB}")
 set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_SUBRLIB})
endif(NOT SUBVERSION_SUBRLIB)

if (NOT SUBVERSION_WCLIB)
 message(SEND_ERROR "No subversion wc lib found!")
else (NOT SUBVERSION_WCLIB)
 message(STATUS "Found subversion wc lib: ${SUBVERSION_WCLIB}")
 set(SUBVERSION_ALL_LIBS ${SUBVERSION_ALL_LIBS} ${SUBVERSION_WCLIB})
endif(NOT SUBVERSION_WCLIB)


set(SUBVERSIONFOUND TRUE)
