/* This file is part of the KDE project
   Copyright (C) 2002, Benoit Vautrin <benoit.vautrin@free.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef __KOCONTEXTHELPACTION_H__
#define __KOCONTEXTHELPACTION_H__

#include <tqwidget.h>
#include <tqbitmap.h>
#include <tqdockwindow.h>

#include <tdeaction.h>
#include <koffice_export.h>
class TQPixmap;
class TQLabel;
class TQSimpleRichText;

class KoVerticalLabel : public TQWidget
{
	TQ_OBJECT
  
	
	public:
		KoVerticalLabel( TQWidget* parent = 0, const char* name = 0 );
		~KoVerticalLabel();
		
	public slots:
		void setText( const TQString& text );
		
	protected:
		void paintEvent( TQPaintEvent* );
		
	private:
		TQString m_text;
}; // KoVerticalLabel

class KoHelpNavButton : public TQWidget
{
	TQ_OBJECT
  
	
	public:
		enum NavDirection {
			Up,
			Down
		};

		KoHelpNavButton( NavDirection d, TQWidget* parent );

	signals:
		void pressed();
		void released();

	protected:
		void paintEvent( TQPaintEvent* );
		void enterEvent( TQEvent* );
		void leaveEvent( TQEvent* );

	private:
		TQBitmap      m_bitmap;
		bool         m_pressed;
}; // KoHelpNavButton

class KoTinyButton : public TQWidget
{
	TQ_OBJECT
  
	
	public:
		enum Action {
			Close,
			Sticky
		};

		KoTinyButton( Action a, TQWidget* parent );

	signals:
		void clicked();
		void toggled( bool );

	protected:
		void paintEvent( TQPaintEvent* );
		void mousePressEvent( TQMouseEvent* );
		void mouseReleaseEvent( TQMouseEvent* );

	private:
		TQBitmap      m_bitmap;
		bool         m_pressed;
		Action       m_action;
		bool         m_toggled;
}; // KoTinyButton

class KoHelpView : public TQWidget
{
	TQ_OBJECT
  

	public:
		KoHelpView( TQWidget* parent );
		~KoHelpView();

		void setText( const TQString& text );
		bool eventFilter( TQObject* watched, TQEvent* e );

	signals:
		void linkClicked( const TQString& link );

	protected:
		virtual void mousePressEvent( TQMouseEvent* e );
		virtual void mouseReleaseEvent( TQMouseEvent* e );
		virtual void mouseMoveEvent( TQMouseEvent* e );
		virtual void paintEvent( TQPaintEvent* e );

	private:
		TQSimpleRichText* currentText;
		TQString currentAnchor;
}; // KoHelpView

class KoHelpWidget : public TQWidget
{
	TQ_OBJECT
  

	public:
		KoHelpWidget( TQString help, TQWidget* parent );

		void setText( TQString text );
		void timerEvent( TQTimerEvent* );
		void updateButtons();

	signals:
		void linkClicked( const TQString& link );

	public slots:
		void scrollUp();
		void scrollDown();
		void startScrollingUp();
		void startScrollingDown();
		void stopScrolling();

	protected:
		void resizeEvent( TQResizeEvent* );

	private:
		int              m_ypos;
		bool             m_scrollDown;
		TQWidget*         m_helpViewport;
		KoHelpView*      m_helpView;
		KoHelpNavButton* m_upButton;
		KoHelpNavButton* m_downButton;
}; // KoHelpWidget

/**
 * KoContextHelpPopup is the popup displayed by ContextHelpAction.
 */
class KoContextHelpPopup : public TQWidget
{
	TQ_OBJECT
  

	public:
		KoContextHelpPopup( TQWidget* parent = 0 );
		~KoContextHelpPopup();

	public slots:
		void setContextHelp( const TQString& title, const TQString& text, const TQPixmap* icon = 0 );
		void setSticky( bool sticky ) { m_isSticky = sticky; }

	protected:
		virtual void mousePressEvent( TQMouseEvent* );
		virtual void mouseMoveEvent( TQMouseEvent* );
		virtual void resizeEvent( TQResizeEvent* );
		virtual void paintEvent( TQPaintEvent* );
		virtual void windowActivationChange( bool );
		virtual void keyPressEvent ( TQKeyEvent* );
		virtual void keyReleaseEvent ( TQKeyEvent* );

	signals:
		void wantsToBeClosed();
		/**
		 * Connect to this signal to receive the href value of the links clicked.
		 */
		void linkClicked( const TQString& link );

	private:
		KoHelpWidget*    m_helpViewer;
		KoVerticalLabel* m_helpTitle;
		TQLabel*          m_helpIcon;
		KoTinyButton*    m_close;
		KoTinyButton*    m_sticky;

		TQPoint           m_mousePos;
		bool             m_isSticky;
}; // KoContextHelpPopup

/**
 * KoContextHelpAction provides a easy to use context help system.
 *
 * This action displays on demand a context help in a popup.
 * The context help is set by the updateHelp slot.
 */
class KOFFICEUI_EXPORT KoContextHelpAction : public TDEToggleAction
{
	TQ_OBJECT
  

	public:
		KoContextHelpAction( TDEActionCollection* parentCollection, TQWidget* parent = 0 );
		virtual ~KoContextHelpAction();

	public slots:
		void updateHelp( const TQString& title, const TQString& text, const TQPixmap* icon = 0 );
		void closePopup();

	signals:
		/**
		 * Connect to this signal to receive the href value of the links clicked.
		 */
		void linkClicked( const TQString& link );

	private:
		KoContextHelpPopup* m_popup;
}; // KoContextHelpAction

class KoContextHelpWidget : public TQWidget
{
	TQ_OBJECT
  

	public:
		KoContextHelpWidget( TQWidget* parent = 0, const char* name = 0 );
		~KoContextHelpWidget();

	public slots:
		void setContextHelp( const TQString& title, const TQString& text, const TQPixmap* icon = 0 );

	signals:
		/**
		 * Connect to this signal to receive the href value of the links clicked.
		 */
		void linkClicked( const TQString& link );

	private:
		KoHelpWidget*    m_helpViewer;
		KoVerticalLabel* m_helpTitle;
		TQLabel*          m_helpIcon;
}; // KoContextHelpWidget

class KoContextHelpDocker : public TQDockWindow
{
	TQ_OBJECT
  

	public:
		KoContextHelpDocker( TQWidget* parent = 0, const char* name = 0 );
		~KoContextHelpDocker();

	public slots:
		void setContextHelp( const TQString& title, const TQString& text, const TQPixmap* icon = 0 );

	signals:
		/**
		 * Connect to this signal to receive the href value of the links clicked.
		 */
		void linkClicked( const TQString& link );

	private:
		KoHelpWidget*    m_helpViewer;
		KoVerticalLabel* m_helpTitle;
		TQLabel*          m_helpIcon;
}; // KoContextHelpDocker

#endif /* __KOCONTEXTHELPACTION_H__ */
