/* This file is part of the KDE project
   Copyright (C) 2000 - 2003 David Faure <faure@kde.org>
   Copyright (C) 2003 Norbert Andres <nandres@web.de>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#ifndef OPENCALCEXPORT_H
#define OPENCALCEXPORT_H

#include "opencalcstyleexport.h"

#include <KoFilter.h>
#include <tqptrlist.h>

class TQDomDocument;
class TQDomElement;
class TDELocale;
class KoStore;

namespace KSpread
{
class Doc;
class Sheet;
}

class OpenCalcExport : public KoFilter
{
  TQ_OBJECT
  

 public:
  OpenCalcExport( KoFilter * parent, const char * name, const TQStringList & );
  virtual ~OpenCalcExport() {}

  virtual KoFilter::ConversionStatus convert( const TQCString & from,
                                              const TQCString & to );

 private:
  enum files { metaXML = 0x01, contentXML = 0x02, stylesXML = 0x04, settingsXML = 0x08 };
  OpenCalcStyles m_styles;

  bool writeFile( const KSpread::Doc * ksdoc );

  bool exportDocInfo( KoStore * store, const KSpread::Doc * ksdoc );
  bool exportStyles ( KoStore * store, const KSpread::Doc * ksdoc );
  bool exportContent( KoStore * store, const KSpread::Doc * ksdoc );
  bool exportSettings( KoStore * store, const KSpread::Doc * ksdoc );

  bool exportBody( TQDomDocument & doc, TQDomElement & content, const KSpread::Doc * ksdoc );
  void exportSheet( TQDomDocument & doc, TQDomElement & tabElem,
                    const KSpread::Sheet * sheet, int maxCols, int maxRows );
  void exportCells( TQDomDocument & doc, TQDomElement & rowElem,
                    const KSpread::Sheet * sheet, int row, int maxCols );
  void exportDefaultCellStyle( TQDomDocument & doc, TQDomElement & officeStyles );
  void exportPageAutoStyles( TQDomDocument & doc, TQDomElement & autoStyles,
                             const KSpread::Doc * ksdoc );
  void exportMasterStyles( TQDomDocument & doc, TQDomElement & masterStyles,
                           const KSpread::Doc *ksdoc );

  bool writeMetaFile( KoStore * store, uint filesWritten );

  void maxRowCols( const KSpread::Sheet * sheet,
                   int & maxCols, int & maxRows );
  void convertPart( TQString const & part, TQDomDocument & doc,
                    TQDomElement & parent, const KSpread::Doc * ksdoc );
  void addText( TQString const & text, TQDomDocument & doc,
                TQDomElement & parent );

  void createDefaultStyles();
  TQString convertFormula( TQString const & formula ) const;
private:
    /// Pointer to the KSpread locale
    TDELocale* m_locale;
};

#endif
