/* This file is part of the KDE project
   Copyright (C) 2005 Bram Schoenmakers <bramschoenmakers@kde.nl>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
*/

#include <tqcheckbox.h>
#include <tqcombobox.h>
#include <tqlistbox.h>
#include <tqradiobutton.h>
#include <tqspinbox.h>
#include <tqtextcodec.h>

#include <tdeapplication.h>
#include <tdeglobal.h>
#include <tdelocale.h>
#include <kurlrequester.h>

#include <exportdialog.h>
#include <exportwidget.h>

ExportDialog::ExportDialog( TQWidget *parent, const char *name )
  : KDialogBase( parent, name, true, i18n("Export Sheet to HTML"), Ok|Cancel, No, true ), m_mainwidget( new ExportWidget( this ) )
{
  kapp->restoreOverrideCursor();

  connect( m_mainwidget->mCustomButton, TQ_SIGNAL( toggled( bool ) ),
           m_mainwidget->mCustomURL, TQ_SLOT( setEnabled( bool ) ) );
  connect( m_mainwidget->mSelectAllButton, TQ_SIGNAL( clicked() ), TQ_SLOT( selectAll() ) );
  connect( m_mainwidget->mDeselectAllButton, TQ_SIGNAL( clicked() ),
           m_mainwidget->mSheets, TQ_SLOT( clearSelection() ) );

  m_mainwidget->mEncodingBox->insertItem( i18n( "Recommended: UTF-8" ) );
  m_mainwidget->mEncodingBox->insertItem( i18n( "Locale (%1)" ).arg( TDEGlobal::locale()->codecForEncoding()->name() ) );

  m_mainwidget->mCustomURL->setMode( KFile::ExistingOnly );

  setMainWidget( m_mainwidget );
}

void ExportDialog::selectAll()
{
  m_mainwidget->mSheets->selectAll( true );
}

ExportDialog::~ExportDialog()
{
  kapp->setOverrideCursor(TQt::waitCursor);
}

TQTextCodec *ExportDialog::encoding() const
{
  if( m_mainwidget->mEncodingBox->currentItem() == 1 ) // locale selected
    return TDEGlobal::locale()->codecForEncoding();

  return TQTextCodec::codecForName( "utf8" ); // utf8 is default
}

bool ExportDialog::useBorders() const
{
  return m_mainwidget->mUseBorders->isChecked();
}

bool ExportDialog::separateFiles() const
{
  return m_mainwidget->mSeparateFiles->isChecked();
}

TQString ExportDialog::customStyleURL() const
{
  TQString url = m_mainwidget->mCustomURL->url();
  if( m_mainwidget->mCustomButton->isChecked() && KURL( url ).isValid() )
    return url;

  return TQString();
}

void ExportDialog::setSheets( const TQStringList &list )
{
  m_mainwidget->mSheets->insertStringList( list );
  selectAll();
}

TQStringList ExportDialog::sheets() const
{
  TQStringList list;
  for( uint i = 0; i < m_mainwidget->mSheets->count() ; i++ )
  {
    if( m_mainwidget->mSheets->isSelected( i ) )
      list.append( m_mainwidget->mSheets->text( i ) );
  }
  return list;
}

int ExportDialog::pixelsBetweenCells() const
{
  return m_mainwidget->mPixelsBetweenCells->value();
}

#include <exportdialog.moc>
