/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

#ifndef __FILE_CHOOSER_PORTAL_H
#define __FILE_CHOOSER_PORTAL_H

// TDE
#include <tdefile.h>

// Portal
#include "interfaces/filechooserInterface.h"
#include "interface.h"
#include "dialog_result_sender.h"

class TDEFileChooserPortal;

struct FileDialogOpts
{
    TQString caption;
    TQString okButtonText;
    TQString startDir;
    TQString startName;
    TQString filters;
    bool multiple = false;
    bool directory = false;
    bool savingMode = false;
    bool modal = true;
    WId windowId = 0;

    inline KFile::Mode mode()
    {
        if (directory) return KFile::Directory;
        return multiple ? KFile::Files : KFile::File;
    }
};

class KFileDialog;

class TDEFileChooserPortal : public TQObject,
                             public org::freedesktop::impl::portal::FileChooserInterface
{
    INTERFACE("org.freedesktop.impl.portal.FileChooser")

    public:
        TDEFileChooserPortal(TQT_DBusConnection &connection);
        virtual ~TDEFileChooserPortal();

    protected:
        void OpenFileAsync(int asyncCallId,
                           const TQT_DBusObjectPath& handle,
                           const TQString& app_id,
                           const TQString& parent_window,
                           const TQString& title,
                           const TQT_DBusVariantMap &options);

        void SaveFileAsync(int asyncCallId,
                           const TQT_DBusObjectPath& handle,
                           const TQString& app_id,
                           const TQString& parent_window,
                           const TQString& title,
                           const TQT_DBusVariantMap &options);

        void SaveFilesAsync(int asyncCallId,
                            const TQT_DBusObjectPath& handle,
                            const TQString& app_id,
                            const TQString& parent_window,
                            const TQString& title,
                            const TQT_DBusVariantMap &options);

        virtual void handleMethodReply(const TQT_DBusMessage& reply);
        virtual bool handleSignalSend(const TQT_DBusMessage& reply);

    private:
        TQT_DBusConnection m_connection;

        WId parseWindowId(const TQString data);

    protected:
        TQString parseFilter(const TQT_DBusData data);
        TQString parseFilterList(const TQT_DBusVariant filterData,
                                 const TQT_DBusVariant currentFilterData);

        void execFileDialog(ResultSendCallback<TDEFileChooserPortal> callback,
                            int asyncCallId,
                            FileDialogOpts options,
                            const TQT_DBusObjectPath& handle);

        DialogResult prepareReply(TQDialog *dlg);
        DialogResult prepareSaveFilesReply(TQDialog *dlg);

    friend class DialogResultSender<TDEFileChooserPortal>;
};

#endif // __FILE_CHOOSER_PORTAL_H

// kate: replace-tabs true; tab-width 4; indent-width 4;