/*******************************************************************************
  XDG desktop portal implementation for TDE
  Copyright © 2024 Mavridis Philippe <mavridisf@gmail.com>

  This program or library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public License as
  published by the Free Software Foundation; either version 2.1 of the License,
  or (at your option) any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
  FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
  details.

  You should have received a copy of the GNU Lesser General Public License
  along with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

  Improvements and feedback are welcome!
*******************************************************************************/

#ifndef __ACCOUNT_PORTAL_H
#define __ACCOUNT_PORTAL_H

// Portal
#include "dialog_result_sender.h"
#include "interfaces/accountInterface.h"
#include "interface.h"

struct AccountInfo
{
    TQString userId;
    TQString loginName;
    TQString realName;
    TQString homeDirectory;
    TQString avatarPath;
};

class TDEPermissionDialog;

class TDEAccountPortal : public TQObject,
                         public org::freedesktop::impl::portal::AccountInterface
{
    public:
        INTERFACE("org.freedesktop.impl.portal.Account")

        TDEAccountPortal(TQT_DBusConnection &connection);
        virtual ~TDEAccountPortal();

    protected:
        virtual void handleMethodReply(const TQT_DBusMessage& reply);
        virtual bool handleSignalSend(const TQT_DBusMessage& reply);

        void GetUserInformationAsync(int asyncCallId,
                                     const TQT_DBusObjectPath& handle,
                                     const TQString& app_id,
                                     const TQString& window,
                                     const TQT_DBusVariantMap& options);

        void appendDataPreview(TDEPermissionDialog *dlg, AccountInfo info);

        DialogResult prepareReply(TQDialog *dlg);

    private:
        AccountInfo m_info;
        TQT_DBusConnection m_connection;

    friend class DialogResultSender<TDEAccountPortal>;
};

#endif // __ACCOUNT_PORTAL_H

// kate: replace-tabs true; tab-width 4; indent-width 4;