//
// C++ Implementation: translitplugin
//
// Description: 
//
//
// Author: Dominik Seichter <domseichter@web.de>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "translitplugin.h"


const TQString TranslitPlugin::m_strUtf8[] = {"а","б","в","г","д","е","ё","ж","з","и",
    "й","к","л","м","н","о","п","р","с","т","у","ф","х","ц","ч","ш","щ","ъ","ы","ь",
    "э","ю","я",
    "А","Б","В","Г","Д","Е","Ё","Ж","З","И","Й","К","Л","М","Н","О","П",
    "Р","С","Т","У","Ф","Х","Ц","Ч","Ш","Щ","Ъ","Ы","Ь","Э","Ю","Я",
    "á","ä","č","ď","é","ě","í","ľ","ĺ","ň","ó","ô","ř","ŕ","š","ť","ú","ů","ý","ž",
    "Á","Ä","Č","Ď","É","Ě","Í","Ľ","Ĺ","Ň","Ó","Ô","Ř","Ŕ","Š","Ť","Ú","Ů","Ý","Ž",TQString()};
    
const TQString TranslitPlugin::m_strEngl[]= {"a","b","v","g","d","e","yo","zh","z","i",
    "j","k","l","m","n","o","p","r","s","t","u","f","h","c","ch","sh","sh","","y","",
    "e","yu","ya",
    "A","B","V","G","D","E","Yo","Zh","Z","I","J","K","L","M","N","O","P",
    "R","S","T","U","F","H","C","Ch","Sh","Sh","","Y","","E","Yu","Ya",
    "a","a","c","d","e","e","i","l","l","n","o","o","r","r","s","t","u","u","y","z",
    "A","A","C","D","E","E","I","L","L","N","O","O","R","R","S","T","U","U","Y","Z",TQString()};

const TQString TranslitPlugin::getName() const
{
    return i18n("Transliteration Plugin");
}

const TQString TranslitPlugin::getAccelName() const
{
    return i18n("&Transliteration Plugin");
}

const TQPixmap TranslitPlugin::getIcon() const
{
    return kapp->iconLoader()->loadIcon( "fonts", TDEIcon::Small );
}

const int TranslitPlugin::type() const
{
    return TYPE_FINAL_FILENAME;
}

void TranslitPlugin::drawInterface( TQWidget* w, TQVBoxLayout* l )
{
    TQLabel* label = new TQLabel( 
    i18n("<qt>This plugin transliterates names written with non-english characters.</qt>"), w );
    l->addWidget( label );
    
    label = new TQLabel( "<qt><b>WARNING! THIS PLUGIN IS EXPERIMENTAL AND MIGHT CAUSE LOSS OF DATA!</b></qt>", w );
    l->addWidget( label );
}

void TranslitPlugin::finished()
{
}

void TranslitPlugin::fillStructure()
{
} 

bool TranslitPlugin::checkError()
{
   return true;
}

TQString TranslitPlugin::processFile( BatchRenamer*, int, TQString token, int )
{
    TQString output = translit( token );

    return output; // no error
}

TQString TranslitPlugin::translit(const TQString & unicoded)
{
    int i;
    TQString transed = "";

    for (i=0; i<(int)unicoded.length(); i++) {
        TQString charIn = unicoded.mid(i, 1);
        if (!(m_mapFromUTF8[charIn.utf8()].isNull())) {
            TQString charTrans = m_mapFromUTF8[charIn.utf8()];
            transed.append(charTrans);
        } else {
            transed.append(charIn);
        }
    }
    return transed;
}

TranslitPlugin::TranslitPlugin() {
    // Initialize transliteration map
    int i;
    for (i=0; m_strUtf8[i]!=TQString(); i++) {
        TQString src = m_strUtf8[i];
        TQString dst = m_strEngl[i];
        m_mapFromUTF8[src] = dst;
    }
}

#include "translitplugin.moc"
