// Author: Denis Kozadaev - (c) 2025


#ifndef	__MAIN_WINDOW_H__
#define	__MAIN_WINDOW_H__

#include <tdemainwindow.h>
#include <tdepopupmenu.h>
#include <tqsettings.h>

#include "gameboard.h"


class MainWindow:public TDEMainWindow
{
	TQ_OBJECT

public:
	MainWindow(TQWidget* parent = nullptr, const char* name = nullptr);
	~MainWindow();

private:
	int		defSize;
	int		idTip, idKnight, idCell;
	TDEPopupMenu	*mMenu;
	TDEPopupMenu	*mGame;
	GameBoard	*mBoard;
	TQSettings	*settings;

	void	loadSettings();
	void	saveSettings();

private slots:
	void	newGame();
	void	toggleTips();
	void	toggleKnight();
	void	randomCell();
};

#endif	/* __MAIN_WINDOW_H__ */
