/*
 *   Copyright (C) 2006
 *   Siraj Razick <siraj@kdemail.net>
 *   PhobosK <phobosk@mail.kbfx.net>
 *   see Also AUTHORS
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License version 2 as
 *   published by the Free Software Foundation
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef KBFX_TDEIO_DOWNLOAD_H
#define KBFX_TDEIO_DOWNLOAD_H

#include <tdeio/job.h>
#include <tdetempfile.h>
#include <kdebug.h>

/**
 * @author PhobosK <phobosk@mail.kbfx.net>
 */
class KbfxKioDownload : public TQObject
{
		TQ_OBJECT
  

	public:
		KbfxKioDownload ( TQObject * parent = 0, const char * name = 0 );
		~KbfxKioDownload();

		/* KbfxKioDownload invocation - pass an url as TQString */
		void KbfxKioDownloadStart ( TQString &url );

		/* return temp file name for the download */
		TQString KbfxBrowserTmpFile() {return m_KbfxBrowserTmpFile;}

		/* return error number occured during download
		 * see definition in global.h
		 */
		int KbfxBrowserError() {return m_KbfxBrowserError;}

		/* return error text occured during download */
		TQString KbfxBrowserErrorText() {return m_KbfxBrowserErrorText;}

	protected:
		TQString m_KbfxBrowserTmpFile;
		int m_KbfxBrowserError;
		TQString m_KbfxBrowserErrorText;

	private:
		KTempFile tmpF;

	public slots:
		/* call when you are ready to delete the temp file for the download */
		virtual void KbfxKioDownloadEnd();

	private slots:
		/* current job is done here */
		virtual void KbfxBrowserResult ( TDEIO::Job * );

	signals:
		/* emitted when the download is ready */
		void KbfxKioDownloadReady();
};

#endif
