//
// C++ Implementation: tdewalletaccess
//
// Author: Ulrich Weigelt <ulrich.weigelt@gmx.de>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "tdewalletaccess.h"


bool TDEWalletAccess::savePassword( const TQString & account, const TQString & password )
{
  //check for enabled TDEWallet
  if( !TDEWallet::Wallet::isEnabled() )
  {
    KMessageBox::error( NULL, i18n( "TDEWallet is not available." ) );
    return false;
  }

  //get wallet name for network data
  TQString name = TDEWallet::Wallet::NetworkWallet();
  if( name == "" || name == TQString::null )
  {
    KMessageBox::error( NULL, i18n( "Could not get wallet name for network datas from TDEWallet." ) );
    return false;
  }

  //open wallet
  //we want to create a connection object just at first call of this function
  static TDEWallet::Wallet* wallet;

  if( wallet == NULL )
  {
    wallet = TDEWallet::Wallet::openWallet( name );
  }
  else if( !wallet->isOpen() )
  {
    delete wallet;
    wallet = TDEWallet::Wallet::openWallet( name );
  }

  if( wallet == NULL )
  {
    KMessageBox::error( NULL, i18n( "Could not open TDEWallet." ) );
    return false;
  }

  //create kshowmail folder if it does not exist
  if( !wallet->hasFolder( "KShowmail" ) )
  {
    bool createFolderSuccess = wallet->createFolder( "KShowmail" );

    if( !createFolderSuccess )
    {
      KMessageBox::error( NULL, i18n( "Could not create folder for KShowmail in TDEWallet." ) );
      return false;
    }
  }

  //set folder
  bool setFolderSuccess = wallet->setFolder( "KShowmail" );
  if( !setFolderSuccess )
  {
    KMessageBox::error( NULL, i18n( "Could not open folder for KShowmail in TDEWallet." ) );
    return false;
  }

  //write password
  int writePasswordSuccess = wallet->writePassword( account, password );
  if( writePasswordSuccess != 0 )
  {
    KMessageBox::error( NULL, i18n( "Could not save password in TDEWallet." ) );
    return false;
  }


  return true;
}

TQString TDEWalletAccess::getPassword( const TQString & account )
{
  //check for enabled TDEWallet
  if( !TDEWallet::Wallet::isEnabled() )
  {
    KMessageBox::error( NULL, i18n( "TDEWallet is not available." ) );
    return TQString::null;
  }

  //get wallet name for network data
  TQString name = TDEWallet::Wallet::NetworkWallet();
  if( name == "" || name == TQString::null )
  {
    KMessageBox::error( NULL, i18n( "Could not get wallet name for network datas from TDEWallet." ) );
    return TQString::null;
  }

  //open wallet
  //we want to create a connection object just at first call of this function
  static TDEWallet::Wallet* wallet;

  if( wallet == NULL )
  {
    wallet = TDEWallet::Wallet::openWallet( name );
  }
  else if( !wallet->isOpen() )
  {
    delete wallet;
    wallet = TDEWallet::Wallet::openWallet( name );
  }

  if( wallet == NULL )
  {
    KMessageBox::error( NULL, i18n( "Could not open TDEWallet." ) );
    return TQString::null;
  }

  //set folder
  bool setFolderSuccess = wallet->setFolder( "KShowmail" );
  if( !setFolderSuccess )
  {
    KMessageBox::error( NULL, i18n( "Could not open folder for KShowmail in TDEWallet." ) );
    return TQString::null;
  }

  //read password
  TQString password;

  int readPasswordSuccess = wallet->readPassword( account, password );
  if( readPasswordSuccess != 0 )
  {
    KMessageBox::error( NULL, i18n( "Could not get password of account %1 from TDEWallet." ).arg( account) );
    return TQString::null;
  }

  return password;
}
