/*
Gwenview - A simple image viewer for TDE
Copyright 2000-2004 Aur�ien G�eau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

*/
#ifndef IMAGEVIEWTOOLS_H
#define IMAGEVIEWTOOLS_H   

// TQt
#include <tqcursor.h>

// Local
#include "imageview.h"
namespace Gwenview {


class ImageView::ToolBase {
protected:
	ImageView* mView;

public:
	ToolBase(ImageView* view);
	virtual ~ToolBase();
	virtual void mouseMoveEvent(TQMouseEvent*);
	
	virtual void leftButtonPressEvent(TQMouseEvent*);
	virtual void leftButtonReleaseEvent(TQMouseEvent*);
	
	virtual void midButtonReleaseEvent(TQMouseEvent*);

	virtual void rightButtonPressEvent(TQMouseEvent* event);
	virtual void rightButtonReleaseEvent(TQMouseEvent*);

	virtual void wheelEvent(TQWheelEvent* event);

	virtual void updateCursor();

    /**
     * Return a hint about the use of the tool
     */
    virtual TQString hint() const=0;
};


class ImageView::ZoomTool : public ImageView::ToolBase {
private:
    TQCursor mZoomCursor;
	void zoomTo(const TQPoint& pos, bool in); 

public:
	ZoomTool(ImageView* view);
	void leftButtonReleaseEvent(TQMouseEvent* event);

	void wheelEvent(TQWheelEvent* event);
	void rightButtonPressEvent(TQMouseEvent*);
	void rightButtonReleaseEvent(TQMouseEvent* event);

	void updateCursor();
    virtual TQString hint() const;
};


class ImageView::ScrollTool : public ImageView::ToolBase {
	int mScrollStartX,mScrollStartY;
	bool mDragStarted;

public:
	ScrollTool(ImageView* view);
	void leftButtonPressEvent(TQMouseEvent* event); 
	void mouseMoveEvent(TQMouseEvent* event);
	void leftButtonReleaseEvent(TQMouseEvent*);
	void wheelEvent(TQWheelEvent* event);
	
	void updateCursor(); 
    virtual TQString hint() const;
};


} // namespace
#endif /* IMAGEVIEWTOOLS_H */

