/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "shoppinglistviewdialog.h"
#include "datablocks/ingredientlist.h"
#include "datablocks/mixednumber.h"

#include <tqpushbutton.h>

#include <tdelocale.h>
#include <tdeapplication.h>
#include <tdeconfig.h>
#include <kiconloader.h>

ShoppingListViewDialog::ShoppingListViewDialog( TQWidget *parent, const IngredientList &ingredientList )
		: KDialogBase( parent, "shoppingviewdialog", true, TQString::null,
		    KDialogBase::Close | KDialogBase::User1, KDialogBase::Close,
		    false, KStdGuiItem::print() )
{
	// Design dialog
	TQVBox *page = makeVBoxMainWidget();

	shoppingListView = new TDEHTMLPart( page );

	setInitialSize( TQSize(350, 450) );

	connect ( this, TQ_SIGNAL( user1Clicked() ), this, TQ_SLOT( print() ) );
	connect ( this, TQ_SIGNAL( closeClicked() ), this, TQ_SLOT( accept() ) );

	//---------- Sort the list --------
	IngredientList list_copy = ingredientList;
	qHeapSort( list_copy );

	//---------- Load  the list --------
	display( list_copy );
}


ShoppingListViewDialog::~ShoppingListViewDialog()
{}

void ShoppingListViewDialog::display( const IngredientList &ingredientList )
{
	TQString recipeHTML;

	// Create HTML Code

	// Headers
	recipeHTML = TQString( "<html><head><title>%1</title></head><body>" ).arg( i18n( "Shopping List" ) );
	recipeHTML += "<center><div STYLE=\"width: 95%\">";
	recipeHTML += TQString( "<center><h1>%1</h1></center>" ).arg( i18n( "Shopping List" ) );

	// Ingredient List

	recipeHTML += "<div STYLE=\"border:medium solid blue; width:95%\"><table cellspacing=0px width=100%><tbody>";
	bool counter = true;

	TDEConfig *config = TDEGlobal::config();
	config->setGroup( "Formatting" );

	bool useAbbreviations = config->readBoolEntry("AbbreviateUnits");
	bool useFraction = config->readBoolEntry( "Fraction" );

	for ( IngredientList::const_iterator ing_it = ingredientList.begin(); ing_it != ingredientList.end(); ++ing_it ) {
		TQString color = ( counter ) ? "#CBCEFF" : "#BFC2F0";
		counter = !counter;

		MixedNumber::Format number_format = ( useFraction ) ? MixedNumber::MixedNumberFormat : MixedNumber::DecimalFormat;
		TQString amount_str = MixedNumber( ( *ing_it ).amount ).toString( number_format );

		TQString unit = ( *ing_it ).units.determineName( ( *ing_it ).amount + ( *ing_it ).amount_offset, useAbbreviations );

		recipeHTML += TQString( "<tr bgcolor=\"%1\"><td>- %2:</td><td>%3 %4</td></tr>" ).arg( color ).arg( ( *ing_it ).name ).arg( amount_str ).arg( unit );
	}
	recipeHTML += "</tbody></table></div>";
	// Close
	recipeHTML += "</div></center></body></html>";


	// Display
	shoppingListView->begin( KURL( "file:/tmp/" ) ); // Initialize to /tmp, where photos and logos are stored
	shoppingListView->write( recipeHTML );
	shoppingListView->end();


}

void ShoppingListViewDialog::print()
{
	shoppingListView->view() ->print();
}

#include "shoppinglistviewdialog.moc"
