//
// C++ Implementation: malloryhandler
//
// Description:
//
//
// Author: Remi Villatel <maxilys@tele2.fr>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#include "malloryhandler.h"
#include "malloryclient.h"
#include "pixmaps.h"
#include "embeddata.h"

bool MalloryHandler::m_initialized = false;
int MalloryHandler::m_titleSize = 22;
int MalloryHandler::m_buttonSize = 18;
int MalloryHandler::m_borderSize = 5;
int MalloryHandler::m_buttonSpacing = 2;
bool MalloryHandler::m_lessRounded = false;
int MalloryHandler::m_buttonStyle = 0;
bool MalloryHandler::m_resizeHandle = true;
bool MalloryHandler::m_superSize = true;
bool MalloryHandler::m_titleShadow = true;
int MalloryHandler::m_titleShadowSize = 2;

MalloryHandler::MalloryHandler()
{
	reset(0);
}

MalloryHandler::~MalloryHandler()
{
	Pixmaps::deletePixmaps();
	qCleanupImages_KWinMallory();
	m_initialized = false;
}

bool MalloryHandler::reset(unsigned long) // unsigned long changed
{
	readConfig();

	Pixmaps::deletePixmaps();
	Pixmaps::createPixmaps();
	qInitImages_KWinMallory();

	m_initialized = true;
	return true;
}

KDecoration* MalloryHandler::createDecoration(KDecorationBridge *bridge)
{
	return new MalloryClient(bridge, this);
}

void MalloryHandler::readConfig()
{
	TDEConfig config("twinmalloryrc");
	config.setGroup("General");

	m_titleShadow = config.readBoolEntry("TitleShadow", true);
	m_lessRounded = config.readBoolEntry("LessRounded", false);
	m_resizeHandle = config.readBoolEntry("ResizeHandle", true);
	m_superSize = config.readBoolEntry("SuperSize", true);

	m_borderSize = config.readNumEntry("BorderSize", 5);
	if (m_borderSize < 5) m_borderSize = 5;
	if (m_borderSize > 10) m_borderSize = 10;

	m_titleSize = config.readNumEntry("TitleSize", 22);
	if (m_titleSize < 22) m_titleSize = 22;
	if (m_titleSize > 44) m_titleSize = 44;

	m_buttonSize = config.readNumEntry("ButtonSize", 18);
	if (m_buttonSize < 18) m_buttonSize = 18;
	if (m_buttonSize > (m_titleSize-4)) m_buttonSize = (m_titleSize-4);

	m_buttonStyle = config.readNumEntry("ButtonStyle", 0);
	if (m_buttonStyle < 0) m_buttonStyle = 0;
	if (m_buttonStyle > 1) m_buttonStyle = 1;

	m_titleShadowSize = config.readNumEntry("TitleShadowSize", 1);
	if (m_titleShadowSize < 1) m_titleShadowSize = 1;
	if (m_titleShadowSize > 3) m_titleShadowSize = 3;

	// MXLS: Keep this for another time.  ;-)
	/*m_buttonSpacing = config.readNumEntry("ButtonSpacing", 2);
	if (m_buttonSpacing < 0) m_buttonSpacing = 0;
	if (m_buttonSpacing > 5) m_buttonSpacing = 5;*/
}

#include "malloryhandler.moc"
