#!/usr/bin/env python

# Ported to PyTQt by Issac Trotts on Jan 1, 2002

import sys
from PyTQt.tqt import *

import dropsite, secret


def addStuff( parent, yn_image, yn_secret = 0 ):
    tll = TQVBoxLayout( parent, 10 )
    d = dropsite.DropSite( parent, 'dropsite' )
    d.setFrameStyle( TQFrame.Sunken + TQFrame.WinPanel )
    tll.addWidget( d )
    if yn_image:
        stuff = TQPixmap()
        if not stuff.load( "trolltech.bmp" ):
            stuff = TQPixmap(20,20)
            stuff.fill(TQt.green)
        d.setPixmap( stuff )
    else:
        d.setText("Drag and Drop")
    d.setFont(TQFont("Helvetica",18))
    if secret:
        s = secret.SecretSource( 42, parent )
        tll.addWidget( s )

    format = TQLabel( "\n\n\n\nNone\n\n\n\n", parent )
    tll.addWidget( format )
    tll.activate()
    parent.resize( parent.sizeHint() )

    TQObject.connect( d, PYSIGNAL('message(TQString &)'),
        format, TQ_SLOT('setText(TQString &)') )


app = TQApplication( sys.argv )

mw = TQWidget()
addStuff( mw, 1 )
mw.setCaption( "TQt Example - Drag and Drop" )
mw.show()

mw2 = TQWidget()
addStuff( mw2, 0 )
mw2.setCaption( "TQt Example - Drag and Drop" )
mw2.show()

mw3 = TQWidget()
addStuff( mw3, 1, 1 )
mw3.setCaption( "TQt Example - Drag and Drop" )
mw3.show()

TQObject.connect(tqApp,TQ_SIGNAL('lastWindowClosed()'),tqApp,TQ_SLOT('quit()'))

app.exec_loop()
