/***************************************************************************
                             userinfo.cpp
                             -------------------
    begin                : Fri Jun  1 2007
    copyright            : (C) 2007 Thomas Baumgart
    email                : Thomas Baumgart <ipwizard@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// TQt Includes

// ----------------------------------------------------------------------------
// TDE Includes

#include <tdelocale.h>
#include <tdelistview.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "currency.h"

Currency::Currency(TQWidget* parent, const char* name) :
  CurrencyDecl(parent, name)
{
  m_currencyList->setAllColumnsShowFocus(true);
  m_currencyList->setMultiSelection(false);
}

TQListViewItem* Currency::insertCurrency(const MyMoneySecurity& sec)
{
  return new TDEListViewItem(m_currencyList, sec.name(), TQString(sec.id()), sec.tradingSymbol());
}

void Currency::selectCurrency(const MyMoneySecurity& sec)
{
  TQListViewItem* it_v;
  TQListViewItemIterator it(m_currencyList);
  while((it_v = it.current()) != 0) {
    if(it_v->text(1) == TQString(sec.id())) {
      m_currencyList->setSelected(it_v, true);
      m_currencyList->ensureItemVisible(it_v);
      break;
    }
  }
}

TQString Currency::selectedCurrency(void) const
{
  TQString id;
  if(m_currencyList->selectedItem()) {
    id = m_currencyList->selectedItem()->text(1);
  }
  return id;
}

#include "currency.moc"
