/* This file is part of the KDE project
   Copyright (C) 2004 Alexander Dymo <adymo@kdevelop.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "kdevplugincontroller.h"

#include "kdevplugin.h"

KDevPluginController::KDevPluginController()
{
}

TDETrader::OfferList KDevPluginController::query(const TQString &serviceType,
    const TQString &constraint)
{
    TQString versionConstraint =
        TQString::fromLatin1("[X-TDevelop-Version] == %1").arg(TDEVELOP_PLUGIN_VERSION);

    TQString newConstraint;
    if (!constraint.isEmpty()) {
        newConstraint = TQString("( %1 ) and %2").arg(constraint).arg(versionConstraint);
    } else {
        newConstraint = versionConstraint;
    }

    return TDETrader::self()->query(serviceType, newConstraint);
}

TDETrader::OfferList KDevPluginController::queryPlugins(const TQString &constraint)
{
    return query("TDevelop/Plugin", constraint);
}

KURL::List KDevPluginController::profileResources(const TQString &/*nameFilter*/)
{
    return KURL::List();
}

KURL::List KDevPluginController::profileResourcesRecursive(const TQString &/*nameFilter*/)
{
    return KURL::List();
}

#include "kdevplugincontroller.moc"
