/*
    This file is part of libkpimexchange.
    Copyright (c) 2002 Jan-Pascal van Best <janpascal@vanbest.org>

    This library is free software; you can redistribute it and/or modify it
    under the terms of the GNU Library General Public License as published by
    the Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This library is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
    License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to the
    Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/
#ifndef KPIM_EXCHANGECALENDAR_H
#define KPIM_EXCHANGECALENDAR_H

#include <tqmap.h>
#include <tqdict.h>
#include <tqintdict.h>

#include <libkcal/calendar.h>
#include <libkcal/calendarlocal.h>
#include <libkcal/resourcecalendar.h>

#include "exchangemonitor.h"

class DateSet;

namespace KPIM {
class ExchangeAccount;
class ExchangeClient;
}

namespace KCal {
class Event;
class CalFormat;

/**
  This class provides a calendar stored on a Microsoft Exchange 2000 server
*/
// FIXME: Use ResourceCached
class ResourceExchange : public ResourceCalendar, public IncidenceBase::Observer
{
  TQ_OBJECT
  

  public:
    ResourceExchange( const TDEConfig * );
    virtual ~ResourceExchange();

    virtual void writeConfig( TDEConfig* config );

    TDEABC::Lock *lock();

    /** constructs a new calendar, with variables initialized to sane values. */
//    ExchangeCalendar( KPIM::ExchangeAccount* account );
    /** constructs a new calendar, with variables initialized to sane values. */
//    ExchangeCalendar( KPIM::ExchangeAccount* account, const TQString &timeZoneId );
//    virtual ~ExchangeCalendar();

    /**
      Semantics not yet defined. Should the Exchange calendar be wiped clean?
      Should the disk calendar be copied to the Exchange calendar?
      At the moment, does nothing.
      @return true, if successful, false on error.
      @param fileName the name of the calendar on disk.
    */
//    bool load( const TQString &fileName );
    /**
      Writes out the calendar to disk in the specified \a format.
      ExchangeCalendar takes ownership of the CalFormat object.
      @return true, if successful, false on error.
      @param fileName the name of the file
    */
//    bool save( const TQString &fileName, CalFormat *format = 0 );

    /** clears out the current calendar, freeing all used memory etc. etc. */
//    void close();

    /** Add Event to calendar. */
    KDE_DEPRECATED bool addEvent( Event *event );
    bool addEvent( Event *event, const TQString &subresource );

    /** deletes an event from this calendar. */
    bool deleteEvent(Event *);

    // Isn't called anymore.
    void changeIncidence( Incidence * );

    /**
      Retrieves an event on the basis of the unique string ID.
    */
    Event *event(const TQString &UniqueStr);
    /**
      Return filtered list of all events in calendar.
    */
//    Event::List events();
    /**
      Return unfiltered list of all events in calendar.
      Use with care, since this causes a LOT of network activity
    */
    Event::List rawEvents();

    virtual void subscribeEvents( const TQDate& start, const TQDate& end );

    /**
      Stop receiving event signals for the given period (inclusive). After this call,
      the calendar resource will no longer send eventsAdded, eventsModified or
      eventsDeleted signals for events falling completely in this period. The resource
      MAY delete the Events objects. The application MUST NOT dereference pointers
      to the relevant Events after this call.
    */
    virtual void unsubscribeEvents( const TQDate& start, const TQDate& end );

    /**
      Add a todo to the todolist.
    */
    KDE_DEPRECATED bool addTodo( Todo *todo );
    bool addTodo( Todo *todo, const TQString &subresource );
    /**
      Remove a todo from the todolist.
    */
    bool deleteTodo( Todo * );
    /**
      Searches todolist for an event with this unique string identifier,
      returns a pointer or null.
    */
    Todo *todo( const TQString &uid );
    /**
      Return list of all todos.
    */
    Todo::List rawTodos( TodoSortField sortField = TodoSortUnsorted, SortDirection sortDirection = SortDirectionAscending );
    /**
      Returns list of todos due on the specified date.
    */
    Todo::List rawTodosForDate( const TQDate &date );

    /** Add a Journal entry to calendar */
    KDE_DEPRECATED bool addJournal( Journal *journal );
    bool addJournal( Journal *journal, const TQString &subresource );
    /** deletes an event from this calendar. */
    virtual bool deleteJournal(Journal *);
    /** Return Journals for given date */
    virtual Journal::List journals(const TQDate &);
    /** Return Journal with given UID */
    virtual Journal *journal(const TQString &UID);
    /** Return list of all Journals stored in calendar */
    Journal::List rawJournals( JournalSortField sortField = JournalSortUnsorted,  SortDirection sortDirection = SortDirectionAscending );
    /** Return journals for the given date. */
    Journal::List rawJournalsForDate( const TQDate & );

    /** Return all alarms, which ocur in the given time interval. */
    Alarm::List alarms( const TQDateTime &from, const TQDateTime &to );

    /** Return all alarms, which ocur before given date. */
    Alarm::List alarmsTo( const TQDateTime &to );

    friend class ResourceExchangeConfig;

  protected:
    /**
      Prepare the calendar for use. Load the calendar from disk,
      open connections to the calendaring server, whatever.
      Must be called before other methods can be called.
    */
    virtual bool doOpen();

    /** clears out the current calendar, freeing all used memory etc. etc. */
    virtual void doClose();

    virtual bool doLoad();
    virtual bool doSave();

  public:
    /**
      Builds and then returns a list of all events that match for the
      date specified. useful for dayView, etc. etc.
    */
    Event::List rawEventsForDate(
      const TQDate &date,
      EventSortField sortField=EventSortUnsorted,
      SortDirection sortDirection=SortDirectionAscending );

    /**
      Get unfiltered events for date \a qdt.
    */
    Event::List rawEventsForDate( const TQDateTime &qdt );
    /**
      Get unfiltered events in a range of dates. If inclusive is set to true,
      only events are returned, which are completely included in the range.
    */
    Event::List rawEvents( const TQDate &start, const TQDate &end,
                               bool inclusive = false );
    /**
       Get unfiltered events in sorted order.
    */
    Event::List rawEvents( EventSortField sortField = EventSortUnsorted, SortDirection sortDirection = SortDirectionAscending );

    protected:
    /** Notification function of IncidenceBase::Observer. */
    void incidenceUpdated( IncidenceBase *i );

    /** inserts an event into its "proper place" in the calendar. */
//    void insertEvent(const Event *anEvent);

    /** Append alarms of incidence in interval to list of alarms. */
//    void appendAlarms( Alarm::List &alarms, Incidence *incidence,
//                       const TQDateTime &from, const TQDateTime &to );

    /** Append alarms of recurring events in interval to list of alarms. */
//    void appendRecurringAlarms( Alarm::List &alarms, Incidence *incidence,
//                       const TQDateTime &from, const TQDateTime &to );

    bool uploadEvent( Event *event );

    void setTimeZoneId( const TQString &tzid );

  protected slots:
    void slotMonitorNotify( const TQValueList<long>& IDs, const TQValueList<KURL>& urls);
    void slotMonitorError( int errorCode, const TQString& moreInfo );
    void slotDownloadFinished( int result, const TQString& moreinfo );
    void downloadedEvent( KCal::Event*, const KURL& );

  private:
    class EventInfo;
    KPIM::ExchangeAccount* mAccount;
    KPIM::ExchangeClient* mClient;
    KPIM::ExchangeMonitor* mMonitor;
    CalendarLocal* mCache;
    TQDict<EventInfo> mEventDict; // maps UIDS to EventInfo records
    TQIntDict<EventInfo> mWatchDict; // maps Watch IDs to EventInfo records
    DateSet* mDates;
    TQMap<Event, TQDateTime>* mEventDates;
    TQMap<TQDate, TQDateTime>* mCacheDates;
    int mCachedSeconds;
    bool mAutoMailbox;
    TQString mTimeZoneId;

    TDEABC::Lock *mLock;

    // FIXME: Remove variable, use ResourceCached::changedIncidences() instead.
    Incidence::List mChangedIncidences;
};

}

#endif
