/*
    htmlstatusbar.cpp

    This file is part of KMail, the KDE mail client.
    Copyright (c) 2002 Ingo Kloecker <kloecker@kde.org>
    Copyright (c) 2003 Marc Mutz <mutz@kde.org>

    KMail is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.

    KMail is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "htmlstatusbar.h"

#ifndef KMAIL_TESTING
#include "kmkernel.h"
#else
#include <tdeapplication.h>
#endif

#include <tdelocale.h>
#include <tdeconfig.h>

#include <tqcolor.h>
#include <tqstring.h>

KMail::HtmlStatusBar::HtmlStatusBar( TQWidget * parent, const char * name, WFlags f )
  : TQLabel( parent, name, f ),
    mMode( Normal )
{
  setAlignment( AlignHCenter|AlignTop );
  // Don't force a minimum height to the reader widget
  setSizePolicy( TQSizePolicy( TQSizePolicy::Preferred, TQSizePolicy::Ignored ) );
  upd();
}

KMail::HtmlStatusBar::~HtmlStatusBar() {}

void KMail::HtmlStatusBar::upd() {
  setEraseColor( bgColor() );
  setPaletteForegroundColor( fgColor() );
  setText( message() );
}

void KMail::HtmlStatusBar::setNormalMode() {
  setMode( Normal );
}

void KMail::HtmlStatusBar::setHtmlMode() {
  setMode( Html );
}

void KMail::HtmlStatusBar::setNeutralMode() {
  setMode( Neutral );
}

void KMail::HtmlStatusBar::setMode( Mode m ) {
  if ( m == mode() )
    return;
  mMode = m;
  upd();
}

TQString KMail::HtmlStatusBar::message() const {
  switch ( mode() ) {
  case Html: // bold: "HTML Message"
    return i18n( "<qt><b><br>H<br>T<br>M<br>L<br> "
		 "<br>M<br>e<br>s<br>s<br>a<br>g<br>e</b></qt>" );
  case Normal: // normal: "No HTML Message"
    return i18n( "<qt><br>N<br>o<br> "
		 "<br>H<br>T<br>M<br>L<br> "
		 "<br>M<br>e<br>s<br>s<br>a<br>g<br>e</qt>" );
  default:
  case Neutral:
    return TQString();
  }
}

namespace {
  inline TDEConfig * config() {
#ifndef KMAIL_TESTING
    return KMKernel::config();
#else
    return kApp->config();
#endif
  }
}

TQColor KMail::HtmlStatusBar::fgColor() const {
  TDEConfigGroup conf( config(), "Reader" );
  switch ( mode() ) {
  case Html:
    return conf.readColorEntry( "ColorbarForegroundHTML", &TQt::white );
  case Normal:
    return conf.readColorEntry( "ColorbarForegroundPlain", &TQt::black );
  default:
  case Neutral:
    return TQt::black;
  }
}

TQColor KMail::HtmlStatusBar::bgColor() const {
  TDEConfigGroup conf( config(), "Reader" );

  switch ( mode() ) {
  case Html:
    return conf.readColorEntry( "ColorbarBackgroundHTML", &TQt::black );
  case Normal:
    return conf.readColorEntry( "ColorbarBackgroundPlain", &TQt::lightGray );
  default:
  case Neutral:
    return TQt::white;
  }
}

#include "htmlstatusbar.moc"
