/*
    kopetewalletmanager.h - Kopete Wallet Manager

    Copyright (c) 2004      by Richard Smith         <kde@metafoo.co.uk>
    Kopete    (c) 2002-2004 by the Kopete developers <kopete-devel@kde.org>

    *************************************************************************
    *                                                                       *
    * This library is free software; you can redistribute it and/or         *
    * modify it under the terms of the GNU Lesser General Public            *
    * License as published by the Free Software Foundation; either          *
    * version 2 of the License, or (at your option) any later version.      *
    *                                                                       *
    *************************************************************************
*/

#ifndef KOPETEWALLETMANAGER_H
#define KOPETEWALLETMANAGER_H

#include <tqobject.h>

#include <kdemacros.h>

#include "kopete_export.h"

namespace TDEWallet { class Wallet; }

namespace Kopete
{

/**
 * @author Richard Smith <kde@metafoo.co.uk>
 *
 * The Kopete::WalletManager class is a singleton, which looks after Kopete's
 * TDEWallet connection.
 */
class KOPETE_EXPORT WalletManager : public TQObject
{
	TQ_OBJECT
  

public:
	/**
	 * Retrieve the wallet manager instance
	 */
	static WalletManager *self();
	~WalletManager();

	/**
	 * @brief Attempt to open the TDEWallet asyncronously, then signal an
	 *        object to indicate the task is complete.
	 *
	 * @param object The object to call back to
	 * @param slot The slot on object to call; must have signature slot( TDEWallet::Wallet* )
	 *        The parameter to the slot will be the wallet that was opened if the call
	 *        succeeded, or NULL if the wallet failed to open or the Kopete folder was
	 *        inaccessible.
	 *
	 * For simplicity of client code, it is guaranteed that your slot
	 * will not be called during a call to this function.
	 */
	void openWallet( TQObject *object, const char *slot );
	
public slots:
	/**
	 * Close the connection to the wallet. Will cause walletLost() to be emitted.
	 */
	void closeWallet();

signals:
	/**
	 * Emitted when the connection to the wallet is lost.
	 */
	void walletLost();

private slots:
	/**
	 * Called by the stored wallet pointer when it is successfully opened or
	 * when it fails.
	 *
	 * Causes walletOpened to be emitted.
	 */
	void slotWalletChangedStatus();
	
	/**
	 * Called by a singleShot timer in the event that we are asked for a
	 * wallet when we already have one open and ready.
	 */
	void slotGiveExistingWallet();

private:
	void openWalletInner();
	void emitWalletOpened( TDEWallet::Wallet *wallet );

	class Private;
	Private *d;

	WalletManager();
};

}

/**
 * @internal
 */
class KopeteWalletSignal : public TQObject
{
	TQ_OBJECT
  
	friend class Kopete::WalletManager;
signals:
	void walletOpened( TDEWallet::Wallet *wallet );
};

#endif
