/***************************************************************************
                          visualframeeditor.h  -  description
                             -------------------
    begin                : mar mar 25 2003
    copyright            : (C) 2003 by gulmini luciano
    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef VISUALFRAMEEDITOR_H
#define VISUALFRAMEEDITOR_H

#include "treenode.h"
#include "selectablearea.h"
#include <tqhbox.h>

/**
  *@author gulmini luciano
  */


class VisualFrameEditor : public TQHBox  {
   TQ_OBJECT
  
   private:
      enum MarkupLanguage{XHTML,HTML};
      tree *m_internalTree;
      SelectableArea* m_firstInsertedSA;
      TQStringList m_existingStructure;
      MarkupLanguage m_markupLanguage;

      void buildInternalTree(const TQString &parent);
      void setGeometries(const TQString &l);
      void drawGUI(treeNode *n, TQWidget* parent);
      TQStringList convertAsterisks(const TQString &s, int d);

      TQString createFrameTag(areaAttribute *a);
      TQString formatStructure();
      TQString RCvalue(treeNode *n);
      void createStructure(treeNode* n);

   public:
      VisualFrameEditor( TQWidget * parent = 0, const char * name = 0);
      ~VisualFrameEditor();
      void draw() { repaint(); }
      void loadExistingStructure(const TQStringList &list);
      TQString framesetStructure();
      void removeNode(const TQString &l);
      void split(const TQString &l, int n, SplitType type);
      void setMarkupLanguage(const TQString& s);
      tree* internalTree() { return m_internalTree;}

   protected:
      virtual void paintEvent ( TQPaintEvent * );
   signals:
     void areaSelected(const TQString &);
};

#endif
