/***************************************************************************
                          xsldbgoutputview.cpp -  Display raw output from xsldbg
                             -------------------
    begin                : Sat July 27 2002
    copyright            : (C) 2002 by keith Isdale
    email                : k_isdale@tpg.com.au
 ***************************************************************************/

/***********************************************************************************
 *                                                                         										*
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                   							*
 *                                                                         										*
 ************************************************************************************/

/**
  *@author Keith Isdale
  */

#include <tdelocale.h>

#include <tqlayout.h>
#include <tqmessagebox.h>
#include <tqdialog.h>
#include <tqpushbutton.h>
#include <tqlabel.h>

#include "xsldbgmsgdialogimpl.h"


XsldbgMsgDialogImpl::XsldbgMsgDialogImpl(TQWidget *parent,
					 TQMessageBox::Icon icon,
					 const TQString &title, const TQString &msg)
  : XsldbgMsgDialog(parent, "XsldbgMsgDialogImpl" , TRUE )
{
  setCaption(title);

  TQMessageBox tmpMsg;
  tmpMsg.setIcon(icon);
  msgTextEdit->setText(msg);
  iconLbl->setPixmap(*tmpMsg.iconPixmap());
}

void XsldbgMsgDialogImpl::append(const TQString &text)
{
  msgTextEdit->append(text);
}



#include "xsldbgoutputview.h"

XsldbgOutputView::XsldbgOutputView(TQWidget * parent)
  : TQTextEdit(parent, "outputview")
{
  new TQBoxLayout(this, TQBoxLayout::TopToBottom);
  setSizePolicy(TQSizePolicy(TQSizePolicy::Preferred, TQSizePolicy::Preferred));
  setMinimumSize(TQSize(500, 80));
  setCaption(i18n("xsldbg Output"));
  setText(i18n("\t\txsldbg output capture ready\n\n"));
  dlg = 0L;
  show();
  setReadOnly(TRUE);
}

void XsldbgOutputView::slotProcShowMessage(TQString  msg)
{
  bool processed = FALSE;
  // Is this a result of an evaluate command
  if ((msg[0] == TQChar('=')) && (msg[1] == TQChar(' '))){
    int endPosition = msg.find(TQChar('\n'));
    if (endPosition >= 0){
      processed = TRUE;
      showDialog(TQMessageBox::Information, i18n("Result of evaluation"),
		 msg.mid(endPosition + 1));
    }
  }else  /* Is there some sort of error message in msg */
    if ((msg.find("Error:") != -1) ||
	(msg.find("Warning:") != -1) ||
	(msg.find("Request to xsldbg failed") != -1) ||
         /* the following errors are libxml or libxslt generated */
	(msg.find("error:") != -1) ||
	(msg.find("xmlXPathEval:") != -1) ||
	(msg.find("runtime error")  != -1)) {
      /* OK we've found an error but ingore any errors about
	 data or source files */
      if ((msg.find("Error: No XSL source file supplied") == -1) &&
	  (msg.find("Error: No XML data file supplied") == -1) &&
	  (msg.find("Load of source deferred") == -1) &&
	  (msg.find("Load of data deferred") == -1) )
	showDialog(TQMessageBox::Warning, i18n("Request Failed "),
		 msg);
      processed = TRUE;
  }
  if (processed == FALSE){
    if (isVisible() == FALSE)
      show();
    append(msg);
  }
}


void XsldbgOutputView::slotClearView()
{
}

void XsldbgOutputView::showDialog(TQMessageBox::Icon icon, TQString title,
				  TQString msg)
{

  if ( dlg ){
    // not pretty, add this text to the open dialog when multiple
    // calls to showDialog are made
    dlg->append(msg);
  }else{
      dlg = new XsldbgMsgDialogImpl(this, icon, title, msg);
      if ( dlg ){
	dlg->exec();
	delete dlg;
	dlg = 0L;
      }
  }
}



#include "xsldbgoutputview.moc"
