/***************************************************************************
             profilesdialog.h  -  KVocTrain profiles dialog

                             -------------------
    begin                : Fri Apr 29 2005

    copyright            : (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *
 ***************************************************************************/

#ifndef PROFILESDIALOG_H
#define PROFILESDIALOG_H

#include <tqvaluelist.h>

#include <kdialogbase.h>

/**
@author Peter Hedlund
*/

class QueryManager;
class GroupOptions;

class KDE_EXPORT SettingsProfile
{
public:
  SettingsProfile();
  SettingsProfile (TQString n, TQString q, TQString t, TQString b);

  TQString name;
  TQString query_set;
  TQString thresh_set;
  TQString block_set;
};

class KDE_EXPORT ProfilesDialog : public KDialogBase
{
  TQ_OBJECT
  

public:
  ProfilesDialog(QueryManager * m, TQWidget *parent = 0, const char *name = 0, bool modal = true);

signals:
  void profileActivated();

protected slots:
  void slotDeleteGroup();
  void slotNewGroup();
  void slotStoreGroup();
  void slotRecallGroup();

private:
  void selectProfile(int profile);
  void modifyProfile(int profile);
  void saveProfiles();

  typedef TQValueList<SettingsProfile> Profiles;
  Profiles profiles;
  QueryManager * m_queryManager;
  GroupOptions * mw;
};

#endif
