// Copyright (C) 2005 by Shaheed Haque (srhaque@iee.org). All rights reserved.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
#ifndef KCDDB_CATEGORIES_H
#define KCDDB_CATEGORIES_H

#include <tqstring.h>
#include <tqstringlist.h>

namespace KCDDB
{
   /**
    * Category values defined by CDDB.
    */
    class Categories
    {
    public:
        Categories();

        const TQStringList &cddbList() const { return m_cddb; };
        const TQStringList &i18nList() const { return m_i18n; };
        
        /**
         * Lookup the CDDB category, and return the i18n'd version.
         */
        const TQString cddb2i18n(const TQString &category) const;

        /**
         * Lookup the i18n category, and return the CDDB version.
         */
        const TQString i18n2cddb(const TQString &category) const;
    private:
        TQStringList m_cddb;
        TQStringList m_i18n;
    };
}

#endif
