//package com.werpu.simplemail;


import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

/**
 *
 * @author  Werner Punz werpu@gmx.at
 * @version 1.0
 * This is a basic Mailer class built upon the JavaMail API
 * it only does SMTP.
 */
public class MailHelper
{

	private String message = "";

	private String recipient = "";

	private String server = "";

	private String password = "";

	private String sender = "";

	private String subject = "";

	private String username = "";

	private LinkedList ccAddresses = new LinkedList();

	/** Creates a new instance of LC_Mailer */
	public MailHelper()
	{
	}

	/** Getter for property message.
	 * @return Value of property message.
	 */
	public String getMessage()
	{
		return message;
	}

	/** Setter for property message.
	 * @param message New value of property message.
	 */
	public void setMessage(String message)
	{
		this.message = message;
	}

	/** Getter for property password.
	 * @return Value of property password.
	 */
	public String getPassword()
	{
		return password;
	}

	/** Setter for property password.
	 * @param password New value of property password.
	 */
	public void setPassword(String password)
	{
		this.password = password;
	}

	/** Getter for property recipient.
	 * @return Value of property recipient.
	 */
	public String getRecipient()
	{
		return recipient;
	}

	/** Setter for property recipient.
	 * @param recipient New value of property recipient.
	 */
	public void setRecipient(String recipient)
	{
		this.recipient = recipient;
	}

	/** Getter for property sender.
	 * @return Value of property sender.
	 */
	public String getSender()
	{
		return sender;
	}

	/** Setter for property sender.
	 * @param sender New value of property sender.
	 */
	public void setSender(String sender)
	{
		this.sender = sender;
	}

	/** Getter for property server.
	 * @return Value of property server.
	 */
	public String getServer()
	{
		return server;
	}

	/** Setter for property server.
	 * @param server New value of property server.
	 */
	public void setServer(String server)
	{
		this.server = server;
	}

	/** Getter for property subject.
	 * @return Value of property subject.
	 */
	public String getSubject()
	{
		return subject;
	}

	/** Setter for property subject.
	 * @param subject New value of property subject.
	 */
	public void setSubject(String subject)
	{
		this.subject = subject;
	}

	/**
	 * Method setUsername.
	 * @param username
	 */
	public void setUsername(String username)
	{
		this.username = username;
	}

	/**
	 * Method addCCAddress.
	 * @param ccAddresses
	 * Adds a single CC Adress to the current CC Addresses
	 */
	public void addCCAddress(String ccAddresses)
	{
		if (!ccAddresses.equalsIgnoreCase("null"))
			this.ccAddresses.add(ccAddresses);
	}

	/**
	 * Method addCCAddress.
	 * @param ccAddresses
	 * adds the ccAddresses to the current messaging parameters
	 */
	public void addCCAddress(Iterator ccAddresses)
	{

		while (ccAddresses.hasNext())
			addCCAddress((String) ccAddresses.next());
	}

	/**
	 * Method send.
	 * @throws MessagingException
	 * sends out the mail with the set messaging parameters
	 */
	public void send() throws MessagingException
	{
		Properties props = new Properties();
                Session session = Session.getDefaultInstance(props, null);


                Address to = new InternetAddress(getRecipient());
		Address from = new InternetAddress(getSender());

                //only one from address
                Address[] froms = new Address[1];
		froms[0] = from;

            	MimeMessage message = new MimeMessage(session);
		message.setText(getMessage());
		message.setSubject(getSubject());
		message.addRecipient(Message.RecipientType.TO, to);

		//Add CCs to the recipient list
		Iterator i = ccAddresses.iterator();
		while (i.hasNext())
		{
			to = new InternetAddress((String) i.next());
			message.addRecipient(Message.RecipientType.BCC, to);
		}

		message.addFrom(froms);
		message.saveChanges();


                //set smtp
		Transport myTransport = session.getTransport("smtp");

                //send mail
		myTransport.connect(getServer(), username.trim(), password.trim());

		myTransport.sendMessage(message,message.getAllRecipients());
		myTransport.close();
	}

}
