/***************************************************************************
* $Id$
**
* Copyright ( C ) 1992-2000 Trolltech AS.  All rights reserved.
**
* This file is part of an example program for Qt.  This example
* program may be used, distributed and modified without limitation.
**
****************************************************************************/

import org.trinitydesktop.qt.*;
import java.util.*;

class Scribble  extends TQMainWindow
{

protected Canvas canvas;

protected TQSpinBox bPWidth;
protected TQToolButton bPColor, bSave, bClear;



class Canvas  extends TQWidget
{

    void setPenColor( TQColor c )
    { pen.setColor( c ); }

    void setPenWidth( int w )
    { pen.setWidth( w ); }

    TQColor penColor()
    { return pen.color(); }

    int penWidth()
    { return pen.width(); }


protected TQPen pen;
protected TQPointArray polyline;

protected boolean mousePressed;

protected TQPixmap buffer = new TQPixmap();

public boolean no_writing = false;

Canvas( TQWidget parent )
{
	this(parent, null);
}

Canvas( TQWidget parent, String name )
{
    super( parent, name, WStaticContents );
	pen = new TQPen( Qt.red(), 3 );
	polyline = new TQPointArray(3);

    if ((tqApp().args().length > 0) && !buffer.load(tqApp().args()[0]))
	buffer.fill( colorGroup().base() );
    setBackgroundMode( TQWidget.PaletteBase );
    setCursor( Qt.crossCursor() );
}

void save( String filename, String format )
{
    if ( !no_writing )
	buffer.save( filename, format.toUpperCase() );
}

void clearScreen()
{
    buffer.fill( colorGroup().base() );
    repaint( false );
}

protected void mousePressEvent( TQMouseEvent e )
{
    mousePressed = true;
    polyline.setPoint(0, e.pos());
    polyline.setPoint(1, e.pos());
    polyline.setPoint(2, e.pos());
}

protected void mouseReleaseEvent( TQMouseEvent e  )
{
    mousePressed = false;
}

protected void mouseMoveEvent( TQMouseEvent e )
{
    if ( mousePressed ) {
	TQPainter painter = new TQPainter();
	painter.begin( buffer );
	painter.setPen( pen );
	polyline.setPoint(2, polyline.at(1));
	polyline.setPoint(1, polyline.at(0));
	polyline.setPoint(0, e.pos());
	painter.drawPolyline( polyline );
	painter.end();

	TQRect r = polyline.boundingRect();
	r = r.normalize();
	r.setLeft( r.left() - penWidth() );
	r.setTop( r.top() - penWidth() );
	r.setRight( r.right() + penWidth() );
	r.setBottom( r.bottom() + penWidth() );

	bitBlt( this, r.x(), r.y(), buffer, r.x(), r.y(), r.width(), r.height() );
    }
}

protected void resizeEvent( TQResizeEvent e )
{
    super.resizeEvent( e );

    int w = width() > buffer.width() ?
	    width() : buffer.width();
    int h = height() > buffer.height() ?
	    height() : buffer.height();

    TQPixmap tmp = new TQPixmap( buffer );
    buffer.resize( w, h );
    buffer.fill( colorGroup().base() );
    bitBlt( buffer, 0, 0, tmp, 0, 0, tmp.width(), tmp.height() );
}

protected void paintEvent( TQPaintEvent e )
{
    super.paintEvent( e );
    ArrayList rects = e.region().rects();
    for ( int i = 0; i < rects.size(); i++ ) {
	TQRect r = (TQRect) rects.get(i);
	bitBlt( this, r.x(), r.y(), buffer, r.x(), r.y(), r.width(), r.height() );
    }
}

}

//------------------------------------------------------

Scribble( )
{
	this(null, null);
}

Scribble( TQWidget parent, String name )
{
    super( parent, name );
    canvas = new Canvas( this );
    setCentralWidget( canvas );

    TQToolBar tools = new TQToolBar( this );

    bSave = new TQToolButton( new TQIconSet(), "Save", "Save as PNG image", this, TQ_SLOT(" slotSave()"), tools );
    bSave.setText( "Save as..." );

    tools.addSeparator();

    bPColor = new TQToolButton( new TQIconSet(), "Choose Pen Color", "Choose Pen Color", this, TQ_SLOT(" slotColor()"), tools );
    bPColor.setText( "Choose Pen Color..." );

    tools.addSeparator();

    bPWidth = new TQSpinBox( 1, 20, 1, tools );
    TQToolTip.add( bPWidth, "Choose Pen Width" );
    connect( bPWidth, TQ_SIGNAL(" valueChanged( int )"), this, TQ_SLOT(" slotWidth( int )") );
    bPWidth.setValue( 3 );

    tools.addSeparator();

    bClear = new TQToolButton( new TQIconSet(), "Clear Screen", "Clear Screen", this, TQ_SLOT(" slotClear()"), tools );
    bClear.setText( "Clear Screen" );
}

void slotSave()
{
    TQPopupMenu menu = new TQPopupMenu( null );
    HashMap formats = new HashMap();

    for ( int i = 0; i < TQImageIO.outputFormats().size(); i++ ) {
	String str = (String) TQImageIO.outputFormats().get( i );
	formats.put( new Integer(menu.insertItem( str + "..." )),  str );
    }

    menu.setMouseTracking( true );
    int id = menu.exec( bSave.mapToGlobal( new TQPoint( 0, bSave.height() + 1 ) ) );

    if ( id != -1 ) {
	String format = (String) formats.get( new Integer(id) );

	String filename = TQFileDialog.getSaveFileName( "", "*." + format.toLowerCase(), this );
	if ( !filename.equals("") )
	    canvas.save( filename, format );
    }

}

void slotColor()
{
    TQColor c = TQColorDialog.getColor( canvas.penColor(), this );
    if ( c.isValid() )
	canvas.setPenColor( c );
}

void slotWidth( int w )
{
    canvas.setPenWidth( w );
}

void slotClear()
{
    canvas.clearScreen();
}
}
