/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "parafieldwidget.h"
#include "../field.h"
#include "../latin1literal.h"

#include <ktextedit.h>

using Tellico::GUI::ParaFieldWidget;

ParaFieldWidget::ParaFieldWidget(Data::FieldPtr field_, TQWidget* parent_, const char* name_/*=0*/)
    : FieldWidget(field_, parent_, name_) {

  m_textEdit = new KTextEdit(this);
  m_textEdit->setTextFormat(TQt::PlainText);
  if(field_->property(TQString::fromLatin1("tools-check-spelling")) != Latin1Literal("false")) {
    m_textEdit->setCheckSpellingEnabled(true);
  }
  connect(m_textEdit, TQT_SIGNAL(textChanged()), TQT_SIGNAL(modified()));

  registerWidget();
}

TQString ParaFieldWidget::text() const {
  TQString text = m_textEdit->text();
  text.replace('\n', TQString::fromLatin1("<br/>"));
  return text;
}

void ParaFieldWidget::setText(const TQString& text_) {
  blockSignals(true);
  m_textEdit->blockSignals(true);

  TQRegExp rx(TQString::fromLatin1("<br/?>"), false /*case-sensitive*/);
  TQString s = text_;
  s.replace(rx, TQChar('\n'));
  m_textEdit->setText(s);

  m_textEdit->blockSignals(false);
  blockSignals(false);
}

void ParaFieldWidget::clear() {
  m_textEdit->clear();
  editMultiple(false);
}

TQWidget* ParaFieldWidget::widget() {
  return m_textEdit;
}

#include "parafieldwidget.moc"
