/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : $EMAIL
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#include "listboxtext.h"
#include "../tellico_utils.h"

#include <tqpainter.h>

using Tellico::GUI::ListBoxText;

ListBoxText::ListBoxText(TQListBox* listbox_, const TQString& text_)
    : TQListBoxText(listbox_, text_), m_colored(false) {
}

ListBoxText::ListBoxText(TQListBox* listbox_, const TQString& text_, TQListBoxItem* after_)
    : TQListBoxText(listbox_, text_, after_), m_colored(false) {
}

int ListBoxText::width(const TQListBox* listbox_) const {
  if(m_colored) {
    TQFont font = listbox_->font();
    font.setBold(true);
    font.setItalic(true);
    TQFontMetrics fm(font);
    return fm.width(text()) + 6;
  } else {
    return TQListBoxText::width(listbox_);
  }
}

// I don't want the height to change when colored
// so all the items are at the same level for multi-column boxes
int ListBoxText::height(const TQListBox* listbox_) const {
  return TQListBoxText::height(listbox_);
}

void ListBoxText::setColored(bool colored_) {
  if(m_colored != colored_) {
    m_colored = colored_;
    listBox()->triggerUpdate(false);
  }
}

void ListBoxText::setText(const TQString& text_) {
  TQListBoxText::setText(text_);
  listBox()->triggerUpdate(true);
}

// mostly copied from TQListBoxText::paint() in TQt 3.1.1
void ListBoxText::paint(TQPainter* painter_) {
  if(m_colored) {
    TQFont font = painter_->font();
    font.setBold(true);
    font.setItalic(true);
    painter_->setFont(font);
    if(!isSelected()) {
      painter_->setPen(Tellico::contrastColor);
    }
  }
  int itemHeight = height(listBox());
  TQFontMetrics fm = painter_->fontMetrics();
  int yPos = ((itemHeight - fm.height()) / 2) + fm.ascent();
  painter_->drawText(3, yPos, text());
}
