/***************************************************************************
    copyright            : (C) 2002-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICOENTRYICONVIEW_H
#define TELLICOENTRYICONVIEW_H

#include "observer.h"
#include "entry.h"

#include <kiconview.h>

#include <tqintdict.h>

namespace Tellico {
  class EntryIconViewItem;
  namespace Data {
    class Collection;
  }
  class ListViewComparison;

/**
 * @author Robby Stephenson
 */
class EntryIconView : public TDEIconView, public Observer {
TQ_OBJECT
  

friend class EntryIconViewItem;

public:
  EntryIconView(TQWidget* parent, const char* name = 0);
  ~EntryIconView();

  EntryIconViewItem* firstItem() const;

  virtual void clear();
  void refresh();
  void showEntries(const Data::EntryVec& entries);
  /**
   * Adds a new list item showing the details for a entry.
   *
   * @param entry A pointer to the entry
   */
  virtual void    addEntries(Data::EntryVec entries);
  virtual void modifyEntries(Data::EntryVec entries);
  virtual void removeEntries(Data::EntryVec entries);

  const TQString& imageField();
  const TQString& sortField();
  void setMaxAllowedIconWidth(int width);
  int maxAllowedIconWidth() const { return m_maxAllowedIconWidth; }

  const TQPixmap& defaultPixmap();
  /**
   * Returns a list of the currently selected items;
   *
   * @return The list of selected items
   */
  const TQPtrList<EntryIconViewItem>& selectedItems() const { return m_selectedItems; }

  int compare(const EntryIconViewItem* item1, EntryIconViewItem* item2);

private slots:
  void slotSelectionChanged();
  void slotDoubleClicked(TQIconViewItem* item);
  void slotShowContextMenu(TQIconViewItem* item, const TQPoint& point);
  void slotSortMenuActivated(int id);

private:
  /**
   * Updates the pointer list.
   *
   * @param item The item being selected or deselected
   * @param s Selected or not
   */
  void updateSelected(EntryIconViewItem* item, bool s) const;
  mutable TQPtrList<EntryIconViewItem> m_selectedItems;

  void findImageField();
  void fillView();

  Data::CollPtr m_coll;
  Data::EntryVec m_entries;
  TQString m_imageField;
  TQIntDict<TQPixmap> m_defaultPixmaps;
  int m_maxAllowedIconWidth;
  int m_maxIconWidth;
  int m_maxIconHeight;
  ListViewComparison* m_comparison;
};

class EntryIconViewItem : public TDEIconViewItem {
public:
  EntryIconViewItem(EntryIconView* parent, Data::EntryPtr entry);
  ~EntryIconViewItem();

  EntryIconView* iconView() const { return static_cast<EntryIconView*>(TDEIconViewItem::iconView()); }
  EntryIconViewItem* nextItem() const { return static_cast<EntryIconViewItem*>(TDEIconViewItem::nextItem()); }

  Data::EntryPtr entry() const { return m_entry; }
  virtual void setSelected(bool s, bool cb);
  virtual void setSelected(bool s);
  virtual TQString key() const;
  virtual int compare(TQIconViewItem* item_) const;

  bool usesImage() const { return m_usesImage; }
  void updatePixmap();

  void update();

protected:
  virtual void calcRect(const TQString& text = TQString());
  virtual void paintItem(TQPainter* p, const TQColorGroup& cg);
  virtual void paintFocus(TQPainter* p, const TQColorGroup& cg);
  void paintPixmap(TQPainter* p, const TQColorGroup& cg);
  void paintText(TQPainter* p, const TQColorGroup& cg);

private:
  Data::EntryPtr m_entry;
  bool m_usesImage : 1;
};

} // end namespace
#endif
