/*
	msettingsdialog.h - A settings dialog
	Copyright (C) 2003  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __MSETTINGSDIALOG_H__
#define __MSETTINGSDIALOG_H__

#include "actions.h"

#include <kdialogbase.h>

class TQCheckBox;
class TQHButtonGroup;

class TDEConfigDialogManager;
class KIntNumInput;
class KLineEdit;
class TDEListView;
class TDEListViewItem;
class KPushButton;

/** @short A settings dialog. */
class MSettingsDialog: public KDialogBase
{
	TQ_OBJECT
public:
	/**
	 * Constructor. Creates a new modal settings dialog.
	 * @param parent A parent widget
	 */
	MSettingsDialog(TQWidget *parent);

	/**
	 * Destructor.
	 */
	virtual ~MSettingsDialog();

	inline static void freeInstance() {
		if (_instance) {
			delete _instance;
			_instance = 0;
		}
	}

	inline static bool isActive() {
		if (_instance) {
			_instance->raise();

			return true;
		}

		return false;
	}
private:
	static int _lastPage;
	static MSettingsDialog *_instance;
	TDEConfigDialogManager *_configDialogManager;
	KIntNumInput *in_warningMessageDelay;
	KLineEdit *in_customMessageCommand;
	TDEListView *_actions;
	TDEListViewItem
		*_lockScreenItem,
		*_logoutItem,
		*_rebootItem,
		*_shutDownItem;
	KPushButton *b_enableAllMessages;
	TQCheckBox *c_autoLock;
	TQFrame
		*_actionsPage,
		*_advancedPage,
		*_generalPage,
		*_messagesPage;
	TQHButtonGroup *gb_systemTray;

	TQFrame *addPage(const TQString &itemName, const TQString &iconName);

	/**
	 * Returns @c true if page has been disabled by the administrator (Kiosk mode).
	 * @param key A configuration entry (in the @c kshutdownrc file)
	 * @param page A dialog page
	 * @param pageLayout A dialog page layout
	 */
	bool disabledByAdmin(const TQString &key, TQFrame *page = 0, TQBoxLayout *pageLayout = 0) const;

	void initActionsPage();
	void initAdvancedPage();
	void initGeneralPage();
	void initMessagesPage();
	Action::Type itemToActionType(const TDEListViewItem *item) const;
	void updateActions();
	void updateItem(TDEListViewItem *item);
private slots:
	void slotCheckSystemConfig();
	void slotConfigChanged();
	void slotCustomMessageTest();
	void slotEditAction();
	void slotEnableAllMessages();
	void slotKDESettings();
	void slotOKClicked();
	void slotSetAmorCustomMessage();
	void slotSetKDialogCustomMessage();
	void slotShutDownProblem();
	void slotTrayMessageProblem();
	void slotWarningMessageTest();
protected slots:
	/**
	 * Sets default values in a current page.
	 */
	virtual void slotDefault();
};

#endif // __MSETTINGSDIALOG_H__
