 /**************************************************************************
 *   Copyright (C) 2006-2007 by Danny Kukawka                              *
 *                           <dkukawka@suse.de>, <danny.kukawka@web.de>    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License     *
 *   as published by the Free Software Foundation.                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

/*!
*  \file 	dbusInterface.h
*  \brief 	Headerfile for dbusInterface.cpp and the class \ref dbusInterface.
*/
/*!
*  \class 	dbusInterface
*  \brief 	class for connection to D-Bus
*  \author 	Danny Kukawka, <dkukawka@suse.de>, <danny.kukawka@web.de>
*  \date    	2006-2007
*/

#ifndef _DBUS_INTERFACE_H_
#define _DBUS_INTERFACE_H_

#ifndef DBUS_API_SUBJECT_TO_CHANGE
#define DBUS_API_SUBJECT_TO_CHANGE
#endif

// QT - Header
#include <tqobject.h>
#include <tqstring.h>

// D-Bus Header
#include <tqdbusconnection.h>
#include <tqdbusobjectpath.h>
#include <tqdbusproxy.h>
#include <tqdbusunixfd.h>

// tdepowersave - Header
#include "tdepowersave_debug.h"

#define CK_SERVICE		"org.freedesktop.ConsoleKit"
#define CK_MANAGER_IFACE	"org.freedesktop.ConsoleKit.Manager"
#define CK_MANAGER_OBJECT	"/org/freedesktop/ConsoleKit/Manager"
#define CK_SESSION_IFACE	"org.freedesktop.ConsoleKit.Session"
#define CK_SEAT_IFACE		"org.freedesktop.ConsoleKit.Seat"

#define SYSTEMD_LOGIN1_SERVICE		"org.freedesktop.login1"
#define SYSTEMD_LOGIN1_PATH		"/org/freedesktop/login1"
#define SYSTEMD_LOGIN1_MANAGER_IFACE	"org.freedesktop.login1.Manager"
#define SYSTEMD_LOGIN1_SESSION_IFACE	"org.freedesktop.login1.Session"
#define SYSTEMD_LOGIN1_SEAT_IFACE	"org.freedesktop.login1.Seat"

class dbusInterface : public TQObject{
	TQ_OBJECT
	

private:

	//! TQt connection to D-Bus
	TQT_DBusConnection dBusConn;

	//! TQt D-Bus proxy for watching signals
	TQT_DBusProxy* dBusWatch;
	TQT_DBusProxy* dBusLocal;

	TQT_DBusObjectPath systemdSession;
	TQT_DBusProxy* systemdSeat;
	TQT_DBusUnixFd systemdInhibit;

	TQT_DBusObjectPath consolekitSession;
	TQT_DBusProxy* consolekitSeat;

	/* D-Bus helper functions */
	//! to initialise the connection to D-Bus 
	bool initDBUS();

	//! handles signal service registred/unregistered
	void onServiceRegistered(const TQString&);
	void onServiceUnregistered(const TQString&);

private slots:

	//! to reconnect to D-Bus
	bool reconnect();

public:

	//! default constructor
	dbusInterface();
	//! default destructor
	~dbusInterface();

	//! to close the connection to D-Bus
	bool close();

	// --- helper to get private members of the class --- //
	//! to get information if TDEPowersave is connected to D-Bus
	bool isConnectedToDBUS();

	//! to check active session state
	bool checkActiveSession();

public slots:

	void handleDBusSignal(const TQT_DBusMessage&);

signals:

	void activeSessionChanged(bool);

};

#endif
