###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for dbus-binding-tool

find_program( DBUS_BINDING_TOOL NAMES dbus-binding-tool )

if( "${DBUS_BINDING_TOOL}" STREQUAL "DBUS_BINDING_TOOL-NOTFOUND" )
   tde_message_fatal( "The dbus-binding-tool executable is required, but was not found on your system" )
  else()
   set( _DBUS_TOOL dbus-binding-tool )
endif( )


##### check for dbus-1

pkg_search_module( DBUS dbus-1 )
if( NOT DBUS_FOUND )
   tde_message_fatal( "The dbus library is required, but was not found on your system" )
endif( NOT DBUS_FOUND )


##### check for dbus-glib-1

pkg_search_module( DBUS-GLIB dbus-glib-1 )
if( NOT DBUS-GLIB_FOUND )
   tde_message_fatal( "The dbus-glib library is required, but was not found on your system" )
endif( NOT DBUS-GLIB_FOUND )


##### check for glib-2.0

pkg_search_module( GLIB2 glib-2.0 )
if( NOT GLIB2_FOUND )
   tde_message_fatal( "The glib2.0 library is required, but was not found on your system" )
endif( NOT GLIB2_FOUND )


##### check for gtk2.0

find_package( GTK2 )
if( NOT GTK2_FOUND )
   tde_message_fatal( "The gtk2.0 library is required, but was not found on your system" )
endif( NOT GTK2_FOUND )
