/***************************************************************************
 *   Copyright (C) 2007 by Frode M. Døving   *
 *   frode@lnix.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/


#include "tdeio_umountwrapper.h"

#include <cstdlib>
#include <tqtimer.h>

#include <tdeapplication.h>
#include <tdelocale.h>
#include <kprogress.h>
#include <kprocess.h>
#include <tdecmdlineargs.h>
#include <kdebug.h>

tdeio_umountwrapper::tdeio_umountwrapper(const TQString& url)
    : TDEApplication()
{
    m_progress = new KProgressDialog();
    setMainWidget(m_progress);
    m_progress->setLabel(i18n("Synchronising data to disk, please wait")+"...");
    m_progress->setAutoClose(true);
    m_progress->setAllowCancel(false);
    m_progress->progressBar()->setTextEnabled(false);
    m_progress->progressBar()->setTotalSteps(0);
    m_progress->show();

    TQTimer *t = new TQTimer(this);
    connect(t, TQT_SIGNAL(timeout()), TQT_SLOT(progressAdvance()));
    t->start(10, FALSE);

    TDEProcess *p = new TDEProcess(TQT_TQOBJECT(this));
    *p << "tdeio_media_mounthelper";
    *p << "-s";
    *p << url;
    kdDebug(7136) << "TDEProcess: " << url << endl;
    connect(p, TQT_SIGNAL(processExited(TDEProcess *)),
    this, TQT_SLOT(processFinished(TDEProcess *)));
    p->start();
}

void tdeio_umountwrapper::progressAdvance()
{
    m_progress->progressBar()->advance(1);
}

void tdeio_umountwrapper::processFinished(TDEProcess* p)
{
    if (p->normalExit() && p->exitStatus() == 0)
    {
        ::exit(0);
    }
    else
    {
        ::exit(1);
    }
}

#include "tdeio_umountwrapper.moc"
