/**************************************************************************
*   Copyright (C) 2005 by Jean-Michel Petit                               *
*   jm_petit@laposte.net                                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "k9common.h"
#include <tqpixmap.h>
#include <tqpainter.h>
#include <tqlabel.h>
#include <tqimage.h>
#include <tqpaintdevice.h>
#include <tqslider.h>
#include <tqapplication.h>
#include <tqtoolbutton.h>
#include <tqlayout.h>

#include <string.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <tdelocale.h>
#include <kiconloader.h>
#include "kviewmpeg2.h"
#include "k9config.h"



k9Widget::k9Widget(TQWidget *parent):TQWidget(parent) {
    m_image=NULL;
}

void k9Widget::setImage(TQImage *_image) {
    m_image=_image;
    //paintEvent( NULL);
    repaint(FALSE);
}

void k9Widget::paintEvent( TQPaintEvent *_event) {
    setPaletteBackgroundColor(TQt::black);
    int top,left;
    if (m_image !=NULL) {
        TQPainter p(this);
        double wratio=(double)width()/(double)m_image->width();
        double hratio=(double)height()/(double)m_image->height();
        double ratio= wratio < hratio ? wratio:hratio;

        top =(int) (height() -m_image->height()*ratio)/2+1;
        left =(int) (width() -m_image->width()*ratio)/2 +1;

        p.scale(ratio,ratio);

        p.drawImage((int)(left/ratio),(int)(top/ratio),*m_image);

        p.end();
    }
}

kViewMPEG2::kViewMPEG2() {
    m_widget=NULL;
    m_GLwidget=NULL;
    m_layout=NULL;
    bPlay->setPixmap(SmallIcon("media-playback-start"));
    bStop->setPixmap(SmallIcon("media-playback-stop"));
    connect(&m_player  , TQT_SIGNAL(setPosition(uint32_t)), this, TQT_SLOT(setPosition(uint32_t)));
    connect(&m_player  , TQT_SIGNAL(setMax(uint32_t)), this, TQT_SLOT(setMax(uint32_t)));
    connect(&m_player  , TQT_SIGNAL(setMin(uint32_t)), this, TQT_SLOT(setMin(uint32_t)));
    lockSlider=false;
    stopped=true;

    m_layout=new TQGridLayout(label,1,1);

#ifdef HAVE_OPENGL
    readSettings();
#else
    m_prefUseGL=FALSE;
#endif
    //disable the option use_gl, so if k9copy crash, we restart without gl
    if (m_prefUseGL) {
    	k9Config config;
    	config.setUseGL( false);
    	config.save();
    }
    m_player.getDecoder()->setUseGL(m_prefUseGL);
    if (m_prefUseGL)  {
        connect(m_player.getDecoder()  , TQT_SIGNAL(ppmReady(uchar *,int,int,int)), this, TQT_SLOT(drawppm(uchar *,int,int,int)));
        
        m_GLwidget= k9GLWidget::createWidget(label);
        m_widget=NULL;
        m_layout->addWidget(m_GLwidget,0,0);
        
        //init ok, we can put the gl flag to true
    	k9Config config;
    	config.setUseGL( true);
    	config.save();
        
    } else {
        connect(m_player.getDecoder()  , TQT_SIGNAL(pixmapReady(TQImage *)), this, TQT_SLOT(drawPixmap(TQImage *)));
        m_widget=new k9Widget(label);
        m_layout->addWidget(m_widget,0,0);

        m_GLwidget=NULL;
    }

}


void kViewMPEG2::readSettings() {
    m_player.stop();

    //KSimpleConfig settings("K9Copy");
    k9Config config;
    m_prefUseGL=config.getUseGL();
    //m_prefUseGL=settings.readEntry("/options/useGL",0).toInt();

}


kViewMPEG2::~kViewMPEG2() {
    stopped=true;
    m_player.stop();
}


void kViewMPEG2::lock() {
    mutex.lock();
}

void kViewMPEG2::unlock() {
    mutex.unlock();
}

void kViewMPEG2::setPosition( uint32_t _position) {
    if (!lockSlider)
        slider->setValue(_position);
}

void kViewMPEG2::setMax( uint32_t _position) {
    slider->setMaxValue(_position);
}

void kViewMPEG2::setMin(uint32_t _position) {
    slider->setMinValue(_position);
}


/** No descriptions */
void kViewMPEG2::drawPixmap(TQImage *image) {
    if (tqApp==NULL)
        return;
    if (tqApp->tryLock()) {
        m_widget->setImage( image);
        if (tqApp!=NULL)
            tqApp->unlock();
        }
}

/** No descriptions */
void kViewMPEG2::drawppm(uchar *_buf,int _width,int _height,int _len) {
    if (tqApp==NULL)
        return;
//    if (tqApp->tryLock()) {
        m_GLwidget->setImage(_buf,_width,_height,_len);
 //       if (tqApp !=NULL)
  //          tqApp->unlock();
 //   } else
 //       free(_buf);
}


void kViewMPEG2::bPlayClick() {
    m_player.play();
}


void kViewMPEG2::open (k9DVD *_dvd,k9DVDTitle * title,int chapter) {
    m_player.open(_dvd->getdvd()->getDvd(), _dvd->getDevice(),title,chapter);
}


/** No descriptions */
void kViewMPEG2::setError(const TQString & err) {
    error=true;
    errMsg=err;
}


void kViewMPEG2::resizeEvent(TQResizeEvent *_event) {}

void kViewMPEG2::bStopClick() {
    m_player.stop();
}

void kViewMPEG2::sliderReleased() {
    pause=true;
    int i;
    i=slider->value();
    m_player.updatePos(i);
    lockSlider=false;

}

void kViewMPEG2::closeEvent( TQCloseEvent* ce ) {
    stopped=true;
    ce->accept();
    return;

}
/** No descriptions */
void kViewMPEG2::sliderPressed() {
    lockSlider=true;
}

#include "kviewmpeg2.moc"
