
#include "k9common.h"
#include "k9config.h"
#include <tqlayout.h>
#include <tqslider.h>
#include <tdeselect.h>
#include "k9mplayer.h"
#include <tqcombobox.h>
#include <kiconloader.h>
#include <kpushbutton.h>
#include "k9dvd.h"
#include "k9dvdtitle.h"
#include <kprocess.h>
#include <tqlabel.h>
#include <tqtimer.h>
#include <tqapplication.h>
#include <tqevent.h>
#include <tdelocale.h>
#include <tdemessagebox.h>

K9Mplayer::K9Mplayer(TQObject  *parent,const char *name,const TQStringList args):MPlayer((TQWidget*)parent) {
    m_seeking=FALSE;
    m_initVol=TRUE;
    m_title=0;

    m_process=new TDEProcess(TQT_TQOBJECT(this));
    m_ratio=4.0/3.0;

    slider->setRange(0, 100);
    slider->setSteps(1, 1);
    bPlay->setPixmap(SmallIcon("media-playback-start"));
    bStop->setPixmap(SmallIcon("media-playback-stop"));
    bSwitchAudio->setPixmap(SmallIcon("cycle"));
    connect(m_process,TQT_SIGNAL(receivedStdout( TDEProcess*, char*, int )),this,TQT_SLOT(receivedStdout( TDEProcess*, char*, int )));
    m_timer=new TQTimer(this);
    connect(m_process,TQT_SIGNAL(wroteStdin( TDEProcess* )),this,TQT_SLOT(wroteStdin( TDEProcess* )));
    connect(m_timer,TQT_SIGNAL(timeout()),this,TQT_SLOT(timeout()));
    m_container=new TQWidget(Label);
}


K9Mplayer::~K9Mplayer() {}

void K9Mplayer::resizeEvent ( TQResizeEvent * _resizeEvent) {
    int w,h;
    w=Label->width();
    h=Label->width() /m_ratio;
    if (h>Label->height()) {
        h=Label->height();
        w=Label->height()*m_ratio;
    }

    m_container->resize(w,h);
    m_container->move((Label->width()-w)/2,(Label->height()-h)/2);
}


void K9Mplayer::wroteStdin( TDEProcess *_process) {
    m_canwrite = TRUE;
}

void K9Mplayer::timeout() {
    sendCmd( "get_percent_pos");

}

void K9Mplayer::setDevice(const TQString & _device) {
    m_device=_device;
}


void K9Mplayer::setTitle( const TQString & _numTitle,const TQString &_numChapter) {
    if (m_process->isRunning()) {
        sendCmd("quit");
        m_process->wait( 1000);
    }
    k9Config config;
    TQString vout[]= {"x11","xv","gl2","sdl"};
    TQString aout[]= {"alsa","oss","sdl"};
    TQString vo=vout[config.getMplayerVout()];
    TQString ao=aout[config.getMplayerAout()];


    m_process->clearArguments();
    *m_process << "mplayer";
    *m_process << "-vo" << vo << "-ao" << ao << "-sws" << "0";
    *m_process << "-framedrop";
    *m_process << "-wid" << TQString::number(m_container->winId()) ;
    *m_process << "-slave" ;
    *m_process <<  "-idle";
    *m_process << "-dvd-device" << m_device;
    if (_numChapter !="")
        *m_process << "-chapter" << _numChapter;

    *m_process << TQString("dvd://%1").arg(_numTitle);
    if (!m_process->start( TDEProcess::NotifyOnExit,TDEProcess::All)) {
         KMessageBox::error (tqApp->mainWidget(),i18n("Unable to run %1").arg("mplayer") , i18n("Preview"));
    }
    m_canwrite=TRUE;

    m_position=0;
    slider->setValue(m_position);
}




/*$SPECIALIZATION$*/

void  K9Mplayer::receivedStdout (TDEProcess *proc, char *buffer, int buflen) {
    TQString buf = TQString::fromLatin1(buffer, buflen);
    sscanf(buf.latin1(),"ANS_PERCENT_POSITION=%d",&m_position);
    if (!m_seeking && m_position>0) {
        slider->setValue(m_position);
    }
    int audio=0;
    if (buf.contains("ANS_switch_audio"))
        sscanf(buf.latin1(),"ANS_switch_audio=%d",&audio);
    if (audio >0) {
        for (int i=0;i < m_dvdTitle->getaudioStreamCount();i++) {
            k9DVDAudioStream * str=m_dvdTitle->getaudioStream(i);
            if (str->getStreamId() == audio) {
                cbAudio->setCurrentItem(i);
            }
        }
    }
}

void K9Mplayer::slotLengthChanged() {}

void K9Mplayer::slotNewPosition(int _pos,const TQTime & _time) {
    slider->setValue(_pos);

}

void K9Mplayer::sliderReleased() {
    sendCmd( TQString("seek %1 1").arg((int)slider->value()));
    m_seeking=FALSE;
}

void K9Mplayer::sliderChanged( int _value) {}

void K9Mplayer::sliderPressed() {
    m_seeking=TRUE;

}

void K9Mplayer::bPlayClick() {
    setTitle(TQString::number( m_title),"");
}

void K9Mplayer::bStopClick() {
    sendCmd("quit");
}


void K9Mplayer::bDownClick() {
    sendCmd( TQString("volume -1"));

}

void K9Mplayer::bSwitchAudioClick() {
    sendCmd( TQString("switch_audio"));
    sendCmd( TQString("get_property switch_audio"));
}

void K9Mplayer::bUpClick() {
    sendCmd( TQString("volume +1"));

}


void K9Mplayer::open( k9DVD *_dvd,k9DVDTitle *_title,int chapter) {
    cbSub->clear();
    cbAudio->clear();
    for (int i=0; i< _title->getaudioStreamCount();i++) {
        k9DVDAudioStream *aud=_title->getaudioStream(i);
        cbAudio->insertItem(NULL,TQString("%1-%2").arg(aud->getID()).arg(aud->getlanguage()),-1);
    }

    for (int i=0; i< _title->getsubPictureCount();i++) {
        k9DVDSubtitle *sub=_title->getsubtitle(i);
        cbSub->insertItem(NULL,TQString("%1-%2").arg(sub->getID().first()).arg(sub->getlanguage()),-1);
    }

    if(_title->getaspectRatio()=="16:9")
        m_ratio=16.0/9.0;
    else
        m_ratio=4.0/3.0;
    resizeEvent( NULL);

    setDevice( _dvd->getDevice());
    m_dvdTitle=_title;
    m_title=_title->getnumTitle();
    setTitle( TQString::number(m_title),TQString::number(chapter));
    if (_title->getaudioStreamCount() >0)
        cbAudioActivated( 0);
    if (_title->getsubPictureCount() >0)
        cbSubActivated( 0);
    if (!m_timer->isActive())
        m_timer->start(200,FALSE);

}

void K9Mplayer::titleChanged() {}

void K9Mplayer::cbAudioActivated( int _value) {
    if (m_dvdTitle) {
       int value=m_dvdTitle->getaudioStream( _value)->getStreamId();
       sendCmd(TQString( "switch_audio %1").arg(value));
    }
}

void K9Mplayer::cbSubActivated( int _value) {
    sendCmd(TQString("sub_select %1").arg(_value));

}


void K9Mplayer::sendCmd( TQString _cmd) {
    while (!m_canwrite) {
        tqApp->processEvents();
        if ( !m_process->isRunning())
            return;
    }

    _cmd +="\n";
    m_canwrite=FALSE;
    m_process->writeStdin( _cmd.latin1() ,_cmd.length());

}

#include "k9mplayer.moc"

