/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 33 "parse.y"

#include "sqliteInt.h"
#include "parse.h"

/*
** An instance of this structure holds information about the
** LIMIT clause of a SELECT statement.
*/
struct LimitVal {
  Expr *pLimit;    /* The LIMIT expression.  NULL if there is no limit */
  Expr *pOffset;   /* The OFFSET expression.  NULL if there is none */
};

/*
** An instance of this structure is used to store the LIKE,
** GLOB, NOT LIKE, and NOT GLOB operators.
*/
struct LikeOp {
  Token operator;  /* "like" or "glob" or "regexp" */
  int not;         /* True if the NOT keyword is present */
};

/*
** An instance of the following structure describes the event of a
** TRIGGER.  "a" is the event type, one of TK_UPDATE, TK_INSERT,
** TK_DELETE, or TK_INSTEAD.  If the event is of the form
**
**      UPDATE ON (a,b,c)
**
** Then the "b" IdList records the list "a,b,c".
*/
struct TrigEvent { int a; IdList * b; };

/*
** An instance of this structure holds the ATTACH key and the key type.
*/
struct AttachKey { int type;  Token key; };

#line 48 "parse.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite3ParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite3ParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.
**    sqlite3ParserARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite3ParserARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite3ParserARG_STORE     Code to store %extra_argument into yypParser
**    sqlite3ParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 241
#define YYACTIONTYPE unsigned short int
#define sqlite3ParserTOKENTYPE Token
typedef union {
  sqlite3ParserTOKENTYPE yy0;
  Expr* yy2;
  struct {int value; int mask;} yy47;
  SrcList* yy67;
  ExprList* yy82;
  struct AttachKey yy132;
  struct TrigEvent yy210;
  IdList* yy240;
  struct LimitVal yy244;
  Token yy258;
  TriggerStep* yy347;
  int yy412;
  struct LikeOp yy438;
  Select* yy459;
  int yy481;
} YYMINORTYPE;
#define YYSTACKDEPTH 100
#define sqlite3ParserARG_SDECL Parse *pParse;
#define sqlite3ParserARG_PDECL ,Parse *pParse
#define sqlite3ParserARG_FETCH Parse *pParse = yypParser->pParse
#define sqlite3ParserARG_STORE yypParser->pParse = pParse
#define YYNSTATE 565
#define YYNRULE 305
#define YYERRORSYMBOL 141
#define YYERRSYMDT yy481
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   259,   65,  257,  112,  114,  110,  116,   66,  122,  124,
 /*    10 */   126,  128,  130,  132,  134,  136,  138,  140,  568,  142,
 /*    20 */   150,  122,  124,  126,  128,  130,  132,  134,  136,  138,
 /*    30 */   140,  130,  132,  134,  136,  138,  140,  108,   94,  143,
 /*    40 */   153,  158,  163,  152,  157,  118,  120,  112,  114,  110,
 /*    50 */   116,   72,  122,  124,  126,  128,  130,  132,  134,  136,
 /*    60 */   138,  140,    7,  106,  219,  258,  122,  124,  126,  128,
 /*    70 */   130,  132,  134,  136,  138,  140,  367,   13,    9,  369,
 /*    80 */   376,  381,  142,  871,    1,  564,   92,   27,    4,  399,
 /*    90 */   363,  384,  844,  341,  291,   28,   10,   95,  398,   33,
 /*   100 */   108,   94,  143,  153,  158,  163,  152,  157,  118,  120,
 /*   110 */   112,  114,  110,  116,   96,  122,  124,  126,  128,  130,
 /*   120 */   132,  134,  136,  138,  140,  456,  565,  142,  395,  305,
 /*   130 */   101,  102,  103,  288,   75,  394,    3,  563,  231,  275,
 /*   140 */    14,   15,  575,  597,  437,  108,   94,  143,  153,  158,
 /*   150 */   163,  152,  157,  118,  120,  112,  114,  110,  116,   13,
 /*   160 */   122,  124,  126,  128,  130,  132,  134,  136,  138,  140,
 /*   170 */   573,   77,  142,  223,  232,   13,  490,  462,  452,  167,
 /*   180 */   306,  169,  170,  276,  254,    3,  563,   81,  277,  183,
 /*   190 */   108,   94,  143,  153,  158,  163,  152,  157,  118,  120,
 /*   200 */   112,  114,  110,  116,   52,  122,  124,  126,  128,  130,
 /*   210 */   132,  134,  136,  138,  140,   48,   54,  799,  448,   51,
 /*   220 */   797,   77,   14,   15,   49,  363,  134,  136,  138,  140,
 /*   230 */    16,   17,   18,   32,   33,   50,  308,  197,   14,   15,
 /*   240 */   367,  261,   13,  369,  376,  381,  142,   37,  337,   40,
 /*   250 */    59,   67,   69,  301,  332,  384,  364,  397,  259,  807,
 /*   260 */   257,  334,   51,  193,  108,   94,  143,  153,  158,  163,
 /*   270 */   152,  157,  118,  120,  112,  114,  110,  116,  262,  122,
 /*   280 */   124,  126,  128,  130,  132,  134,  136,  138,  140,   13,
 /*   290 */   171,  142,   40,   59,   67,   69,  301,  332,  642,  148,
 /*   300 */   365,  159,  164,  261,  334,   14,   15,   44,   45,  108,
 /*   310 */    94,  143,  153,  158,  163,  152,  157,  118,  120,  112,
 /*   320 */   114,  110,  116,  258,  122,  124,  126,  128,  130,  132,
 /*   330 */   134,  136,  138,  140,  148,  218,  159,  164,  184,   12,
 /*   340 */   284,  417,   48,  360,  358,  293,  290,  347,  352,  353,
 /*   350 */   289,   49,   14,   15,  688,    2,   96,  148,    4,  159,
 /*   360 */   164,  257,   50,  530,   46,  142,  367,  155,  165,  369,
 /*   370 */   376,  381,   13,  576,   47,  167,   75,  169,  170,  554,
 /*   380 */   172,  384,  207,  108,   94,  143,  153,  158,  163,  152,
 /*   390 */   157,  118,  120,  112,  114,  110,  116,  154,  122,  124,
 /*   400 */   126,  128,  130,  132,  134,  136,  138,  140,  299,  354,
 /*   410 */   350,  352,  353,   96,   96,   13,   34,   20,  294,  362,
 /*   420 */   345,  144,  581,  167,  258,  169,  170,  821,  142,  558,
 /*   430 */   213,  244,  254,   75,   75,   14,   15,  172,  186,  167,
 /*   440 */   533,  169,  170,  146,  147,  417,  108,   94,  143,  153,
 /*   450 */   158,  163,  152,  157,  118,  120,  112,  114,  110,  116,
 /*   460 */    96,  122,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   470 */   140,  145,  354,  142,   22,  239,  383,  589,   14,   15,
 /*   480 */    75,   36,  336,  419,  172,  187,  842,  213,  528,  582,
 /*   490 */   331,  108,   94,  143,  153,  158,  163,  152,  157,  118,
 /*   500 */   120,  112,  114,  110,  116,  249,  122,  124,  126,  128,
 /*   510 */   130,  132,  134,  136,  138,  140,  306,  661,  142,  327,
 /*   520 */   574,  849,  148,   11,  159,  164,  309,  316,  318,  168,
 /*   530 */    42,  327,  666,  327,  212,  393,  108,   94,  143,  153,
 /*   540 */   158,  163,  152,  157,  118,  120,  112,  114,  110,  116,
 /*   550 */    96,  122,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   560 */   140,  847,   83,  142,  321,  641,  372,   31,  663,  282,
 /*   570 */    75,  242,  308,  689,  231,  246,  167,  334,  169,  170,
 /*   580 */   269,  108,   94,  143,  153,  158,  163,  152,  157,  118,
 /*   590 */   120,  112,  114,  110,  116,  324,  122,  124,  126,  128,
 /*   600 */   130,  132,  134,  136,  138,  140,  246,  328,  142,  328,
 /*   610 */   225,  434,   24,   39,  433,  210,  167,  211,  169,  170,
 /*   620 */   167,  331,  169,  170,  583,  435,  108,  161,  143,  153,
 /*   630 */   158,  163,  152,  157,  118,  120,  112,  114,  110,  116,
 /*   640 */   248,  122,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   650 */   140,   57,   58,  142,  624,  837,  323,  727,  271,  261,
 /*   660 */   167,  243,  169,  170,  313,  312,  247,  167,  798,  169,
 /*   670 */   170,  248,   94,  143,  153,  158,  163,  152,  157,  118,
 /*   680 */   120,  112,  114,  110,  116,   96,  122,  124,  126,  128,
 /*   690 */   130,  132,  134,  136,  138,  140,  279,  247,  142,  360,
 /*   700 */   358,    6,    5,  363,  346,   75,  274,   25,  257,  489,
 /*   710 */    13,  561,   33,  503,   13,  268,  267,  269,  143,  153,
 /*   720 */   158,  163,  152,  157,  118,  120,  112,  114,  110,  116,
 /*   730 */    64,  122,  124,  126,  128,  130,  132,  134,  136,  138,
 /*   740 */   140,   26,   76,   96,  400,   77,   71,  584,   96,  451,
 /*   750 */   166,  485,   29,   76,  402,   78,  167,   71,  169,  170,
 /*   760 */   295,  451,  211,   75,   30,  257,  314,  172,   75,  195,
 /*   770 */   514,  258,  292,   14,   15,  690,   77,   14,   15,  106,
 /*   780 */   195,   77,   77,  173,  191,  315,  203,   77,  344,  215,
 /*   790 */   106,  690,  327,   77,  173,  495,  338,  588,  529,  403,
 /*   800 */   179,  177,  296,  453,  251,  209,  475,  327,  175,   73,
 /*   810 */    74,  179,  177,   95,  531,  532,   35,  213,  475,  175,
 /*   820 */    73,   74,  457,   38,   95,  378,  438,  459,  258,  501,
 /*   830 */   449,  497,  841,  411,  461,  406,  653,   76,  311,  459,
 /*   840 */   387,   71,  322,   81,  323,   42,  101,  102,  103,  104,
 /*   850 */   105,  181,  185,   96,  356,  357,   96,  101,  102,  103,
 /*   860 */   104,  105,  181,  185,  195,   76,  655,  544,  328,   71,
 /*   870 */    96,  271,  431,   75,  106,  354,   75,  489,  173,  327,
 /*   880 */   298,  215,  410,  328,  428,  430,  429,  426,  427,   96,
 /*   890 */    75,  721,  195,   76,   91,  179,  177,   71,  348,  379,
 /*   900 */   349,  323,  106,  175,   73,   74,  173,  467,   95,   75,
 /*   910 */   271,  499,  445,   93,   77,  388,  446,  323,  323,  521,
 /*   920 */   195,  454,   45,  179,  177,  285,  836,   42,   41,  432,
 /*   930 */   106,  175,   73,   74,  173,  480,   95,  269,  488,   43,
 /*   940 */   486,  101,  102,  103,  104,  105,  181,  185,  800,  721,
 /*   950 */   417,  179,  177,  229,  422,  328,   96,   96,   96,  175,
 /*   960 */    73,   74,  814,   96,   95,  522,   53,  486,  479,  101,
 /*   970 */   102,  103,  104,  105,  181,  185,   75,   75,   75,   13,
 /*   980 */   107,  109,  423,   75,   55,    8,  106,  111,  496,  857,
 /*   990 */    19,   21,   23,  401,   96,  472,   56,  101,  102,  103,
 /*  1000 */   104,  105,  181,  185,  536,  240,   81,  339,  342,  863,
 /*  1010 */   546,   61,   96,   96,   75,   96,  341,  482,  113,  483,
 /*  1020 */    95,   96,  525,  417,  456,  542,   13,   96,   96,  523,
 /*  1030 */   417,  549,   75,   75,  552,   75,  115,  117,  472,  119,
 /*  1040 */    96,   75,   14,   15,   81,  121,   96,   75,   75,   77,
 /*  1050 */   417,  123,  125,  101,  102,  103,   60,  519,  466,   96,
 /*  1060 */    75,  498,  417,  240,  127,  417,   75,   64,  500,   62,
 /*  1070 */   129,   96,   63,  690,   96,  504,  508,  452,   68,   75,
 /*  1080 */   417,  494,   96,  131,   96,   96,   81,   96,  502,   14,
 /*  1090 */    15,   75,   96,   96,   75,  133,  555,   70,  135,   96,
 /*  1100 */   506,  512,   75,  510,   75,   75,  137,   75,  139,  141,
 /*  1110 */    96,  149,   75,   75,   81,   96,  151,  160,  516,   75,
 /*  1120 */    96,   96,   96,  162,  598,   80,  599,   96,   96,   82,
 /*  1130 */    75,  240,  221,   84,  174,   75,   96,   96,   96,  176,
 /*  1140 */    75,   75,   75,   96,  178,  180,  192,   75,   75,  518,
 /*  1150 */    96,  194,  204,   96,   79,  286,   75,   75,   75,  237,
 /*  1160 */   206,  208,  220,   75,   96,   96,   96,  236,   85,  235,
 /*  1170 */    75,   96,   87,   75,  241,   75,  867,  273,  215,  283,
 /*  1180 */    86,   77,   90,   97,   75,   75,   75,   88,  382,  470,
 /*  1190 */   474,   75,   89,   98,   99,  487,  100,  140,  156,  214,
 /*  1200 */   667,  668,  669,  182,  205,  188,  190,  189,  196,  199,
 /*  1210 */   198,  201,  215,  200,  202,  216,  217,  224,  222,  228,
 /*  1220 */   227,  229,  230,  226,  234,  238,  211,  245,  233,  253,
 /*  1230 */   250,  252,  255,  272,  260,  263,  265,  256,  264,  266,
 /*  1240 */   270,  278,  287,  280,  297,  281,  300,  320,  303,  302,
 /*  1250 */   305,  307,  304,  325,  333,  329,  310,  317,  326,  351,
 /*  1260 */   355,  370,  359,  330,  319,  340,  343,  368,  371,  361,
 /*  1270 */   374,  377,  385,  335,  375,  373,  396,  386,  380,  389,
 /*  1280 */   390,   54,  366,  391,  404,  392,  407,  405,  409,  408,
 /*  1290 */   412,  413,  418,  416,  829,  414,  424,  425,  415,  834,
 /*  1300 */   420,  439,  835,  421,  436,  440,  441,  442,  443,  444,
 /*  1310 */   447,  805,  450,  806,  455,  458,  828,  460,  728,  464,
 /*  1320 */   729,  843,  453,  465,  468,  471,  463,  845,  476,  469,
 /*  1330 */   481,  478,  473,  477,  484,  846,  493,  491,  848,  492,
 /*  1340 */   660,  662,  813,  855,  505,  507,  720,  509,  511,  723,
 /*  1350 */   513,  726,  515,  815,  524,  526,  527,  520,  517,  816,
 /*  1360 */   817,  818,  819,  534,  535,  820,  856,  539,  858,  540,
 /*  1370 */   545,  538,  543,  859,  862,  548,  551,  864,  553,  550,
 /*  1380 */   537,  557,  541,  547,  865,  556,  866,  560,  559,  547,
 /*  1390 */   562,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */    25,   30,   27,   72,   73,   74,   75,   36,   77,   78,
 /*    10 */    79,   80,   81,   82,   83,   84,   85,   86,   10,   44,
 /*    20 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*    30 */    86,   81,   82,   83,   84,   85,   86,   62,   63,   64,
 /*    40 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*    50 */    75,   23,   77,   78,   79,   80,   81,   82,   83,   84,
 /*    60 */    85,   86,   10,   60,   26,   90,   77,   78,   79,   80,
 /*    70 */    81,   82,   83,   84,   85,   86,   92,   27,  148,   95,
 /*    80 */    96,   97,   44,  142,  143,  144,   48,   23,  147,   25,
 /*    90 */   150,  107,   18,   90,   24,  155,  149,   94,  158,  159,
 /*   100 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   110 */    72,   73,   74,   75,  150,   77,   78,   79,   80,   81,
 /*   120 */    82,   83,   84,   85,   86,   51,    0,   44,  177,  178,
 /*   130 */   127,  128,  129,   83,  170,  184,   10,   11,  174,  157,
 /*   140 */    90,   91,   10,  115,   22,   62,   63,   64,   65,   66,
 /*   150 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   27,
 /*   160 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*   170 */    10,  189,   44,  209,  210,   27,  102,  103,  104,  109,
 /*   180 */    45,  111,  112,  201,  202,   10,   11,  113,  206,  157,
 /*   190 */    62,   63,   64,   65,   66,   67,   68,   69,   70,   71,
 /*   200 */    72,   73,   74,   75,   94,   77,   78,   79,   80,   81,
 /*   210 */    82,   83,   84,   85,   86,   19,  106,  134,   96,   64,
 /*   220 */    18,  189,   90,   91,   28,  150,   83,   84,   85,   86,
 /*   230 */    14,   15,   16,  158,  159,   39,  101,   41,   90,   91,
 /*   240 */    92,  163,   27,   95,   96,   97,   44,   92,   93,   94,
 /*   250 */    95,   96,   97,   98,   99,  107,  181,  182,   25,  137,
 /*   260 */    27,  106,   64,  135,   62,   63,   64,   65,   66,   67,
 /*   270 */    68,   69,   70,   71,   72,   73,   74,   75,  200,   77,
 /*   280 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   27,
 /*   290 */    24,   44,   94,   95,   96,   97,   98,   99,   24,  217,
 /*   300 */    26,  219,  220,  163,  106,   90,   91,  186,  187,   62,
 /*   310 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   320 */    73,   74,   75,   90,   77,   78,   79,   80,   81,   82,
 /*   330 */    83,   84,   85,   86,  217,  218,  219,  220,   24,  150,
 /*   340 */   200,  150,   19,   81,   82,   24,  110,  165,  166,  167,
 /*   350 */   114,   28,   90,   91,   24,  144,  150,  217,  147,  219,
 /*   360 */   220,   27,   39,  101,   41,   44,   92,   64,   23,   95,
 /*   370 */    96,   97,   27,   10,   51,  109,  170,  111,  112,  188,
 /*   380 */   174,  107,  135,   62,   63,   64,   65,   66,   67,   68,
 /*   390 */    69,   70,   71,   72,   73,   74,   75,   94,   77,   78,
 /*   400 */    79,   80,   81,   82,   83,   84,   85,   86,   24,  227,
 /*   410 */   165,  166,  167,  150,  150,   27,  160,  149,  212,  163,
 /*   420 */   164,   44,   10,  109,   90,  111,  112,   10,   44,  238,
 /*   430 */   224,  201,  202,  170,  170,   90,   91,  174,  174,  109,
 /*   440 */    23,  111,  112,   66,   67,  150,   62,   63,   64,   65,
 /*   450 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   460 */   150,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   470 */    86,   94,  227,   44,  149,  212,  171,   10,   90,   91,
 /*   480 */   170,  168,  169,  188,  174,  221,   12,  224,   71,   10,
 /*   490 */   177,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   500 */    71,   72,   73,   74,   75,  117,   77,   78,   79,   80,
 /*   510 */    81,   82,   83,   84,   85,   86,   45,   10,   44,  150,
 /*   520 */    10,   10,  217,   13,  219,  220,  102,  103,  104,  110,
 /*   530 */   101,  150,  113,  150,  224,   64,   62,   63,   64,   65,
 /*   540 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   550 */   150,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   560 */    86,   10,  192,   44,  183,   24,  183,   26,   10,  199,
 /*   570 */   170,   26,  101,   24,  174,   26,  109,  106,  111,  112,
 /*   580 */    26,   62,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   590 */    71,   72,   73,   74,   75,  226,   77,   78,   79,   80,
 /*   600 */    81,   82,   83,   84,   85,   86,   26,  226,   44,  226,
 /*   610 */   210,   29,  149,  169,   32,   24,  109,   26,  111,  112,
 /*   620 */   109,  177,  111,  112,   10,   43,   62,   63,   64,   65,
 /*   630 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   640 */    91,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   650 */    86,   14,   15,   44,   24,  101,   26,   10,  150,  163,
 /*   660 */   109,  116,  111,  112,   93,   94,  117,  109,   18,  111,
 /*   670 */   112,   91,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   680 */    71,   72,   73,   74,   75,  150,   77,   78,   79,   80,
 /*   690 */    81,   82,   83,   84,   85,   86,  200,  117,   44,   81,
 /*   700 */    82,  145,  146,  150,   23,  170,   23,  151,   27,  174,
 /*   710 */    27,  158,  159,  157,   27,   24,  208,   26,   64,   65,
 /*   720 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   730 */   100,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   740 */    86,  152,   23,  150,  157,  189,   27,   10,  150,  157,
 /*   750 */   157,  216,  156,   23,  153,  157,  109,   27,  111,  112,
 /*   760 */    24,  157,   26,  170,   24,   27,   33,  174,  170,   50,
 /*   770 */   214,   90,  174,   90,   91,  101,  189,   90,   91,   60,
 /*   780 */    50,  189,  189,   64,  134,   52,  136,  189,  162,  115,
 /*   790 */    60,   25,  150,  189,   64,   21,  170,   10,  150,   21,
 /*   800 */    81,   82,   83,   62,  117,  212,  214,  150,   89,   90,
 /*   810 */    91,   81,   82,   94,  166,  167,  161,  224,  214,   89,
 /*   820 */    90,   91,  230,  150,   94,  183,  225,  235,   90,   55,
 /*   830 */   229,   57,   12,   55,  230,   57,   10,   23,  105,  235,
 /*   840 */   183,   27,   24,  113,   26,  101,  127,  128,  129,  130,
 /*   850 */   131,  132,  133,  150,  127,  128,  150,  127,  128,  129,
 /*   860 */   130,  131,  132,  133,   50,   23,  125,  129,  226,   27,
 /*   870 */   150,  150,   47,  170,   60,  227,  170,  174,   64,  150,
 /*   880 */   174,  115,  157,  226,  102,  103,  104,   53,   54,  150,
 /*   890 */   170,   10,   50,   23,  174,   81,   82,   27,   24,   24,
 /*   900 */    26,   26,   60,   89,   90,   91,   64,   26,   94,  170,
 /*   910 */   150,  137,  183,  174,  189,   24,   24,   26,   26,  216,
 /*   920 */    50,  186,  187,   81,   82,   83,  101,  101,  171,  208,
 /*   930 */    60,   89,   90,   91,   64,   24,   94,   26,   24,   34,
 /*   940 */    26,  127,  128,  129,  130,  131,  132,  133,  134,   10,
 /*   950 */   150,   81,   82,   27,  134,  226,  150,  150,  150,   89,
 /*   960 */    90,   91,   10,  150,   94,   24,  171,   26,  208,  127,
 /*   970 */   128,  129,  130,  131,  132,  133,  170,  170,  170,   27,
 /*   980 */   174,  174,  174,  170,  180,   12,   60,  174,  188,   10,
 /*   990 */    17,   18,   19,   20,  150,  150,   42,  127,  128,  129,
 /*  1000 */   130,  131,  132,  133,   31,  124,  113,   81,   82,   10,
 /*  1010 */    37,  172,  150,  150,  170,  150,   90,  157,  174,  126,
 /*  1020 */    94,  150,   49,  150,   51,   46,   27,  150,  150,   56,
 /*  1030 */   150,   58,  170,  170,   61,  170,  174,  174,  150,  174,
 /*  1040 */   150,  170,   90,   91,  113,  174,  150,  170,  170,  189,
 /*  1050 */   150,  174,  174,  127,  128,  129,   46,  126,  213,  150,
 /*  1060 */   170,  188,  150,  124,  174,  150,  170,  100,  188,  171,
 /*  1070 */   174,  150,  173,   10,  150,  102,  103,  104,  171,  170,
 /*  1080 */   150,  108,  150,  174,  150,  150,  113,  150,  188,   90,
 /*  1090 */    91,  170,  150,  150,  170,  174,   59,   23,  174,  150,
 /*  1100 */   188,  213,  170,  188,  170,  170,  174,  170,  174,  174,
 /*  1110 */   150,  174,  170,  170,  113,  150,  174,  174,  188,  170,
 /*  1120 */   150,  150,  150,  174,  115,  189,  115,  150,  150,  191,
 /*  1130 */   170,  124,  119,  193,  174,  170,  150,  150,  150,  174,
 /*  1140 */   170,  170,  170,  150,  174,  174,  174,  170,  170,  157,
 /*  1150 */   150,  174,  174,  150,  190,  150,  170,  170,  170,  121,
 /*  1160 */   174,  174,  174,  170,  150,  150,  150,  174,  194,  122,
 /*  1170 */   170,  150,  196,  170,  174,  170,  139,  174,  115,  174,
 /*  1180 */   195,  189,  123,  115,  170,  170,  170,  197,  174,  174,
 /*  1190 */   174,  170,  198,  150,  115,  174,  150,   86,   94,  150,
 /*  1200 */   113,  113,  113,   23,  134,  222,   18,  223,   23,  187,
 /*  1210 */    24,  150,  115,   26,   24,  150,  154,   26,  120,   99,
 /*  1220 */   172,   27,  162,  211,  172,  120,   26,  203,  211,  117,
 /*  1230 */   150,  150,  150,  101,  150,  204,  118,  154,  205,   23,
 /*  1240 */   150,   24,  115,  204,   24,  205,  171,   23,  175,  150,
 /*  1250 */   178,  150,  176,  211,  162,  211,  179,  179,  172,   24,
 /*  1260 */   228,   46,  228,  172,  179,  170,  170,  150,   23,  163,
 /*  1270 */    24,   23,   46,  180,  171,  173,  182,   23,  171,   98,
 /*  1280 */   150,  106,  182,  175,  150,  176,  150,  154,   25,  154,
 /*  1290 */   150,  154,  154,  101,   12,  231,   40,   38,  232,  101,
 /*  1300 */   233,  137,  101,  234,   47,  150,  154,  101,  150,   23,
 /*  1310 */   171,   10,   12,  137,  185,   18,   10,   10,  125,  150,
 /*  1320 */   125,   18,   62,  105,  150,  194,  185,   10,  125,   71,
 /*  1330 */   215,   23,   71,  150,   23,   10,  194,  116,   10,  150,
 /*  1340 */    10,   10,   10,   10,  116,  194,   10,  185,  105,   10,
 /*  1350 */   194,   10,  125,   10,  150,  150,  154,   23,  215,   10,
 /*  1360 */    10,   10,   10,  150,   24,   10,   10,   25,   10,  150,
 /*  1370 */    35,  163,  163,   10,   10,  150,  154,   10,   21,  150,
 /*  1380 */   236,  150,  237,  236,   10,  138,   10,  239,  139,  240,
 /*  1390 */   140,
};
#define YY_SHIFT_USE_DFLT (-70)
static const short yy_shift_ofst[] = {
 /*     0 */   175,  126,  -70,  -70,  973,    8,   52,  -70,  216,  510,
 /*    10 */   160,  132,  363,  -70,  -70,  -70,  -70,  -70,  -70,  510,
 /*    20 */   412,  510,  479,  510,  614,   64,  737,  215,  541,  740,
 /*    30 */   787,  148,  -70,  334,  -70,  155,  -70,  215,  198,  -70,
 /*    40 */   744,  -70,  905,  323,  -70,  -70,  -70,  -70,  -70,  -70,
 /*    50 */   -70,  110,  744,  -70,  954,  -70,  637,  -70,  -70, 1010,
 /*    60 */   -29,  744,  967,  -70,  -70,  -70,  -70,  744,  -70, 1074,
 /*    70 */   870,   28,  719, 1009, 1011,  -70,  730,  -70,   70, 1001,
 /*    80 */   -70,  236,  -70,  545, 1007, 1038, 1047, 1013, 1059,  -70,
 /*    90 */   870,   38,  870,  519,  870,  -70, 1068,  215, 1079,  215,
 /*   100 */   -70,  -70,  -70,  -70,  -70,  -70,  -70,  654,  870,  609,
 /*   110 */   870,  -11,  870,  -11,  870,  -11,  870,  -11,  870,  -69,
 /*   120 */   870,  -69,  870,  -50,  870,  -50,  870,  -50,  870,  -50,
 /*   130 */   870,  143,  870,  143,  870, 1111,  870, 1111,  870, 1111,
 /*   140 */   870,  -70,  -70,  377,  -70,  -70,  -70,  -70,  870,  -56,
 /*   150 */   870,  -11,  -70,  303,  -70, 1104,  -70,  -70,  -70,  870,
 /*   160 */   564,  870,  -69,  -70,  345,  730,  266,  419, 1087, 1088,
 /*   170 */  1089,  -70,  519,  870,  654,  870,  -70,  870,  -70,  870,
 /*   180 */   -70, 1180, 1001,  314,  -70,  814,   83, 1070,  650, 1188,
 /*   190 */   -70,  870,  128,  870,  519, 1185,  196, 1186,  -70, 1187,
 /*   200 */   215, 1190,  -70,  870,  202,  870,  247,  870,  519,  591,
 /*   210 */   -70,  870,  -70,  -70, 1097,  215,  -70,  -70,  -70,  870,
 /*   220 */   519, 1098,  870, 1191,  870, 1120,  -29,  -70, 1194,  -70,
 /*   230 */   -70,  519, 1120,  -29,  -70,  870,  519, 1105,  870, 1200,
 /*   240 */   870,  519,  -70,  -70,  580,  -70,  -70,  -70,  388,  -70,
 /*   250 */   687,  -70, 1112,  -70,  683, 1097,  233,  -70,  -70,  215,
 /*   260 */   -70,  -70, 1132, 1118,  -70, 1216,  215,  691,  -70,  215,
 /*   270 */   -70,  -70,  870,  519, 1001,  330,  549, 1217,  233, 1132,
 /*   280 */  1118,  -70,  842,  -25,  -70,  -70, 1127,   50,  -70,  -70,
 /*   290 */   -70,  -70,  321,  -70,  736,  -70, 1220,  -70,  384,  744,
 /*   300 */   -70,  215, 1224,  -70,  135,  -70,  215,  -70,  424,  733,
 /*   310 */   -70,  571,  -70,  -70,  -70,  -70,  733,  -70,  733,  -70,
 /*   320 */   215,  818,  -70,  215, 1120,  -29,  -70,  -70, 1120,  -29,
 /*   330 */   -70,  -70, 1194,  -70,  954,  -70,  -70,  926,  -70,    3,
 /*   340 */   -70,  -70,    3,  -70,  -70,  681,  618,  874,  -70,  618,
 /*   350 */  1235,  -70,  -70,  -70,  727,  -70,  -70,  -70,  727,  -70,
 /*   360 */   -70,  -70,  -70,  -70,  274,  -16,  -70,  215,  -70, 1215,
 /*   370 */  1245,  215,  630, 1246,  744,  -70, 1248,  215,  875,  744,
 /*   380 */   -70,  870,  429,  -70, 1226, 1254,  215,  891, 1181,  215,
 /*   390 */  1224,  -70,  471, 1175,  -70,  -70,  -70,  -70,  -70, 1001,
 /*   400 */   467,  122,  778,  215, 1097,  -70,  215,  766, 1263, 1001,
 /*   410 */   507,  215, 1097,  582,  782, 1192,  215, 1097,  -70, 1256,
 /*   420 */   820, 1282,  870,  474, 1259,  834,  -70,  -70, 1198, 1201,
 /*   430 */   825,  215,  554,  -70,  -70, 1257,  -70,  -70, 1164,  215,
 /*   440 */   674, 1206,  215, 1286,  215,  892,  826, 1301, 1176, 1300,
 /*   450 */    74,  511,  741,  323,  -70, 1193, 1195, 1297, 1306, 1307,
 /*   460 */    74, 1303, 1260,  215, 1218,  215,  881,  215, 1258,  870,
 /*   470 */   519, 1317, 1261,  870,  519, 1203,  215, 1308,  215,  911,
 /*   480 */   -70,  893,  551, 1311,  870,  914,  870,  519, 1325,  519,
 /*   490 */  1221,  215,  939, 1328,  774,  215, 1330,  215, 1331,  215,
 /*   500 */  1332,  215, 1333,  558, 1228,  215,  939, 1336, 1260,  215,
 /*   510 */  1243,  215,  881, 1339, 1227,  215, 1308,  931,  647, 1334,
 /*   520 */   870,  941, 1341,  952, 1343,  215, 1097,  417,  262, 1349,
 /*   530 */  1350, 1351, 1352,  215, 1340, 1355, 1335,  334, 1342,  215,
 /*   540 */   979, 1356,  738, 1358, 1363,  -70, 1335,  215, 1364,  999,
 /*   550 */  1063, 1367, 1357,  215, 1037, 1247,  215, 1374, 1249, 1250,
 /*   560 */   215, 1376,  -70,  -70,  -70,
};
#define YY_REDUCE_USE_DFLT (-71)
static const short yy_reduce_ofst[] = {
 /*     0 */   -59,  211,  -71,  -71,  556,  -71,  -71,  -71,  -70,  -53,
 /*    10 */   -71,  189,  -71,  -71,  -71,  -71,  -71,  -71,  -71,  268,
 /*    20 */   -71,  325,  -71,  463,  -71,  589,  -71,  -60,  596,  -71,
 /*    30 */   -71,   75,  -71,  256,  655,  313,  -71,  673,  444,  -71,
 /*    40 */   757,  -71,  -71,  121,  -71,  -71,  -71,  -71,  -71,  -71,
 /*    50 */   -71,  -71,  795,  -71,  804,  -71,  -71,  -71,  -71,  -71,
 /*    60 */   839,  898,  899,  -71,  -71,  -71,  -71,  907,  -71,  -71,
 /*    70 */   706,  -71,  206,  -71,  -71,  -71,  598,  -71,  964,  936,
 /*    80 */   -71,  938,  370,  940,  974,  985,  976,  990,  994,  -71,
 /*    90 */   720,   82,  739,   82,  806,  -71,  -71, 1043,  -71, 1046,
 /*   100 */   -71,  -71,  -71,  -71,  -71,  -71,  -71,   82,  807,   82,
 /*   110 */   813,   82,  844,   82,  862,   82,  863,   82,  865,   82,
 /*   120 */   871,   82,  877,   82,  878,   82,  890,   82,  896,   82,
 /*   130 */   909,   82,  921,   82,  924,   82,  932,   82,  934,   82,
 /*   140 */   935,   82,  -71,  -71,  -71,  -71,  -71,  -71,  937,  117,
 /*   150 */   942,   82,  -71,  -71,  -71,  -71,  -71,  -71,  -71,  943,
 /*   160 */    82,  949,   82,  -71, 1049,  593,  964,  -71,  -71,  -71,
 /*   170 */   -71,  -71,   82,  960,   82,  965,   82,  970,   82,  971,
 /*   180 */    82,  -71,   32,  964,  -71,  264,   82,  983,  984,  -71,
 /*   190 */   -71,  972,   82,  977,   82,  -71, 1022,  -71,  -71,  -71,
 /*   200 */  1061,  -71,  -71,  978,   82,  986,   82,  987,   82,  -71,
 /*   210 */   -71,  310,  -71,  -71, 1062, 1065,  -71,  -71,  -71,  988,
 /*   220 */    82,  -71,  -36,  -71,  400, 1012, 1048,  -71, 1060,  -71,
 /*   230 */   -71,   82, 1017, 1052,  -71,  993,   82,  -71,  263,  -71,
 /*   240 */  1000,   82,  -71,  230, 1024,  -71,  -71,  -71, 1080,  -71,
 /*   250 */  1081,  -71,  -71,  -71, 1082, 1083,   78,  -71,  -71, 1084,
 /*   260 */   -71,  -71, 1031, 1033,  -71,  -71,  508,  -71,  -71, 1090,
 /*   270 */   -71,  -71, 1003,   82,  -18,  964, 1024,  -71,  496, 1039,
 /*   280 */  1040,  -71, 1005,  140,  -71,  -71,  -71, 1043,  -71,  -71,
 /*   290 */   -71,  -71,   82,  -71,  -71,  -71,  -71,  -71,   82, 1075,
 /*   300 */   -71, 1099, 1073, 1076, 1072,  -71, 1101,  -71,  -71, 1077,
 /*   310 */   -71,  -71,  -71,  -71,  -71,  -71, 1078,  -71, 1085,  -71,
 /*   320 */   381,  -71,  -71,  369, 1042, 1086,  -71,  -71, 1044, 1091,
 /*   330 */   -71,  -71, 1092,  -71, 1093,  -71,  -71,  626,  -71, 1095,
 /*   340 */   -71,  -71, 1096,  -71,  -71, 1106,  182,  -71,  -71,  245,
 /*   350 */   -71,  -71,  -71,  -71, 1032,  -71,  -71,  -71, 1034,  -71,
 /*   360 */   -71,  -71,  -71,  -71, 1094, 1100,  -71, 1117,  -71,  -71,
 /*   370 */   -71,  383, 1102,  -71, 1103,  -71,  -71,  642,  -71, 1107,
 /*   380 */   -71, 1014,  305,  -71,  -71,  -71,  657,  -71,  -71, 1130,
 /*   390 */  1108, 1109,  -49,  -71,  -71,  -71,  -71,  -71,  -71,  587,
 /*   400 */   964,  601,  -71, 1134, 1133,  -71, 1136, 1135,  -71,  725,
 /*   410 */   964, 1140, 1137, 1064, 1066,  -71,  295, 1138,  -71, 1067,
 /*   420 */  1069,  -71,  808,   82,  -71,  -71,  -71,  -71,  -71,  -71,
 /*   430 */   -71,  721,  -71,  -71,  -71,  -71,  -71,  -71,  -71, 1155,
 /*   440 */  1152,  -71, 1158,  -71,  729,  -71, 1139,  -71,  -71,  -71,
 /*   450 */   592,  964, 1129,  735,  -71,  -71,  -71,  -71,  -71,  -71,
 /*   460 */   604,  -71, 1141, 1169,  -71,  845, 1131, 1174,  -71, 1015,
 /*   470 */    82,  -71,  -71, 1016,   82,  -71, 1183, 1115,  760,  -71,
 /*   480 */   -71,  860,  964,  -71,  535,  -71, 1021,   82,  -71,   82,
 /*   490 */   -71, 1189, 1142,  -71,  -71,  800,  -71,  873,  -71,  880,
 /*   500 */   -71,  900,  -71,  964,  -71,  912, 1151,  -71, 1162,  915,
 /*   510 */   -71,  888, 1156,  -71,  -71,  930, 1143,  992,  964,  -71,
 /*   520 */   703,  -71,  -71, 1204,  -71, 1205, 1202,  -71,  648,  -71,
 /*   530 */   -71,  -71,  -71, 1213,  -71,  -71, 1144, 1208,  -71, 1219,
 /*   540 */  1145,  -71, 1209,  -71,  -71,  -71, 1147, 1225,  -71, 1229,
 /*   550 */  1222,  -71,  -71,  191,  -71,  -71, 1231,  -71,  -71, 1148,
 /*   560 */   553,  -71,  -71,  -71,  -71,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   571,  571,  566,  569,  870,  870,  870,  570,  577,  870,
 /*    10 */   870,  870,  870,  597,  598,  599,  578,  579,  580,  870,
 /*    20 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*    30 */   870,  870,  590,  600,  609,  592,  608,  870,  870,  610,
 /*    40 */   653,  616,  870,  870,  654,  657,  658,  659,  852,  853,
 /*    50 */   854,  870,  653,  617,  638,  636,  870,  639,  640,  870,
 /*    60 */   709,  653,  624,  618,  625,  707,  708,  653,  619,  870,
 /*    70 */   870,  739,  804,  745,  740,  736,  870,  664,  870,  870,
 /*    80 */   665,  673,  675,  682,  721,  712,  714,  702,  716,  670,
 /*    90 */   870,  717,  870,  718,  870,  738,  870,  870,  741,  870,
 /*   100 */   742,  743,  744,  746,  747,  748,  751,  752,  870,  753,
 /*   110 */   870,  754,  870,  755,  870,  756,  870,  757,  870,  758,
 /*   120 */   870,  759,  870,  760,  870,  761,  870,  762,  870,  763,
 /*   130 */   870,  764,  870,  765,  870,  766,  870,  767,  870,  768,
 /*   140 */   870,  769,  770,  870,  771,  778,  785,  788,  870,  773,
 /*   150 */   870,  772,  775,  870,  776,  870,  779,  777,  784,  870,
 /*   160 */   870,  870,  786,  787,  870,  804,  870,  870,  870,  870,
 /*   170 */   870,  791,  803,  870,  780,  870,  781,  870,  782,  870,
 /*   180 */   783,  870,  870,  870,  793,  870,  870,  870,  870,  870,
 /*   190 */   794,  870,  870,  870,  795,  870,  870,  870,  850,  870,
 /*   200 */   870,  870,  851,  870,  870,  870,  870,  870,  796,  870,
 /*   210 */   789,  804,  801,  802,  690,  870,  691,  792,  774,  870,
 /*   220 */   719,  870,  870,  703,  870,  710,  709,  704,  870,  594,
 /*   230 */   711,  706,  710,  709,  705,  870,  715,  870,  804,  713,
 /*   240 */   870,  722,  674,  685,  683,  684,  693,  694,  870,  695,
 /*   250 */   870,  696,  870,  697,  870,  690,  681,  595,  596,  870,
 /*   260 */   679,  680,  699,  701,  686,  870,  870,  870,  700,  870,
 /*   270 */   734,  735,  870,  698,  685,  870,  870,  870,  681,  699,
 /*   280 */   701,  687,  870,  681,  676,  677,  870,  870,  678,  671,
 /*   290 */   672,  790,  870,  737,  870,  749,  870,  750,  870,  653,
 /*   300 */   620,  870,  808,  626,  621,  627,  870,  628,  870,  870,
 /*   310 */   629,  870,  632,  633,  634,  635,  870,  630,  870,  631,
 /*   320 */   870,  870,  809,  870,  710,  709,  810,  812,  710,  709,
 /*   330 */   811,  622,  870,  623,  638,  637,  611,  870,  612,  870,
 /*   340 */   613,  745,  870,  614,  615,  601,  827,  870,  602,  827,
 /*   350 */   870,  603,  606,  607,  870,  822,  824,  825,  870,  823,
 /*   360 */   826,  605,  604,  593,  870,  870,  643,  870,  646,  870,
 /*   370 */   870,  870,  870,  870,  653,  647,  870,  870,  870,  653,
 /*   380 */   648,  870,  653,  649,  870,  870,  870,  870,  870,  870,
 /*   390 */   808,  626,  651,  870,  650,  652,  644,  645,  591,  870,
 /*   400 */   870,  587,  870,  870,  690,  585,  870,  870,  870,  870,
 /*   410 */   870,  870,  690,  833,  870,  870,  870,  690,  692,  838,
 /*   420 */   870,  870,  870,  870,  870,  870,  839,  840,  870,  870,
 /*   430 */   870,  870,  870,  830,  831,  870,  832,  586,  870,  870,
 /*   440 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   450 */   870,  870,  870,  870,  656,  870,  870,  870,  870,  870,
 /*   460 */   870,  870,  655,  870,  870,  870,  870,  870,  870,  870,
 /*   470 */   724,  870,  870,  870,  725,  870,  870,  732,  870,  870,
 /*   480 */   733,  870,  870,  870,  870,  870,  870,  730,  870,  731,
 /*   490 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  870,
 /*   500 */   870,  870,  870,  870,  870,  870,  870,  870,  655,  870,
 /*   510 */   870,  870,  870,  870,  870,  870,  732,  870,  870,  870,
 /*   520 */   870,  870,  870,  870,  870,  870,  690,  870,  827,  870,
 /*   530 */   870,  870,  870,  870,  870,  870,  861,  870,  870,  870,
 /*   540 */   870,  870,  870,  870,  870,  860,  861,  870,  870,  870,
 /*   550 */   870,  870,  870,  870,  870,  870,  870,  870,  870,  868,
 /*   560 */   870,  870,  869,  572,  567,
};
#define YY_SZ_ACTTAB (sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /* END_OF_FILE => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*      SPACE => nothing */
    0,  /* UNCLOSED_STRING => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*     COLUMN => nothing */
    0,  /* AGG_FUNCTION => nothing */
    0,  /* CONST_FUNC => nothing */
    0,  /*       SEMI => nothing */
   27,  /*    EXPLAIN => ID */
   27,  /*      BEGIN => ID */
    0,  /* TRANSACTION => nothing */
   27,  /*   DEFERRED => ID */
   27,  /*  IMMEDIATE => ID */
   27,  /*  EXCLUSIVE => ID */
    0,  /*     COMMIT => nothing */
   27,  /*        END => ID */
    0,  /*   ROLLBACK => nothing */
    0,  /*     CREATE => nothing */
    0,  /*      TABLE => nothing */
   27,  /*       TEMP => ID */
    0,  /*         LP => nothing */
    0,  /*         RP => nothing */
    0,  /*         AS => nothing */
    0,  /*      COMMA => nothing */
    0,  /*         ID => nothing */
   27,  /*      ABORT => ID */
   27,  /*      AFTER => ID */
   27,  /*        ASC => ID */
   27,  /*     ATTACH => ID */
   27,  /*     BEFORE => ID */
   27,  /*    CASCADE => ID */
   27,  /*   CONFLICT => ID */
   27,  /*   DATABASE => ID */
   27,  /*       DESC => ID */
   27,  /*     DETACH => ID */
   27,  /*       EACH => ID */
   27,  /*       FAIL => ID */
   27,  /*        FOR => ID */
   27,  /*     IGNORE => ID */
   27,  /*  INITIALLY => ID */
   27,  /*    INSTEAD => ID */
   27,  /*    LIKE_KW => ID */
   27,  /*      MATCH => ID */
   27,  /*        KEY => ID */
   27,  /*         OF => ID */
   27,  /*     OFFSET => ID */
   27,  /*     PRAGMA => ID */
   27,  /*      RAISE => ID */
   27,  /*    REPLACE => ID */
   27,  /*   RESTRICT => ID */
   27,  /*        ROW => ID */
   27,  /*  STATEMENT => ID */
   27,  /*    TRIGGER => ID */
   27,  /*     VACUUM => ID */
   27,  /*       VIEW => ID */
   27,  /*    REINDEX => ID */
   27,  /*     RENAME => ID */
   27,  /*   CTIME_KW => ID */
   27,  /*      ALTER => ID */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*        NOT => nothing */
    0,  /*         IS => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IN => nothing */
    0,  /*     ISNULL => nothing */
    0,  /*    NOTNULL => nothing */
    0,  /*         NE => nothing */
    0,  /*         EQ => nothing */
    0,  /*         GT => nothing */
    0,  /*         LE => nothing */
    0,  /*         LT => nothing */
    0,  /*         GE => nothing */
    0,  /*     ESCAPE => nothing */
    0,  /*     BITAND => nothing */
    0,  /*      BITOR => nothing */
    0,  /*     LSHIFT => nothing */
    0,  /*     RSHIFT => nothing */
    0,  /*       PLUS => nothing */
    0,  /*      MINUS => nothing */
    0,  /*       STAR => nothing */
    0,  /*      SLASH => nothing */
    0,  /*        REM => nothing */
    0,  /*     CONCAT => nothing */
    0,  /*     UMINUS => nothing */
    0,  /*      UPLUS => nothing */
    0,  /*     BITNOT => nothing */
    0,  /*     STRING => nothing */
    0,  /*    JOIN_KW => nothing */
    0,  /* CONSTRAINT => nothing */
    0,  /*    DEFAULT => nothing */
    0,  /*       NULL => nothing */
    0,  /*    PRIMARY => nothing */
    0,  /*     UNIQUE => nothing */
    0,  /*      CHECK => nothing */
    0,  /* REFERENCES => nothing */
    0,  /*    COLLATE => nothing */
    0,  /*   AUTOINCR => nothing */
    0,  /*         ON => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*        SET => nothing */
    0,  /* DEFERRABLE => nothing */
    0,  /*    FOREIGN => nothing */
    0,  /*       DROP => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*        DOT => nothing */
    0,  /*       FROM => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      USING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*         BY => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*       INTO => nothing */
    0,  /*     VALUES => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*       BLOB => nothing */
    0,  /*   REGISTER => nothing */
    0,  /*   VARIABLE => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*         TO => nothing */
    0,  /*        ADD => nothing */
    0,  /*   COLUMNKW => nothing */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite3ParserARG_SDECL                /* A place to hold %extra_argument */
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3ParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "END_OF_FILE",   "ILLEGAL",       "SPACE",       
  "UNCLOSED_STRING",  "COMMENT",       "FUNCTION",      "COLUMN",      
  "AGG_FUNCTION",  "CONST_FUNC",    "SEMI",          "EXPLAIN",     
  "BEGIN",         "TRANSACTION",   "DEFERRED",      "IMMEDIATE",   
  "EXCLUSIVE",     "COMMIT",        "END",           "ROLLBACK",    
  "CREATE",        "TABLE",         "TEMP",          "LP",          
  "RP",            "AS",            "COMMA",         "ID",          
  "ABORT",         "AFTER",         "ASC",           "ATTACH",      
  "BEFORE",        "CASCADE",       "CONFLICT",      "DATABASE",    
  "DESC",          "DETACH",        "EACH",          "FAIL",        
  "FOR",           "IGNORE",        "INITIALLY",     "INSTEAD",     
  "LIKE_KW",       "MATCH",         "KEY",           "OF",          
  "OFFSET",        "PRAGMA",        "RAISE",         "REPLACE",     
  "RESTRICT",      "ROW",           "STATEMENT",     "TRIGGER",     
  "VACUUM",        "VIEW",          "REINDEX",       "RENAME",      
  "CTIME_KW",      "ALTER",         "OR",            "AND",         
  "NOT",           "IS",            "BETWEEN",       "IN",          
  "ISNULL",        "NOTNULL",       "NE",            "EQ",          
  "GT",            "LE",            "LT",            "GE",          
  "ESCAPE",        "BITAND",        "BITOR",         "LSHIFT",      
  "RSHIFT",        "PLUS",          "MINUS",         "STAR",        
  "SLASH",         "REM",           "CONCAT",        "UMINUS",      
  "UPLUS",         "BITNOT",        "STRING",        "JOIN_KW",     
  "CONSTRAINT",    "DEFAULT",       "NULL",          "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "COLLATE",     
  "AUTOINCR",      "ON",            "DELETE",        "UPDATE",      
  "INSERT",        "SET",           "DEFERRABLE",    "FOREIGN",     
  "DROP",          "UNION",         "ALL",           "INTERSECT",   
  "EXCEPT",        "SELECT",        "DISTINCT",      "DOT",         
  "FROM",          "JOIN",          "USING",         "ORDER",       
  "BY",            "GROUP",         "HAVING",        "LIMIT",       
  "WHERE",         "INTO",          "VALUES",        "INTEGER",     
  "FLOAT",         "BLOB",          "REGISTER",      "VARIABLE",    
  "EXISTS",        "CASE",          "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "TO",            "ADD",         
  "COLUMNKW",      "error",         "input",         "cmdlist",     
  "ecmd",          "cmdx",          "cmd",           "explain",     
  "transtype",     "trans_opt",     "nm",            "create_table",
  "create_table_args",  "temp",          "dbnm",          "columnlist",  
  "conslist_opt",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typename",      "signed",        "plus_num",      "minus_num",   
  "carg",          "ccons",         "term",          "onconf",      
  "sortorder",     "autoinc",       "expr",          "idxlist_opt", 
  "refargs",       "defer_subclause",  "refarg",        "refact",      
  "init_deferred_pred_opt",  "conslist",      "tcons",         "idxlist",     
  "defer_subclause_opt",  "orconf",        "resolvetype",   "raisetype",   
  "fullname",      "oneselect",     "multiselect_op",  "distinct",    
  "selcollist",    "from",          "where_opt",     "groupby_opt", 
  "having_opt",    "orderby_opt",   "limit_opt",     "sclp",        
  "as",            "seltablist",    "stl_prefix",    "joinop",      
  "on_opt",        "using_opt",     "seltablist_paren",  "joinop2",     
  "inscollist",    "sortlist",      "sortitem",      "collate",     
  "exprlist",      "setlist",       "insert_cmd",    "inscollist_opt",
  "itemlist",      "likeop",        "escape",        "between_op",  
  "in_op",         "case_operand",  "case_exprlist",  "case_else",   
  "expritem",      "uniqueflag",    "idxitem",       "plus_opt",    
  "number",        "trigger_decl",  "trigger_cmd_list",  "trigger_time",
  "trigger_event",  "foreach_clause",  "when_clause",   "trigger_cmd", 
  "database_kw_opt",  "key_opt",       "add_column_fullname",  "kwcolumn_opt",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "cmdx ::= cmd",
 /*   4 */ "ecmd ::= SEMI",
 /*   5 */ "ecmd ::= explain cmdx SEMI",
 /*   6 */ "explain ::=",
 /*   7 */ "explain ::= EXPLAIN",
 /*   8 */ "cmd ::= BEGIN transtype trans_opt",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "transtype ::=",
 /*  13 */ "transtype ::= DEFERRED",
 /*  14 */ "transtype ::= IMMEDIATE",
 /*  15 */ "transtype ::= EXCLUSIVE",
 /*  16 */ "cmd ::= COMMIT trans_opt",
 /*  17 */ "cmd ::= END trans_opt",
 /*  18 */ "cmd ::= ROLLBACK trans_opt",
 /*  19 */ "cmd ::= create_table create_table_args",
 /*  20 */ "create_table ::= CREATE temp TABLE nm dbnm",
 /*  21 */ "temp ::= TEMP",
 /*  22 */ "temp ::=",
 /*  23 */ "create_table_args ::= LP columnlist conslist_opt RP",
 /*  24 */ "create_table_args ::= AS select",
 /*  25 */ "columnlist ::= columnlist COMMA column",
 /*  26 */ "columnlist ::= column",
 /*  27 */ "column ::= columnid type carglist",
 /*  28 */ "columnid ::= nm",
 /*  29 */ "id ::= ID",
 /*  30 */ "ids ::= ID",
 /*  31 */ "ids ::= STRING",
 /*  32 */ "nm ::= ID",
 /*  33 */ "nm ::= STRING",
 /*  34 */ "nm ::= JOIN_KW",
 /*  35 */ "type ::=",
 /*  36 */ "type ::= typename",
 /*  37 */ "type ::= typename LP signed RP",
 /*  38 */ "type ::= typename LP signed COMMA signed RP",
 /*  39 */ "typename ::= ids",
 /*  40 */ "typename ::= typename ids",
 /*  41 */ "signed ::= plus_num",
 /*  42 */ "signed ::= minus_num",
 /*  43 */ "carglist ::= carglist carg",
 /*  44 */ "carglist ::=",
 /*  45 */ "carg ::= CONSTRAINT nm ccons",
 /*  46 */ "carg ::= ccons",
 /*  47 */ "carg ::= DEFAULT term",
 /*  48 */ "carg ::= DEFAULT PLUS term",
 /*  49 */ "carg ::= DEFAULT MINUS term",
 /*  50 */ "carg ::= DEFAULT id",
 /*  51 */ "ccons ::= NULL onconf",
 /*  52 */ "ccons ::= NOT NULL onconf",
 /*  53 */ "ccons ::= PRIMARY KEY sortorder onconf autoinc",
 /*  54 */ "ccons ::= UNIQUE onconf",
 /*  55 */ "ccons ::= CHECK LP expr RP onconf",
 /*  56 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  57 */ "ccons ::= defer_subclause",
 /*  58 */ "ccons ::= COLLATE id",
 /*  59 */ "autoinc ::=",
 /*  60 */ "autoinc ::= AUTOINCR",
 /*  61 */ "refargs ::=",
 /*  62 */ "refargs ::= refargs refarg",
 /*  63 */ "refarg ::= MATCH nm",
 /*  64 */ "refarg ::= ON DELETE refact",
 /*  65 */ "refarg ::= ON UPDATE refact",
 /*  66 */ "refarg ::= ON INSERT refact",
 /*  67 */ "refact ::= SET NULL",
 /*  68 */ "refact ::= SET DEFAULT",
 /*  69 */ "refact ::= CASCADE",
 /*  70 */ "refact ::= RESTRICT",
 /*  71 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  72 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  73 */ "init_deferred_pred_opt ::=",
 /*  74 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  75 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  76 */ "conslist_opt ::=",
 /*  77 */ "conslist_opt ::= COMMA conslist",
 /*  78 */ "conslist ::= conslist COMMA tcons",
 /*  79 */ "conslist ::= conslist tcons",
 /*  80 */ "conslist ::= tcons",
 /*  81 */ "tcons ::= CONSTRAINT nm",
 /*  82 */ "tcons ::= PRIMARY KEY LP idxlist autoinc RP onconf",
 /*  83 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  84 */ "tcons ::= CHECK expr onconf",
 /*  85 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  86 */ "defer_subclause_opt ::=",
 /*  87 */ "defer_subclause_opt ::= defer_subclause",
 /*  88 */ "onconf ::=",
 /*  89 */ "onconf ::= ON CONFLICT resolvetype",
 /*  90 */ "orconf ::=",
 /*  91 */ "orconf ::= OR resolvetype",
 /*  92 */ "resolvetype ::= raisetype",
 /*  93 */ "resolvetype ::= IGNORE",
 /*  94 */ "resolvetype ::= REPLACE",
 /*  95 */ "cmd ::= DROP TABLE fullname",
 /*  96 */ "cmd ::= CREATE temp VIEW nm dbnm AS select",
 /*  97 */ "cmd ::= DROP VIEW fullname",
 /*  98 */ "cmd ::= select",
 /*  99 */ "select ::= oneselect",
 /* 100 */ "select ::= select multiselect_op oneselect",
 /* 101 */ "multiselect_op ::= UNION",
 /* 102 */ "multiselect_op ::= UNION ALL",
 /* 103 */ "multiselect_op ::= INTERSECT",
 /* 104 */ "multiselect_op ::= EXCEPT",
 /* 105 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 106 */ "distinct ::= DISTINCT",
 /* 107 */ "distinct ::= ALL",
 /* 108 */ "distinct ::=",
 /* 109 */ "sclp ::= selcollist COMMA",
 /* 110 */ "sclp ::=",
 /* 111 */ "selcollist ::= sclp expr as",
 /* 112 */ "selcollist ::= sclp STAR",
 /* 113 */ "selcollist ::= sclp nm DOT STAR",
 /* 114 */ "as ::= AS nm",
 /* 115 */ "as ::= ids",
 /* 116 */ "as ::=",
 /* 117 */ "from ::=",
 /* 118 */ "from ::= FROM seltablist",
 /* 119 */ "stl_prefix ::= seltablist joinop",
 /* 120 */ "stl_prefix ::=",
 /* 121 */ "seltablist ::= stl_prefix nm dbnm as on_opt using_opt",
 /* 122 */ "seltablist ::= stl_prefix LP seltablist_paren RP as on_opt using_opt",
 /* 123 */ "seltablist_paren ::= select",
 /* 124 */ "seltablist_paren ::= seltablist",
 /* 125 */ "dbnm ::=",
 /* 126 */ "dbnm ::= DOT nm",
 /* 127 */ "fullname ::= nm dbnm",
 /* 128 */ "joinop ::= COMMA",
 /* 129 */ "joinop ::= JOIN",
 /* 130 */ "joinop ::= JOIN_KW JOIN",
 /* 131 */ "joinop ::= JOIN_KW nm JOIN",
 /* 132 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 133 */ "on_opt ::= ON expr",
 /* 134 */ "on_opt ::=",
 /* 135 */ "using_opt ::= USING LP inscollist RP",
 /* 136 */ "using_opt ::=",
 /* 137 */ "orderby_opt ::=",
 /* 138 */ "orderby_opt ::= ORDER BY sortlist",
 /* 139 */ "sortlist ::= sortlist COMMA sortitem collate sortorder",
 /* 140 */ "sortlist ::= sortitem collate sortorder",
 /* 141 */ "sortitem ::= expr",
 /* 142 */ "sortorder ::= ASC",
 /* 143 */ "sortorder ::= DESC",
 /* 144 */ "sortorder ::=",
 /* 145 */ "collate ::=",
 /* 146 */ "collate ::= COLLATE id",
 /* 147 */ "groupby_opt ::=",
 /* 148 */ "groupby_opt ::= GROUP BY exprlist",
 /* 149 */ "having_opt ::=",
 /* 150 */ "having_opt ::= HAVING expr",
 /* 151 */ "limit_opt ::=",
 /* 152 */ "limit_opt ::= LIMIT expr",
 /* 153 */ "limit_opt ::= LIMIT expr OFFSET expr",
 /* 154 */ "limit_opt ::= LIMIT expr COMMA expr",
 /* 155 */ "cmd ::= DELETE FROM fullname where_opt",
 /* 156 */ "where_opt ::=",
 /* 157 */ "where_opt ::= WHERE expr",
 /* 158 */ "cmd ::= UPDATE orconf fullname SET setlist where_opt",
 /* 159 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 160 */ "setlist ::= nm EQ expr",
 /* 161 */ "cmd ::= insert_cmd INTO fullname inscollist_opt VALUES LP itemlist RP",
 /* 162 */ "cmd ::= insert_cmd INTO fullname inscollist_opt select",
 /* 163 */ "insert_cmd ::= INSERT orconf",
 /* 164 */ "insert_cmd ::= REPLACE",
 /* 165 */ "itemlist ::= itemlist COMMA expr",
 /* 166 */ "itemlist ::= expr",
 /* 167 */ "inscollist_opt ::=",
 /* 168 */ "inscollist_opt ::= LP inscollist RP",
 /* 169 */ "inscollist ::= inscollist COMMA nm",
 /* 170 */ "inscollist ::= nm",
 /* 171 */ "expr ::= term",
 /* 172 */ "expr ::= LP expr RP",
 /* 173 */ "term ::= NULL",
 /* 174 */ "expr ::= ID",
 /* 175 */ "expr ::= JOIN_KW",
 /* 176 */ "expr ::= nm DOT nm",
 /* 177 */ "expr ::= nm DOT nm DOT nm",
 /* 178 */ "term ::= INTEGER",
 /* 179 */ "term ::= FLOAT",
 /* 180 */ "term ::= STRING",
 /* 181 */ "term ::= BLOB",
 /* 182 */ "expr ::= REGISTER",
 /* 183 */ "expr ::= VARIABLE",
 /* 184 */ "expr ::= ID LP exprlist RP",
 /* 185 */ "expr ::= ID LP STAR RP",
 /* 186 */ "term ::= CTIME_KW",
 /* 187 */ "expr ::= expr AND expr",
 /* 188 */ "expr ::= expr OR expr",
 /* 189 */ "expr ::= expr LT expr",
 /* 190 */ "expr ::= expr GT expr",
 /* 191 */ "expr ::= expr LE expr",
 /* 192 */ "expr ::= expr GE expr",
 /* 193 */ "expr ::= expr NE expr",
 /* 194 */ "expr ::= expr EQ expr",
 /* 195 */ "expr ::= expr BITAND expr",
 /* 196 */ "expr ::= expr BITOR expr",
 /* 197 */ "expr ::= expr LSHIFT expr",
 /* 198 */ "expr ::= expr RSHIFT expr",
 /* 199 */ "expr ::= expr PLUS expr",
 /* 200 */ "expr ::= expr MINUS expr",
 /* 201 */ "expr ::= expr STAR expr",
 /* 202 */ "expr ::= expr SLASH expr",
 /* 203 */ "expr ::= expr REM expr",
 /* 204 */ "expr ::= expr CONCAT expr",
 /* 205 */ "likeop ::= LIKE_KW",
 /* 206 */ "likeop ::= NOT LIKE_KW",
 /* 207 */ "escape ::= ESCAPE expr",
 /* 208 */ "escape ::=",
 /* 209 */ "expr ::= expr likeop expr escape",
 /* 210 */ "expr ::= expr ISNULL",
 /* 211 */ "expr ::= expr IS NULL",
 /* 212 */ "expr ::= expr NOTNULL",
 /* 213 */ "expr ::= expr NOT NULL",
 /* 214 */ "expr ::= expr IS NOT NULL",
 /* 215 */ "expr ::= NOT expr",
 /* 216 */ "expr ::= BITNOT expr",
 /* 217 */ "expr ::= MINUS expr",
 /* 218 */ "expr ::= PLUS expr",
 /* 219 */ "between_op ::= BETWEEN",
 /* 220 */ "between_op ::= NOT BETWEEN",
 /* 221 */ "expr ::= expr between_op expr AND expr",
 /* 222 */ "in_op ::= IN",
 /* 223 */ "in_op ::= NOT IN",
 /* 224 */ "expr ::= expr in_op LP exprlist RP",
 /* 225 */ "expr ::= LP select RP",
 /* 226 */ "expr ::= expr in_op LP select RP",
 /* 227 */ "expr ::= expr in_op nm dbnm",
 /* 228 */ "expr ::= EXISTS LP select RP",
 /* 229 */ "expr ::= CASE case_operand case_exprlist case_else END",
 /* 230 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 231 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 232 */ "case_else ::= ELSE expr",
 /* 233 */ "case_else ::=",
 /* 234 */ "case_operand ::= expr",
 /* 235 */ "case_operand ::=",
 /* 236 */ "exprlist ::= exprlist COMMA expritem",
 /* 237 */ "exprlist ::= expritem",
 /* 238 */ "expritem ::= expr",
 /* 239 */ "expritem ::=",
 /* 240 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON nm LP idxlist RP onconf",
 /* 241 */ "uniqueflag ::= UNIQUE",
 /* 242 */ "uniqueflag ::=",
 /* 243 */ "idxlist_opt ::=",
 /* 244 */ "idxlist_opt ::= LP idxlist RP",
 /* 245 */ "idxlist ::= idxlist COMMA idxitem collate sortorder",
 /* 246 */ "idxlist ::= idxitem collate sortorder",
 /* 247 */ "idxitem ::= nm",
 /* 248 */ "cmd ::= DROP INDEX fullname",
 /* 249 */ "cmd ::= VACUUM",
 /* 250 */ "cmd ::= VACUUM nm",
 /* 251 */ "cmd ::= PRAGMA nm dbnm EQ nm",
 /* 252 */ "cmd ::= PRAGMA nm dbnm EQ ON",
 /* 253 */ "cmd ::= PRAGMA nm dbnm EQ plus_num",
 /* 254 */ "cmd ::= PRAGMA nm dbnm EQ minus_num",
 /* 255 */ "cmd ::= PRAGMA nm dbnm LP nm RP",
 /* 256 */ "cmd ::= PRAGMA nm dbnm",
 /* 257 */ "plus_num ::= plus_opt number",
 /* 258 */ "minus_num ::= MINUS number",
 /* 259 */ "number ::= INTEGER",
 /* 260 */ "number ::= FLOAT",
 /* 261 */ "plus_opt ::= PLUS",
 /* 262 */ "plus_opt ::=",
 /* 263 */ "cmd ::= CREATE trigger_decl BEGIN trigger_cmd_list END",
 /* 264 */ "trigger_decl ::= temp TRIGGER nm dbnm trigger_time trigger_event ON fullname foreach_clause when_clause",
 /* 265 */ "trigger_time ::= BEFORE",
 /* 266 */ "trigger_time ::= AFTER",
 /* 267 */ "trigger_time ::= INSTEAD OF",
 /* 268 */ "trigger_time ::=",
 /* 269 */ "trigger_event ::= DELETE",
 /* 270 */ "trigger_event ::= INSERT",
 /* 271 */ "trigger_event ::= UPDATE",
 /* 272 */ "trigger_event ::= UPDATE OF inscollist",
 /* 273 */ "foreach_clause ::=",
 /* 274 */ "foreach_clause ::= FOR EACH ROW",
 /* 275 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 276 */ "when_clause ::=",
 /* 277 */ "when_clause ::= WHEN expr",
 /* 278 */ "trigger_cmd_list ::= trigger_cmd SEMI trigger_cmd_list",
 /* 279 */ "trigger_cmd_list ::=",
 /* 280 */ "trigger_cmd ::= UPDATE orconf nm SET setlist where_opt",
 /* 281 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt VALUES LP itemlist RP",
 /* 282 */ "trigger_cmd ::= insert_cmd INTO nm inscollist_opt select",
 /* 283 */ "trigger_cmd ::= DELETE FROM nm where_opt",
 /* 284 */ "trigger_cmd ::= select",
 /* 285 */ "expr ::= RAISE LP IGNORE RP",
 /* 286 */ "expr ::= RAISE LP raisetype COMMA nm RP",
 /* 287 */ "raisetype ::= ROLLBACK",
 /* 288 */ "raisetype ::= ABORT",
 /* 289 */ "raisetype ::= FAIL",
 /* 290 */ "cmd ::= DROP TRIGGER fullname",
 /* 291 */ "cmd ::= ATTACH database_kw_opt ids AS nm key_opt",
 /* 292 */ "key_opt ::=",
 /* 293 */ "key_opt ::= KEY ids",
 /* 294 */ "key_opt ::= KEY BLOB",
 /* 295 */ "database_kw_opt ::= DATABASE",
 /* 296 */ "database_kw_opt ::=",
 /* 297 */ "cmd ::= DETACH database_kw_opt nm",
 /* 298 */ "cmd ::= REINDEX",
 /* 299 */ "cmd ::= REINDEX nm dbnm",
 /* 300 */ "cmd ::= ALTER TABLE fullname RENAME TO nm",
 /* 301 */ "cmd ::= ALTER TABLE add_column_fullname ADD kwcolumn_opt column",
 /* 302 */ "add_column_fullname ::= fullname",
 /* 303 */ "kwcolumn_opt ::=",
 /* 304 */ "kwcolumn_opt ::= COLUMNKW",
};
#endif /* NDEBUG */

/*
** This function returns the symbolic name associated with a token
** value.
*/
const char *sqlite3ParserTokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(yyTokenName)/sizeof(yyTokenName[0])) ){
    return yyTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite3Parser and sqlite3ParserFree.
*/
void *sqlite3ParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 157:
    case 189:
    case 206:
#line 334 "parse.y"
{sqlite3SelectDelete((yypminor->yy459));}
#line 1301 "parse.c"
      break;
    case 170:
    case 174:
    case 194:
    case 196:
    case 204:
    case 210:
    case 224:
#line 593 "parse.y"
{sqlite3ExprDelete((yypminor->yy2));}
#line 1312 "parse.c"
      break;
    case 175:
    case 183:
    case 192:
    case 195:
    case 197:
    case 199:
    case 209:
    case 212:
    case 213:
    case 216:
    case 222:
#line 812 "parse.y"
{sqlite3ExprListDelete((yypminor->yy82));}
#line 1327 "parse.c"
      break;
    case 188:
    case 193:
    case 201:
    case 202:
#line 463 "parse.y"
{sqlite3SrcListDelete((yypminor->yy67));}
#line 1335 "parse.c"
      break;
    case 198:
#line 525 "parse.y"
{
  sqlite3ExprDelete((yypminor->yy244).pLimit);
  sqlite3ExprDelete((yypminor->yy244).pOffset);
}
#line 1343 "parse.c"
      break;
    case 205:
    case 208:
    case 215:
#line 481 "parse.y"
{sqlite3IdListDelete((yypminor->yy240));}
#line 1350 "parse.c"
      break;
    case 230:
    case 235:
#line 905 "parse.y"
{sqlite3DeleteTriggerStep((yypminor->yy347));}
#line 1356 "parse.c"
      break;
    case 232:
#line 889 "parse.y"
{sqlite3IdListDelete((yypminor->yy210).b);}
#line 1361 "parse.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite3ParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite3ParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  /* if( pParser->yyidx<0 ) return YY_NO_ACTION;  */
  i = yy_shift_ofst[stateno];
  if( i==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
           && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
           yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
      }
#endif
      return yy_find_shift_action(pParser, iFallback);
    }
#endif
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  i = yy_reduce_ofst[stateno];
  if( i==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
  if( yypParser->yyidx>=YYSTACKDEPTH ){
     sqlite3ParserARG_FETCH;
     yypParser->yyidx--;
#ifndef NDEBUG
     if( yyTraceFILE ){
       fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
     }
#endif
     while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 142, 1 },
  { 143, 2 },
  { 143, 1 },
  { 145, 1 },
  { 144, 1 },
  { 144, 3 },
  { 147, 0 },
  { 147, 1 },
  { 146, 3 },
  { 149, 0 },
  { 149, 1 },
  { 149, 2 },
  { 148, 0 },
  { 148, 1 },
  { 148, 1 },
  { 148, 1 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 146, 2 },
  { 151, 5 },
  { 153, 1 },
  { 153, 0 },
  { 152, 4 },
  { 152, 2 },
  { 155, 3 },
  { 155, 1 },
  { 158, 3 },
  { 159, 1 },
  { 162, 1 },
  { 163, 1 },
  { 163, 1 },
  { 150, 1 },
  { 150, 1 },
  { 150, 1 },
  { 160, 0 },
  { 160, 1 },
  { 160, 4 },
  { 160, 6 },
  { 164, 1 },
  { 164, 2 },
  { 165, 1 },
  { 165, 1 },
  { 161, 2 },
  { 161, 0 },
  { 168, 3 },
  { 168, 1 },
  { 168, 2 },
  { 168, 3 },
  { 168, 3 },
  { 168, 2 },
  { 169, 2 },
  { 169, 3 },
  { 169, 5 },
  { 169, 2 },
  { 169, 5 },
  { 169, 4 },
  { 169, 1 },
  { 169, 2 },
  { 173, 0 },
  { 173, 1 },
  { 176, 0 },
  { 176, 2 },
  { 178, 2 },
  { 178, 3 },
  { 178, 3 },
  { 178, 3 },
  { 179, 2 },
  { 179, 2 },
  { 179, 1 },
  { 179, 1 },
  { 177, 3 },
  { 177, 2 },
  { 180, 0 },
  { 180, 2 },
  { 180, 2 },
  { 156, 0 },
  { 156, 2 },
  { 181, 3 },
  { 181, 2 },
  { 181, 1 },
  { 182, 2 },
  { 182, 7 },
  { 182, 5 },
  { 182, 3 },
  { 182, 10 },
  { 184, 0 },
  { 184, 1 },
  { 171, 0 },
  { 171, 3 },
  { 185, 0 },
  { 185, 2 },
  { 186, 1 },
  { 186, 1 },
  { 186, 1 },
  { 146, 3 },
  { 146, 7 },
  { 146, 3 },
  { 146, 1 },
  { 157, 1 },
  { 157, 3 },
  { 190, 1 },
  { 190, 2 },
  { 190, 1 },
  { 190, 1 },
  { 189, 9 },
  { 191, 1 },
  { 191, 1 },
  { 191, 0 },
  { 199, 2 },
  { 199, 0 },
  { 192, 3 },
  { 192, 2 },
  { 192, 4 },
  { 200, 2 },
  { 200, 1 },
  { 200, 0 },
  { 193, 0 },
  { 193, 2 },
  { 202, 2 },
  { 202, 0 },
  { 201, 6 },
  { 201, 7 },
  { 206, 1 },
  { 206, 1 },
  { 154, 0 },
  { 154, 2 },
  { 188, 2 },
  { 203, 1 },
  { 203, 1 },
  { 203, 2 },
  { 203, 3 },
  { 203, 4 },
  { 204, 2 },
  { 204, 0 },
  { 205, 4 },
  { 205, 0 },
  { 197, 0 },
  { 197, 3 },
  { 209, 5 },
  { 209, 3 },
  { 210, 1 },
  { 172, 1 },
  { 172, 1 },
  { 172, 0 },
  { 211, 0 },
  { 211, 2 },
  { 195, 0 },
  { 195, 3 },
  { 196, 0 },
  { 196, 2 },
  { 198, 0 },
  { 198, 2 },
  { 198, 4 },
  { 198, 4 },
  { 146, 4 },
  { 194, 0 },
  { 194, 2 },
  { 146, 6 },
  { 213, 5 },
  { 213, 3 },
  { 146, 8 },
  { 146, 5 },
  { 214, 2 },
  { 214, 1 },
  { 216, 3 },
  { 216, 1 },
  { 215, 0 },
  { 215, 3 },
  { 208, 3 },
  { 208, 1 },
  { 174, 1 },
  { 174, 3 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 3 },
  { 174, 5 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 170, 1 },
  { 174, 1 },
  { 174, 1 },
  { 174, 4 },
  { 174, 4 },
  { 170, 1 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 174, 3 },
  { 217, 1 },
  { 217, 2 },
  { 218, 2 },
  { 218, 0 },
  { 174, 4 },
  { 174, 2 },
  { 174, 3 },
  { 174, 2 },
  { 174, 3 },
  { 174, 4 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 174, 2 },
  { 219, 1 },
  { 219, 2 },
  { 174, 5 },
  { 220, 1 },
  { 220, 2 },
  { 174, 5 },
  { 174, 3 },
  { 174, 5 },
  { 174, 4 },
  { 174, 4 },
  { 174, 5 },
  { 222, 5 },
  { 222, 4 },
  { 223, 2 },
  { 223, 0 },
  { 221, 1 },
  { 221, 0 },
  { 212, 3 },
  { 212, 1 },
  { 224, 1 },
  { 224, 0 },
  { 146, 11 },
  { 225, 1 },
  { 225, 0 },
  { 175, 0 },
  { 175, 3 },
  { 183, 5 },
  { 183, 3 },
  { 226, 1 },
  { 146, 3 },
  { 146, 1 },
  { 146, 2 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 5 },
  { 146, 6 },
  { 146, 3 },
  { 166, 2 },
  { 167, 2 },
  { 228, 1 },
  { 228, 1 },
  { 227, 1 },
  { 227, 0 },
  { 146, 5 },
  { 229, 10 },
  { 231, 1 },
  { 231, 1 },
  { 231, 2 },
  { 231, 0 },
  { 232, 1 },
  { 232, 1 },
  { 232, 1 },
  { 232, 3 },
  { 233, 0 },
  { 233, 3 },
  { 233, 3 },
  { 234, 0 },
  { 234, 2 },
  { 230, 3 },
  { 230, 0 },
  { 235, 6 },
  { 235, 8 },
  { 235, 5 },
  { 235, 4 },
  { 235, 1 },
  { 174, 4 },
  { 174, 6 },
  { 187, 1 },
  { 187, 1 },
  { 187, 1 },
  { 146, 3 },
  { 146, 6 },
  { 237, 0 },
  { 237, 2 },
  { 237, 2 },
  { 236, 1 },
  { 236, 0 },
  { 146, 3 },
  { 146, 1 },
  { 146, 3 },
  { 146, 6 },
  { 146, 6 },
  { 238, 1 },
  { 239, 0 },
  { 239, 1 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite3ParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<sizeof(yyRuleName)/sizeof(yyRuleName[0]) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

#ifndef NDEBUG
  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  */
  memset(&yygotominor, 0, sizeof(yygotominor));
#endif

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 3:
#line 84 "parse.y"
{ sqlite3FinishCoding(pParse); }
#line 1893 "parse.c"
        break;
      case 6:
#line 87 "parse.y"
{ sqlite3BeginParse(pParse, 0); }
#line 1898 "parse.c"
        break;
      case 7:
#line 89 "parse.y"
{ sqlite3BeginParse(pParse, 1); }
#line 1903 "parse.c"
        break;
      case 8:
#line 95 "parse.y"
{sqlite3BeginTransaction(pParse, yymsp[-1].minor.yy412);}
#line 1908 "parse.c"
        break;
      case 12:
#line 100 "parse.y"
{yygotominor.yy412 = TK_DEFERRED;}
#line 1913 "parse.c"
        break;
      case 13:
      case 14:
      case 15:
      case 101:
      case 103:
      case 104:
#line 101 "parse.y"
{yygotominor.yy412 = yymsp[0].major;}
#line 1923 "parse.c"
        break;
      case 16:
      case 17:
#line 104 "parse.y"
{sqlite3CommitTransaction(pParse);}
#line 1929 "parse.c"
        break;
      case 18:
#line 106 "parse.y"
{sqlite3RollbackTransaction(pParse);}
#line 1934 "parse.c"
        break;
      case 20:
#line 111 "parse.y"
{
   sqlite3StartTable(pParse,&yymsp[-4].minor.yy0,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy258,yymsp[-3].minor.yy412,0);
}
#line 1941 "parse.c"
        break;
      case 21:
      case 60:
      case 74:
      case 106:
      case 220:
      case 223:
#line 116 "parse.y"
{yygotominor.yy412 = 1;}
#line 1951 "parse.c"
        break;
      case 22:
      case 59:
      case 73:
      case 75:
      case 86:
      case 107:
      case 108:
      case 219:
      case 222:
#line 118 "parse.y"
{yygotominor.yy412 = 0;}
#line 1964 "parse.c"
        break;
      case 23:
#line 119 "parse.y"
{
  sqlite3EndTable(pParse,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy0,0);
}
#line 1971 "parse.c"
        break;
      case 24:
#line 122 "parse.y"
{
  sqlite3EndTable(pParse,0,0,yymsp[0].minor.yy459);
  sqlite3SelectDelete(yymsp[0].minor.yy459);
}
#line 1979 "parse.c"
        break;
      case 27:
#line 133 "parse.y"
{
  yygotominor.yy258.z = yymsp[-2].minor.yy258.z;
  yygotominor.yy258.n = (pParse->sLastToken.z-yymsp[-2].minor.yy258.z) + pParse->sLastToken.n;
}
#line 1987 "parse.c"
        break;
      case 28:
#line 137 "parse.y"
{
  sqlite3AddColumn(pParse,&yymsp[0].minor.yy258);
  yygotominor.yy258 = yymsp[0].minor.yy258;
}
#line 1995 "parse.c"
        break;
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 34:
      case 259:
      case 260:
#line 147 "parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy0;}
#line 2007 "parse.c"
        break;
      case 36:
#line 202 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[0].minor.yy258,&yymsp[0].minor.yy258);}
#line 2012 "parse.c"
        break;
      case 37:
#line 203 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-3].minor.yy258,&yymsp[0].minor.yy0);}
#line 2017 "parse.c"
        break;
      case 38:
#line 205 "parse.y"
{sqlite3AddColumnType(pParse,&yymsp[-5].minor.yy258,&yymsp[0].minor.yy0);}
#line 2022 "parse.c"
        break;
      case 39:
      case 114:
      case 115:
      case 126:
      case 146:
      case 247:
      case 257:
      case 258:
#line 207 "parse.y"
{yygotominor.yy258 = yymsp[0].minor.yy258;}
#line 2034 "parse.c"
        break;
      case 40:
#line 208 "parse.y"
{yygotominor.yy258.z=yymsp[-1].minor.yy258.z; yygotominor.yy258.n=yymsp[0].minor.yy258.n+(yymsp[0].minor.yy258.z-yymsp[-1].minor.yy258.z);}
#line 2039 "parse.c"
        break;
      case 41:
#line 210 "parse.y"
{ yygotominor.yy412 = atoi(yymsp[0].minor.yy258.z); }
#line 2044 "parse.c"
        break;
      case 42:
#line 211 "parse.y"
{ yygotominor.yy412 = -atoi(yymsp[0].minor.yy258.z); }
#line 2049 "parse.c"
        break;
      case 47:
      case 48:
#line 216 "parse.y"
{sqlite3AddDefaultValue(pParse,yymsp[0].minor.yy2);}
#line 2055 "parse.c"
        break;
      case 49:
#line 218 "parse.y"
{
  Expr *p = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy2, 0, 0);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2063 "parse.c"
        break;
      case 50:
#line 222 "parse.y"
{
  Expr *p = sqlite3Expr(TK_STRING, 0, 0, &yymsp[0].minor.yy258);
  sqlite3AddDefaultValue(pParse,p);
}
#line 2071 "parse.c"
        break;
      case 52:
#line 231 "parse.y"
{sqlite3AddNotNull(pParse, yymsp[0].minor.yy412);}
#line 2076 "parse.c"
        break;
      case 53:
#line 233 "parse.y"
{sqlite3AddPrimaryKey(pParse,0,yymsp[-1].minor.yy412,yymsp[0].minor.yy412);}
#line 2081 "parse.c"
        break;
      case 54:
#line 234 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,0,yymsp[0].minor.yy412,0,0);}
#line 2086 "parse.c"
        break;
      case 55:
#line 235 "parse.y"
{sqlite3ExprDelete(yymsp[-2].minor.yy2);}
#line 2091 "parse.c"
        break;
      case 56:
#line 237 "parse.y"
{sqlite3CreateForeignKey(pParse,0,&yymsp[-2].minor.yy258,yymsp[-1].minor.yy82,yymsp[0].minor.yy412);}
#line 2096 "parse.c"
        break;
      case 57:
#line 238 "parse.y"
{sqlite3DeferForeignKey(pParse,yymsp[0].minor.yy412);}
#line 2101 "parse.c"
        break;
      case 58:
#line 239 "parse.y"
{sqlite3AddCollateType(pParse, yymsp[0].minor.yy258.z, yymsp[0].minor.yy258.n);}
#line 2106 "parse.c"
        break;
      case 61:
#line 252 "parse.y"
{ yygotominor.yy412 = OE_Restrict * 0x010101; }
#line 2111 "parse.c"
        break;
      case 62:
#line 253 "parse.y"
{ yygotominor.yy412 = (yymsp[-1].minor.yy412 & yymsp[0].minor.yy47.mask) | yymsp[0].minor.yy47.value; }
#line 2116 "parse.c"
        break;
      case 63:
#line 255 "parse.y"
{ yygotominor.yy47.value = 0;     yygotominor.yy47.mask = 0x000000; }
#line 2121 "parse.c"
        break;
      case 64:
#line 256 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy412;     yygotominor.yy47.mask = 0x0000ff; }
#line 2126 "parse.c"
        break;
      case 65:
#line 257 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy412<<8;  yygotominor.yy47.mask = 0x00ff00; }
#line 2131 "parse.c"
        break;
      case 66:
#line 258 "parse.y"
{ yygotominor.yy47.value = yymsp[0].minor.yy412<<16; yygotominor.yy47.mask = 0xff0000; }
#line 2136 "parse.c"
        break;
      case 67:
#line 260 "parse.y"
{ yygotominor.yy412 = OE_SetNull; }
#line 2141 "parse.c"
        break;
      case 68:
#line 261 "parse.y"
{ yygotominor.yy412 = OE_SetDflt; }
#line 2146 "parse.c"
        break;
      case 69:
#line 262 "parse.y"
{ yygotominor.yy412 = OE_Cascade; }
#line 2151 "parse.c"
        break;
      case 70:
#line 263 "parse.y"
{ yygotominor.yy412 = OE_Restrict; }
#line 2156 "parse.c"
        break;
      case 71:
      case 72:
      case 87:
      case 89:
      case 91:
      case 92:
      case 163:
#line 265 "parse.y"
{yygotominor.yy412 = yymsp[0].minor.yy412;}
#line 2167 "parse.c"
        break;
      case 76:
#line 275 "parse.y"
{yygotominor.yy258.n = 0; yygotominor.yy258.z = 0;}
#line 2172 "parse.c"
        break;
      case 77:
#line 276 "parse.y"
{yygotominor.yy258 = yymsp[-1].minor.yy0;}
#line 2177 "parse.c"
        break;
      case 82:
#line 282 "parse.y"
{sqlite3AddPrimaryKey(pParse,yymsp[-3].minor.yy82,yymsp[0].minor.yy412,yymsp[-2].minor.yy412);}
#line 2182 "parse.c"
        break;
      case 83:
#line 284 "parse.y"
{sqlite3CreateIndex(pParse,0,0,0,yymsp[-2].minor.yy82,yymsp[0].minor.yy412,0,0);}
#line 2187 "parse.c"
        break;
      case 85:
#line 287 "parse.y"
{
    sqlite3CreateForeignKey(pParse, yymsp[-6].minor.yy82, &yymsp[-3].minor.yy258, yymsp[-2].minor.yy82, yymsp[-1].minor.yy412);
    sqlite3DeferForeignKey(pParse, yymsp[0].minor.yy412);
}
#line 2195 "parse.c"
        break;
      case 88:
      case 90:
#line 301 "parse.y"
{yygotominor.yy412 = OE_Default;}
#line 2201 "parse.c"
        break;
      case 93:
#line 306 "parse.y"
{yygotominor.yy412 = OE_Ignore;}
#line 2206 "parse.c"
        break;
      case 94:
      case 164:
#line 307 "parse.y"
{yygotominor.yy412 = OE_Replace;}
#line 2212 "parse.c"
        break;
      case 95:
#line 311 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy67, 0);
}
#line 2219 "parse.c"
        break;
      case 96:
#line 318 "parse.y"
{
  sqlite3CreateView(pParse, &yymsp[-6].minor.yy0, &yymsp[-3].minor.yy258, &yymsp[-2].minor.yy258, yymsp[0].minor.yy459, yymsp[-5].minor.yy412);
}
#line 2226 "parse.c"
        break;
      case 97:
#line 321 "parse.y"
{
  sqlite3DropTable(pParse, yymsp[0].minor.yy67, 1);
}
#line 2233 "parse.c"
        break;
      case 98:
#line 328 "parse.y"
{
  sqlite3Select(pParse, yymsp[0].minor.yy459, SRT_Callback, 0, 0, 0, 0, 0);
  sqlite3SelectDelete(yymsp[0].minor.yy459);
}
#line 2241 "parse.c"
        break;
      case 99:
      case 123:
#line 338 "parse.y"
{yygotominor.yy459 = yymsp[0].minor.yy459;}
#line 2247 "parse.c"
        break;
      case 100:
#line 340 "parse.y"
{
  if( yymsp[0].minor.yy459 ){
    yymsp[0].minor.yy459->op = yymsp[-1].minor.yy412;
    yymsp[0].minor.yy459->pPrior = yymsp[-2].minor.yy459;
  }
  yygotominor.yy459 = yymsp[0].minor.yy459;
}
#line 2258 "parse.c"
        break;
      case 102:
#line 349 "parse.y"
{yygotominor.yy412 = TK_ALL;}
#line 2263 "parse.c"
        break;
      case 105:
#line 354 "parse.y"
{
  yygotominor.yy459 = sqlite3SelectNew(yymsp[-6].minor.yy82,yymsp[-5].minor.yy67,yymsp[-4].minor.yy2,yymsp[-3].minor.yy82,yymsp[-2].minor.yy2,yymsp[-1].minor.yy82,yymsp[-7].minor.yy412,yymsp[0].minor.yy244.pLimit,yymsp[0].minor.yy244.pOffset);
}
#line 2270 "parse.c"
        break;
      case 109:
      case 244:
#line 375 "parse.y"
{yygotominor.yy82 = yymsp[-1].minor.yy82;}
#line 2276 "parse.c"
        break;
      case 110:
      case 137:
      case 147:
      case 243:
#line 376 "parse.y"
{yygotominor.yy82 = 0;}
#line 2284 "parse.c"
        break;
      case 111:
#line 377 "parse.y"
{
   yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-2].minor.yy82,yymsp[-1].minor.yy2,yymsp[0].minor.yy258.n?&yymsp[0].minor.yy258:0);
}
#line 2291 "parse.c"
        break;
      case 112:
#line 380 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-1].minor.yy82, sqlite3Expr(TK_ALL, 0, 0, 0), 0);
}
#line 2298 "parse.c"
        break;
      case 113:
#line 383 "parse.y"
{
  Expr *pRight = sqlite3Expr(TK_ALL, 0, 0, 0);
  Expr *pLeft = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy258);
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-3].minor.yy82, sqlite3Expr(TK_DOT, pLeft, pRight, 0), 0);
}
#line 2307 "parse.c"
        break;
      case 116:
#line 395 "parse.y"
{yygotominor.yy258.n = 0;}
#line 2312 "parse.c"
        break;
      case 117:
#line 407 "parse.y"
{yygotominor.yy67 = sqliteMalloc(sizeof(*yygotominor.yy67));}
#line 2317 "parse.c"
        break;
      case 118:
#line 408 "parse.y"
{yygotominor.yy67 = yymsp[0].minor.yy67;}
#line 2322 "parse.c"
        break;
      case 119:
#line 413 "parse.y"
{
   yygotominor.yy67 = yymsp[-1].minor.yy67;
   if( yygotominor.yy67 && yygotominor.yy67->nSrc>0 ) yygotominor.yy67->a[yygotominor.yy67->nSrc-1].jointype = yymsp[0].minor.yy412;
}
#line 2330 "parse.c"
        break;
      case 120:
#line 417 "parse.y"
{yygotominor.yy67 = 0;}
#line 2335 "parse.c"
        break;
      case 121:
#line 418 "parse.y"
{
  yygotominor.yy67 = sqlite3SrcListAppend(yymsp[-5].minor.yy67,&yymsp[-4].minor.yy258,&yymsp[-3].minor.yy258);
  if( yymsp[-2].minor.yy258.n ) sqlite3SrcListAddAlias(yygotominor.yy67,&yymsp[-2].minor.yy258);
  if( yymsp[-1].minor.yy2 ){
    if( yygotominor.yy67 && yygotominor.yy67->nSrc>1 ){ yygotominor.yy67->a[yygotominor.yy67->nSrc-2].pOn = yymsp[-1].minor.yy2; }
    else { sqlite3ExprDelete(yymsp[-1].minor.yy2); }
  }
  if( yymsp[0].minor.yy240 ){
    if( yygotominor.yy67 && yygotominor.yy67->nSrc>1 ){ yygotominor.yy67->a[yygotominor.yy67->nSrc-2].pUsing = yymsp[0].minor.yy240; }
    else { sqlite3IdListDelete(yymsp[0].minor.yy240); }
  }
}
#line 2351 "parse.c"
        break;
      case 122:
#line 432 "parse.y"
{
    yygotominor.yy67 = sqlite3SrcListAppend(yymsp[-6].minor.yy67,0,0);
    yygotominor.yy67->a[yygotominor.yy67->nSrc-1].pSelect = yymsp[-4].minor.yy459;
    if( yymsp[-2].minor.yy258.n ) sqlite3SrcListAddAlias(yygotominor.yy67,&yymsp[-2].minor.yy258);
    if( yymsp[-1].minor.yy2 ){
      if( yygotominor.yy67 && yygotominor.yy67->nSrc>1 ){ yygotominor.yy67->a[yygotominor.yy67->nSrc-2].pOn = yymsp[-1].minor.yy2; }
      else { sqlite3ExprDelete(yymsp[-1].minor.yy2); }
    }
    if( yymsp[0].minor.yy240 ){
      if( yygotominor.yy67 && yygotominor.yy67->nSrc>1 ){ yygotominor.yy67->a[yygotominor.yy67->nSrc-2].pUsing = yymsp[0].minor.yy240; }
      else { sqlite3IdListDelete(yymsp[0].minor.yy240); }
    }
  }
#line 2368 "parse.c"
        break;
      case 124:
#line 453 "parse.y"
{
     yygotominor.yy459 = sqlite3SelectNew(0,yymsp[0].minor.yy67,0,0,0,0,0,0,0);
  }
#line 2375 "parse.c"
        break;
      case 125:
#line 459 "parse.y"
{yygotominor.yy258.z=0; yygotominor.yy258.n=0;}
#line 2380 "parse.c"
        break;
      case 127:
#line 464 "parse.y"
{yygotominor.yy67 = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy258);}
#line 2385 "parse.c"
        break;
      case 128:
      case 129:
#line 468 "parse.y"
{ yygotominor.yy412 = JT_INNER; }
#line 2391 "parse.c"
        break;
      case 130:
#line 470 "parse.y"
{ yygotominor.yy412 = sqlite3JoinType(pParse,&yymsp[-1].minor.yy0,0,0); }
#line 2396 "parse.c"
        break;
      case 131:
#line 471 "parse.y"
{ yygotominor.yy412 = sqlite3JoinType(pParse,&yymsp[-2].minor.yy0,&yymsp[-1].minor.yy258,0); }
#line 2401 "parse.c"
        break;
      case 132:
#line 473 "parse.y"
{ yygotominor.yy412 = sqlite3JoinType(pParse,&yymsp[-3].minor.yy0,&yymsp[-2].minor.yy258,&yymsp[-1].minor.yy258); }
#line 2406 "parse.c"
        break;
      case 133:
      case 141:
      case 150:
      case 157:
      case 171:
      case 207:
      case 232:
      case 234:
      case 238:
#line 477 "parse.y"
{yygotominor.yy2 = yymsp[0].minor.yy2;}
#line 2419 "parse.c"
        break;
      case 134:
      case 149:
      case 156:
      case 208:
      case 233:
      case 235:
      case 239:
#line 478 "parse.y"
{yygotominor.yy2 = 0;}
#line 2430 "parse.c"
        break;
      case 135:
      case 168:
#line 482 "parse.y"
{yygotominor.yy240 = yymsp[-1].minor.yy240;}
#line 2436 "parse.c"
        break;
      case 136:
      case 167:
#line 483 "parse.y"
{yygotominor.yy240 = 0;}
#line 2442 "parse.c"
        break;
      case 138:
      case 148:
#line 494 "parse.y"
{yygotominor.yy82 = yymsp[0].minor.yy82;}
#line 2448 "parse.c"
        break;
      case 139:
#line 495 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-4].minor.yy82,yymsp[-2].minor.yy2,yymsp[-1].minor.yy258.n>0?&yymsp[-1].minor.yy258:0);
  if( yygotominor.yy82 ) yygotominor.yy82->a[yygotominor.yy82->nExpr-1].sortOrder = yymsp[0].minor.yy412;
}
#line 2456 "parse.c"
        break;
      case 140:
#line 499 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(0,yymsp[-2].minor.yy2,yymsp[-1].minor.yy258.n>0?&yymsp[-1].minor.yy258:0);
  if( yygotominor.yy82 && yygotominor.yy82->a ) yygotominor.yy82->a[0].sortOrder = yymsp[0].minor.yy412;
}
#line 2464 "parse.c"
        break;
      case 142:
      case 144:
#line 508 "parse.y"
{yygotominor.yy412 = SQLITE_SO_ASC;}
#line 2470 "parse.c"
        break;
      case 143:
#line 509 "parse.y"
{yygotominor.yy412 = SQLITE_SO_DESC;}
#line 2475 "parse.c"
        break;
      case 145:
#line 511 "parse.y"
{yygotominor.yy258.z = 0; yygotominor.yy258.n = 0;}
#line 2480 "parse.c"
        break;
      case 151:
#line 529 "parse.y"
{yygotominor.yy244.pLimit = 0; yygotominor.yy244.pOffset = 0;}
#line 2485 "parse.c"
        break;
      case 152:
#line 530 "parse.y"
{yygotominor.yy244.pLimit = yymsp[0].minor.yy2; yygotominor.yy244.pOffset = 0;}
#line 2490 "parse.c"
        break;
      case 153:
#line 532 "parse.y"
{yygotominor.yy244.pLimit = yymsp[-2].minor.yy2; yygotominor.yy244.pOffset = yymsp[0].minor.yy2;}
#line 2495 "parse.c"
        break;
      case 154:
#line 534 "parse.y"
{yygotominor.yy244.pOffset = yymsp[-2].minor.yy2; yygotominor.yy244.pLimit = yymsp[0].minor.yy2;}
#line 2500 "parse.c"
        break;
      case 155:
#line 538 "parse.y"
{sqlite3DeleteFrom(pParse,yymsp[-1].minor.yy67,yymsp[0].minor.yy2);}
#line 2505 "parse.c"
        break;
      case 158:
#line 549 "parse.y"
{sqlite3Update(pParse,yymsp[-3].minor.yy67,yymsp[-1].minor.yy82,yymsp[0].minor.yy2,yymsp[-4].minor.yy412);}
#line 2510 "parse.c"
        break;
      case 159:
#line 555 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-4].minor.yy82,yymsp[0].minor.yy2,&yymsp[-2].minor.yy258);}
#line 2515 "parse.c"
        break;
      case 160:
#line 556 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(0,yymsp[0].minor.yy2,&yymsp[-2].minor.yy258);}
#line 2520 "parse.c"
        break;
      case 161:
#line 562 "parse.y"
{sqlite3Insert(pParse, yymsp[-5].minor.yy67, yymsp[-1].minor.yy82, 0, yymsp[-4].minor.yy240, yymsp[-7].minor.yy412);}
#line 2525 "parse.c"
        break;
      case 162:
#line 564 "parse.y"
{sqlite3Insert(pParse, yymsp[-2].minor.yy67, 0, yymsp[0].minor.yy459, yymsp[-1].minor.yy240, yymsp[-4].minor.yy412);}
#line 2530 "parse.c"
        break;
      case 165:
      case 236:
#line 574 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-2].minor.yy82,yymsp[0].minor.yy2,0);}
#line 2536 "parse.c"
        break;
      case 166:
      case 237:
#line 575 "parse.y"
{yygotominor.yy82 = sqlite3ExprListAppend(0,yymsp[0].minor.yy2,0);}
#line 2542 "parse.c"
        break;
      case 169:
#line 584 "parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(yymsp[-2].minor.yy240,&yymsp[0].minor.yy258);}
#line 2547 "parse.c"
        break;
      case 170:
#line 585 "parse.y"
{yygotominor.yy240 = sqlite3IdListAppend(0,&yymsp[0].minor.yy258);}
#line 2552 "parse.c"
        break;
      case 172:
#line 596 "parse.y"
{yygotominor.yy2 = yymsp[-1].minor.yy2; sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0); }
#line 2557 "parse.c"
        break;
      case 173:
      case 178:
      case 179:
      case 180:
      case 181:
#line 597 "parse.y"
{yygotominor.yy2 = sqlite3Expr(yymsp[0].major, 0, 0, &yymsp[0].minor.yy0);}
#line 2566 "parse.c"
        break;
      case 174:
      case 175:
#line 598 "parse.y"
{yygotominor.yy2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy0);}
#line 2572 "parse.c"
        break;
      case 176:
#line 600 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy258);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy258);
  yygotominor.yy2 = sqlite3Expr(TK_DOT, temp1, temp2, 0);
}
#line 2581 "parse.c"
        break;
      case 177:
#line 605 "parse.y"
{
  Expr *temp1 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-4].minor.yy258);
  Expr *temp2 = sqlite3Expr(TK_ID, 0, 0, &yymsp[-2].minor.yy258);
  Expr *temp3 = sqlite3Expr(TK_ID, 0, 0, &yymsp[0].minor.yy258);
  Expr *temp4 = sqlite3Expr(TK_DOT, temp2, temp3, 0);
  yygotominor.yy2 = sqlite3Expr(TK_DOT, temp1, temp4, 0);
}
#line 2592 "parse.c"
        break;
      case 182:
#line 616 "parse.y"
{yygotominor.yy2 = sqlite3RegisterExpr(pParse, &yymsp[0].minor.yy0);}
#line 2597 "parse.c"
        break;
      case 183:
#line 617 "parse.y"
{
  Token *pToken = &yymsp[0].minor.yy0;
  Expr *pExpr = yygotominor.yy2 = sqlite3Expr(TK_VARIABLE, 0, 0, pToken);
  sqlite3ExprAssignVarNumber(pParse, pExpr);
}
#line 2606 "parse.c"
        break;
      case 184:
#line 622 "parse.y"
{
  yygotominor.yy2 = sqlite3ExprFunction(yymsp[-1].minor.yy82, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2614 "parse.c"
        break;
      case 185:
#line 626 "parse.y"
{
  yygotominor.yy2 = sqlite3ExprFunction(0, &yymsp[-3].minor.yy0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
}
#line 2622 "parse.c"
        break;
      case 186:
#line 630 "parse.y"
{
  /* The CURRENT_TIME, CURRENT_DATE, and CURRENT_TIMESTAMP values are
  ** treated as functions that return constants */
  yygotominor.yy2 = sqlite3ExprFunction(0,&yymsp[0].minor.yy0);
  if( yygotominor.yy2 ) yygotominor.yy2->op = TK_CONST_FUNC;  
}
#line 2632 "parse.c"
        break;
      case 187:
      case 188:
      case 189:
      case 190:
      case 191:
      case 192:
      case 193:
      case 194:
      case 195:
      case 196:
      case 197:
      case 198:
      case 199:
      case 200:
      case 201:
      case 202:
      case 203:
      case 204:
#line 636 "parse.y"
{yygotominor.yy2 = sqlite3Expr(yymsp[-1].major, yymsp[-2].minor.yy2, yymsp[0].minor.yy2, 0);}
#line 2654 "parse.c"
        break;
      case 205:
#line 655 "parse.y"
{yygotominor.yy438.operator = yymsp[0].minor.yy0; yygotominor.yy438.not = 0;}
#line 2659 "parse.c"
        break;
      case 206:
#line 656 "parse.y"
{yygotominor.yy438.operator = yymsp[0].minor.yy0; yygotominor.yy438.not = 1;}
#line 2664 "parse.c"
        break;
      case 209:
#line 660 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-1].minor.yy2, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[-3].minor.yy2, 0);
  if( yymsp[0].minor.yy2 ){
    pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy2, 0);
  }
  yygotominor.yy2 = sqlite3ExprFunction(pList, &yymsp[-2].minor.yy438.operator);
  if( yymsp[-2].minor.yy438.not ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-3].minor.yy2->span, &yymsp[-1].minor.yy2->span);
}
#line 2678 "parse.c"
        break;
      case 210:
#line 671 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_ISNULL, yymsp[-1].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2686 "parse.c"
        break;
      case 211:
#line 675 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_ISNULL, yymsp[-2].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2694 "parse.c"
        break;
      case 212:
#line 679 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_NOTNULL, yymsp[-1].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2702 "parse.c"
        break;
      case 213:
#line 683 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_NOTNULL, yymsp[-2].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2710 "parse.c"
        break;
      case 214:
#line 687 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_NOTNULL, yymsp[-3].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy2->span,&yymsp[0].minor.yy0);
}
#line 2718 "parse.c"
        break;
      case 215:
      case 216:
#line 691 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(yymsp[-1].major, yymsp[0].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy2->span);
}
#line 2727 "parse.c"
        break;
      case 217:
#line 699 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_UMINUS, yymsp[0].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy2->span);
}
#line 2735 "parse.c"
        break;
      case 218:
#line 703 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_UPLUS, yymsp[0].minor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-1].minor.yy0,&yymsp[0].minor.yy2->span);
}
#line 2743 "parse.c"
        break;
      case 221:
#line 710 "parse.y"
{
  ExprList *pList = sqlite3ExprListAppend(0, yymsp[-2].minor.yy2, 0);
  pList = sqlite3ExprListAppend(pList, yymsp[0].minor.yy2, 0);
  yygotominor.yy2 = sqlite3Expr(TK_BETWEEN, yymsp[-4].minor.yy2, 0, 0);
  if( yygotominor.yy2 ) yygotominor.yy2->pList = pList;
  if( yymsp[-3].minor.yy412 ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
  sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy2->span,&yymsp[0].minor.yy2->span);
}
#line 2755 "parse.c"
        break;
      case 224:
#line 722 "parse.y"
{
    yygotominor.yy2 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy2, 0, 0);
    if( yygotominor.yy2 ){
      yygotominor.yy2->pList = yymsp[-1].minor.yy82;
    }else{
      sqlite3ExprListDelete(yymsp[-1].minor.yy82);
    }
    if( yymsp[-3].minor.yy412 ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy2->span,&yymsp[0].minor.yy0);
  }
#line 2769 "parse.c"
        break;
      case 225:
#line 732 "parse.y"
{
    yygotominor.yy2 = sqlite3Expr(TK_SELECT, 0, 0, 0);
    if( yygotominor.yy2 ) yygotominor.yy2->pSelect = yymsp[-1].minor.yy459;
    if( !yygotominor.yy2 ) sqlite3SelectDelete(yymsp[-1].minor.yy459);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-2].minor.yy0,&yymsp[0].minor.yy0);
  }
#line 2779 "parse.c"
        break;
      case 226:
#line 738 "parse.y"
{
    yygotominor.yy2 = sqlite3Expr(TK_IN, yymsp[-4].minor.yy2, 0, 0);
    if( yygotominor.yy2 ) yygotominor.yy2->pSelect = yymsp[-1].minor.yy459;
    if( !yygotominor.yy2 ) sqlite3SelectDelete(yymsp[-1].minor.yy459);
    if( yymsp[-3].minor.yy412 ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-4].minor.yy2->span,&yymsp[0].minor.yy0);
  }
#line 2790 "parse.c"
        break;
      case 227:
#line 745 "parse.y"
{
    SrcList *pSrc = sqlite3SrcListAppend(0,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy258);
    yygotominor.yy2 = sqlite3Expr(TK_IN, yymsp[-3].minor.yy2, 0, 0);
    if( yygotominor.yy2 ) yygotominor.yy2->pSelect = sqlite3SelectNew(0,pSrc,0,0,0,0,0,0,0);
    if( yymsp[-2].minor.yy412 ) yygotominor.yy2 = sqlite3Expr(TK_NOT, yygotominor.yy2, 0, 0);
    sqlite3ExprSpan(yygotominor.yy2,&yymsp[-3].minor.yy2->span,yymsp[0].minor.yy258.z?&yymsp[0].minor.yy258:&yymsp[-1].minor.yy258);
  }
#line 2801 "parse.c"
        break;
      case 228:
#line 752 "parse.y"
{
    Expr *p = yygotominor.yy2 = sqlite3Expr(TK_EXISTS, 0, 0, 0);
    if( p ){
      p->pSelect = yymsp[-1].minor.yy459;
      sqlite3ExprSpan(p,&yymsp[-3].minor.yy0,&yymsp[0].minor.yy0);
    }
    if( !p ) sqlite3SelectDelete(yymsp[-1].minor.yy459);
  }
#line 2813 "parse.c"
        break;
      case 229:
#line 763 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_CASE, yymsp[-3].minor.yy2, yymsp[-1].minor.yy2, 0);
  if( yygotominor.yy2 ) yygotominor.yy2->pList = yymsp[-2].minor.yy82;
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0);
}
#line 2822 "parse.c"
        break;
      case 230:
#line 770 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-4].minor.yy82, yymsp[-2].minor.yy2, 0);
  yygotominor.yy82 = sqlite3ExprListAppend(yygotominor.yy82, yymsp[0].minor.yy2, 0);
}
#line 2830 "parse.c"
        break;
      case 231:
#line 774 "parse.y"
{
  yygotominor.yy82 = sqlite3ExprListAppend(0, yymsp[-2].minor.yy2, 0);
  yygotominor.yy82 = sqlite3ExprListAppend(yygotominor.yy82, yymsp[0].minor.yy2, 0);
}
#line 2838 "parse.c"
        break;
      case 240:
#line 799 "parse.y"
{
  if( yymsp[-9].minor.yy412!=OE_None ) yymsp[-9].minor.yy412 = yymsp[0].minor.yy412;
  if( yymsp[-9].minor.yy412==OE_Default) yymsp[-9].minor.yy412 = OE_Abort;
  sqlite3CreateIndex(pParse, &yymsp[-7].minor.yy258, &yymsp[-6].minor.yy258, sqlite3SrcListAppend(0,&yymsp[-4].minor.yy258,0),yymsp[-2].minor.yy82,yymsp[-9].minor.yy412, &yymsp[-10].minor.yy0, &yymsp[-1].minor.yy0);
}
#line 2847 "parse.c"
        break;
      case 241:
      case 288:
#line 806 "parse.y"
{yygotominor.yy412 = OE_Abort;}
#line 2853 "parse.c"
        break;
      case 242:
#line 807 "parse.y"
{yygotominor.yy412 = OE_None;}
#line 2858 "parse.c"
        break;
      case 245:
#line 817 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy258.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy258.z, yymsp[-1].minor.yy258.n);
  }
  yygotominor.yy82 = sqlite3ExprListAppend(yymsp[-4].minor.yy82, p, &yymsp[-2].minor.yy258);
}
#line 2870 "parse.c"
        break;
      case 246:
#line 825 "parse.y"
{
  Expr *p = 0;
  if( yymsp[-1].minor.yy258.n>0 ){
    p = sqlite3Expr(TK_COLUMN, 0, 0, 0);
    if( p ) p->pColl = sqlite3LocateCollSeq(pParse, yymsp[-1].minor.yy258.z, yymsp[-1].minor.yy258.n);
  }
  yygotominor.yy82 = sqlite3ExprListAppend(0, p, &yymsp[-2].minor.yy258);
}
#line 2882 "parse.c"
        break;
      case 248:
#line 838 "parse.y"
{sqlite3DropIndex(pParse, yymsp[0].minor.yy67);}
#line 2887 "parse.c"
        break;
      case 249:
      case 250:
#line 842 "parse.y"
{sqlite3Vacuum(pParse,0);}
#line 2893 "parse.c"
        break;
      case 251:
      case 253:
#line 848 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy258,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy258,0);}
#line 2899 "parse.c"
        break;
      case 252:
#line 849 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-3].minor.yy258,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy0,0);}
#line 2904 "parse.c"
        break;
      case 254:
#line 851 "parse.y"
{
  sqlite3Pragma(pParse,&yymsp[-3].minor.yy258,&yymsp[-2].minor.yy258,&yymsp[0].minor.yy258,1);
}
#line 2911 "parse.c"
        break;
      case 255:
#line 854 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-4].minor.yy258,&yymsp[-3].minor.yy258,&yymsp[-1].minor.yy258,0);}
#line 2916 "parse.c"
        break;
      case 256:
#line 855 "parse.y"
{sqlite3Pragma(pParse,&yymsp[-1].minor.yy258,&yymsp[0].minor.yy258,0,0);}
#line 2921 "parse.c"
        break;
      case 263:
#line 868 "parse.y"
{
  Token all;
  all.z = yymsp[-3].minor.yy258.z;
  all.n = (yymsp[0].minor.yy0.z - yymsp[-3].minor.yy258.z) + yymsp[0].minor.yy0.n;
  sqlite3FinishTrigger(pParse, yymsp[-1].minor.yy347, &all);
}
#line 2931 "parse.c"
        break;
      case 264:
#line 877 "parse.y"
{
  sqlite3BeginTrigger(pParse, &yymsp[-7].minor.yy258, &yymsp[-6].minor.yy258, yymsp[-5].minor.yy412, yymsp[-4].minor.yy210.a, yymsp[-4].minor.yy210.b, yymsp[-2].minor.yy67, yymsp[-1].minor.yy412, yymsp[0].minor.yy2, yymsp[-9].minor.yy412);
  yygotominor.yy258 = (yymsp[-6].minor.yy258.n==0?yymsp[-7].minor.yy258:yymsp[-6].minor.yy258);
}
#line 2939 "parse.c"
        break;
      case 265:
      case 268:
#line 883 "parse.y"
{ yygotominor.yy412 = TK_BEFORE; }
#line 2945 "parse.c"
        break;
      case 266:
#line 884 "parse.y"
{ yygotominor.yy412 = TK_AFTER;  }
#line 2950 "parse.c"
        break;
      case 267:
#line 885 "parse.y"
{ yygotominor.yy412 = TK_INSTEAD;}
#line 2955 "parse.c"
        break;
      case 269:
      case 270:
      case 271:
#line 890 "parse.y"
{yygotominor.yy210.a = yymsp[0].major; yygotominor.yy210.b = 0;}
#line 2962 "parse.c"
        break;
      case 272:
#line 893 "parse.y"
{yygotominor.yy210.a = TK_UPDATE; yygotominor.yy210.b = yymsp[0].minor.yy240;}
#line 2967 "parse.c"
        break;
      case 273:
      case 274:
#line 896 "parse.y"
{ yygotominor.yy412 = TK_ROW; }
#line 2973 "parse.c"
        break;
      case 275:
#line 898 "parse.y"
{ yygotominor.yy412 = TK_STATEMENT; }
#line 2978 "parse.c"
        break;
      case 276:
#line 901 "parse.y"
{ yygotominor.yy2 = 0; }
#line 2983 "parse.c"
        break;
      case 277:
#line 902 "parse.y"
{ yygotominor.yy2 = yymsp[0].minor.yy2; }
#line 2988 "parse.c"
        break;
      case 278:
#line 906 "parse.y"
{
  yymsp[-2].minor.yy347->pNext = yymsp[0].minor.yy347;
  yygotominor.yy347 = yymsp[-2].minor.yy347;
}
#line 2996 "parse.c"
        break;
      case 279:
#line 910 "parse.y"
{ yygotominor.yy347 = 0; }
#line 3001 "parse.c"
        break;
      case 280:
#line 916 "parse.y"
{ yygotominor.yy347 = sqlite3TriggerUpdateStep(&yymsp[-3].minor.yy258, yymsp[-1].minor.yy82, yymsp[0].minor.yy2, yymsp[-4].minor.yy412); }
#line 3006 "parse.c"
        break;
      case 281:
#line 921 "parse.y"
{yygotominor.yy347 = sqlite3TriggerInsertStep(&yymsp[-5].minor.yy258, yymsp[-4].minor.yy240, yymsp[-1].minor.yy82, 0, yymsp[-7].minor.yy412);}
#line 3011 "parse.c"
        break;
      case 282:
#line 924 "parse.y"
{yygotominor.yy347 = sqlite3TriggerInsertStep(&yymsp[-2].minor.yy258, yymsp[-1].minor.yy240, 0, yymsp[0].minor.yy459, yymsp[-4].minor.yy412);}
#line 3016 "parse.c"
        break;
      case 283:
#line 928 "parse.y"
{yygotominor.yy347 = sqlite3TriggerDeleteStep(&yymsp[-1].minor.yy258, yymsp[0].minor.yy2);}
#line 3021 "parse.c"
        break;
      case 284:
#line 931 "parse.y"
{yygotominor.yy347 = sqlite3TriggerSelectStep(yymsp[0].minor.yy459); }
#line 3026 "parse.c"
        break;
      case 285:
#line 934 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_RAISE, 0, 0, 0); 
  yygotominor.yy2->iColumn = OE_Ignore;
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3035 "parse.c"
        break;
      case 286:
#line 939 "parse.y"
{
  yygotominor.yy2 = sqlite3Expr(TK_RAISE, 0, 0, &yymsp[-1].minor.yy258); 
  yygotominor.yy2->iColumn = yymsp[-3].minor.yy412;
  sqlite3ExprSpan(yygotominor.yy2, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0);
}
#line 3044 "parse.c"
        break;
      case 287:
#line 947 "parse.y"
{yygotominor.yy412 = OE_Rollback;}
#line 3049 "parse.c"
        break;
      case 289:
#line 949 "parse.y"
{yygotominor.yy412 = OE_Fail;}
#line 3054 "parse.c"
        break;
      case 290:
#line 954 "parse.y"
{
  sqlite3DropTrigger(pParse,yymsp[0].minor.yy67);
}
#line 3061 "parse.c"
        break;
      case 291:
#line 960 "parse.y"
{
  sqlite3Attach(pParse, &yymsp[-3].minor.yy258, &yymsp[-1].minor.yy258, yymsp[0].minor.yy132.type, &yymsp[0].minor.yy132.key);
}
#line 3068 "parse.c"
        break;
      case 292:
#line 964 "parse.y"
{ yygotominor.yy132.type = 0; }
#line 3073 "parse.c"
        break;
      case 293:
#line 965 "parse.y"
{ yygotominor.yy132.type=1; yygotominor.yy132.key = yymsp[0].minor.yy258; }
#line 3078 "parse.c"
        break;
      case 294:
#line 966 "parse.y"
{ yygotominor.yy132.type=2; yygotominor.yy132.key = yymsp[0].minor.yy0; }
#line 3083 "parse.c"
        break;
      case 297:
#line 972 "parse.y"
{
  sqlite3Detach(pParse, &yymsp[0].minor.yy258);
}
#line 3090 "parse.c"
        break;
      case 298:
#line 978 "parse.y"
{sqlite3Reindex(pParse, 0, 0);}
#line 3095 "parse.c"
        break;
      case 299:
#line 979 "parse.y"
{sqlite3Reindex(pParse, &yymsp[-1].minor.yy258, &yymsp[0].minor.yy258);}
#line 3100 "parse.c"
        break;
      case 300:
#line 984 "parse.y"
{
  sqlite3AlterRenameTable(pParse,yymsp[-3].minor.yy67,&yymsp[0].minor.yy258);
}
#line 3107 "parse.c"
        break;
      case 301:
#line 987 "parse.y"
{
  sqlite3AlterFinishAddColumn(pParse, &yymsp[0].minor.yy258);
}
#line 3114 "parse.c"
        break;
      case 302:
#line 990 "parse.y"
{
  sqlite3AlterBeginAddColumn(pParse, yymsp[0].minor.yy67);
}
#line 3121 "parse.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite3ParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 23 "parse.y"

  if( pParse->zErrMsg==0 ){
    if( TOKEN.z[0] ){
      sqlite3ErrorMsg(pParse, "near \"%T\": syntax error", &TOKEN);
    }else{
      sqlite3ErrorMsg(pParse, "incomplete SQL statement");
    }
  }
#line 3188 "parse.c"
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite3ParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite3ParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite3ParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite3Parser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite3ParserTOKENTYPE yyminor       /* The value for the token */
  sqlite3ParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
    /* if( yymajor==0 ) return; // not sure why this was here... */
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  sqlite3ParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_shift_action(yypParser,YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
