/****************************************************************************
** Form implementation generated from reading ui file 'clamscan.ui'
**
** Created: Sun Mar 13 19:55:35 2005
**      by: The User Interface Compiler ($Id: klamscanoptions.cpp,v 1.1.1.1 2006/02/03 20:35:03 hoganrobert Exp $)
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "klamscanoptions.h"

#include <tqlabel.h>
#include <tqspinbox.h>
#include <tqcheckbox.h>
#include <tqbuttongroup.h>
#include <kurlrequester.h>
#include <tdeconfig.h>
#include <kcombobox.h>
#include <tdelocale.h>

/*
 *  Constructs a KlamscanOptions as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KlamscanOptions::KlamscanOptions( TQWidget* parent, const char* name, bool modal, WFlags fl )
    : TQDialog( parent, name, modal, fl )
{
    if ( !name )
	setName( "KlamscanOptions" );

    Archive_Support = new TQGroupBox( this, "Archive_Support" );
    Archive_Support->setGeometry( TQRect( 20, 10, 551, 130 ) );

    textLabel1_2_2 = new TQLabel( Archive_Support, "textLabel1_2_2" );
    textLabel1_2_2->setGeometry( TQRect( 13, 52, 222, 21 ) );

    textLabel1_2 = new TQLabel( Archive_Support, "textLabel1_2" );
    textLabel1_2->setGeometry( TQRect( 314, 19, 222, 21 ) );

    textLabel1_2_3 = new TQLabel( Archive_Support, "textLabel1_2_3" );
    textLabel1_2_3->setGeometry( TQRect( 314, 51, 222, 21 ) );

    textLabel1 = new TQLabel( Archive_Support, "textLabel1" );
    textLabel1->setGeometry( TQRect( 13, 20, 222, 21 ) );

    NoFilesToExtract = new TQSpinBox(1,999,1, Archive_Support, "NoFilesToExtract" );
    NoFilesToExtract->setGeometry( TQRect( 240, 20, 40, 21 ) );

    MBsToExtract = new TQSpinBox(1,999,1, Archive_Support, "MBsToExtract" );
    MBsToExtract->setGeometry( TQRect( 474, 19, 40, 21 ) );

    RecursionLevel = new TQSpinBox(1,999,1, Archive_Support, "RecursionLevel" );
    RecursionLevel->setGeometry( TQRect( 241, 51, 40, 21 ) );

    CompressionRatio = new TQSpinBox(1,999,1, Archive_Support, "CompressionRatio" );
    CompressionRatio->setGeometry( TQRect( 474, 51, 40, 21 ) );

    VirusLimitsExceeded = new TQCheckBox( Archive_Support, "VirusLimitsExceeded" );
    VirusLimitsExceeded->setGeometry( TQRect( 11, 81, 220, 20 ) );
    VirusLimitsExceeded->setPaletteForegroundColor( TQColor( 255, 0, 0 ) );

    VirusEncrypted = new TQCheckBox( Archive_Support, "VirusEncrypted" );
    VirusEncrypted->setGeometry( TQRect( 318, 82, 220, 20 ) );
    VirusEncrypted->setPaletteForegroundColor( TQColor( 255, 0, 0 ) );

    ArchiveTypes = new TQButtonGroup( this, "ArchiveTypes" );
    ArchiveTypes->setGeometry( TQRect( 20, 150, 551, 320 ) );

    ScanZip = new TQCheckBox( ArchiveTypes, "ScanZip" );
    ScanZip->setGeometry( TQRect( 20, 30, 150, 21 ) );
  
    KComboBox* zipUrl = new KComboBox(true, this);
    ZipUsing = new KURLRequester( zipUrl,ArchiveTypes, "ZipUsing" );
    ZipUsing->setGeometry( TQRect( 178, 29, 340, 26 ) );

    ScanRar = new TQCheckBox( ArchiveTypes, "ScanRar" );
    ScanRar->setGeometry( TQRect( 20, 60, 150, 21 ) );

    KComboBox* rarUrl = new KComboBox(true, this);
    RarUsing = new KURLRequester( rarUrl, ArchiveTypes, "RarUsing" );
    RarUsing->setGeometry( TQRect( 178, 59, 340, 26 ) );

    ScanArj = new TQCheckBox( ArchiveTypes, "ScanArj" );
    ScanArj->setGeometry( TQRect( 20, 90, 150, 21 ) );
    
    KComboBox* arjUrl = new KComboBox(true, this);
    ArjUsing = new KURLRequester( arjUrl,ArchiveTypes, "ArjUsing" );
    ArjUsing->setGeometry( TQRect( 178, 89, 340, 26 ) );

    ScanZoo = new TQCheckBox( ArchiveTypes, "ScanZoo" );
    ScanZoo->setGeometry( TQRect( 20, 120, 150, 21 ) );
    
    KComboBox* zooUrl = new KComboBox(true, this);
    ZooUsing = new KURLRequester( zooUrl,ArchiveTypes, "ZooUsing" );
    ZooUsing->setGeometry( TQRect( 178, 119, 340, 26 ) );

    
    ScanLzh = new TQCheckBox( ArchiveTypes, "ScanLzh" );
    ScanLzh->setGeometry( TQRect( 20, 150, 150, 21 ) );

    KComboBox* lzhUrl = new KComboBox(true, this);
    LzhUsing = new KURLRequester( lzhUrl,ArchiveTypes, "LzhUsing" );
    LzhUsing->setGeometry( TQRect( 178, 149, 340, 26 ) );

    ScanJar = new TQCheckBox( ArchiveTypes, "ScanJar" );
    ScanJar->setGeometry( TQRect( 20, 180, 150, 21 ) );

    KComboBox* jarUrl = new KComboBox(true, this);
    JarUsing = new KURLRequester( jarUrl,ArchiveTypes, "JarUsing" );
    JarUsing->setGeometry( TQRect( 178, 179, 340, 26 ) );

    ScanDeb = new TQCheckBox( ArchiveTypes, "ScanDeb" );
    ScanDeb->setGeometry( TQRect( 20, 210, 150, 21 ) );

    KComboBox* debUrl = new KComboBox(true, this);
    DebUsing = new KURLRequester( debUrl,ArchiveTypes, "DebUsing" );
    DebUsing->setGeometry( TQRect( 178, 209, 340, 26 ) );

    ScanTar = new TQCheckBox( ArchiveTypes, "ScanTar" );
    ScanTar->setGeometry( TQRect( 20, 240, 150, 21 ) );

    KComboBox* tarUrl = new KComboBox(true, this);
    TarUsing = new KURLRequester( tarUrl,ArchiveTypes, "TarUsing" );
    TarUsing->setGeometry( TQRect( 178, 239, 340, 26 ) );

    ScanTgz = new TQCheckBox( ArchiveTypes, "ScanTgz" );
    ScanTgz->setGeometry( TQRect( 20, 270, 150, 21 ) );
    
    KComboBox* tgzUrl = new KComboBox(true, this);
    TgzUsing = new KURLRequester( tgzUrl,ArchiveTypes, "TgzUsing" );
    TgzUsing->setGeometry( TQRect( 178, 269, 340, 26 ) );

    FileTypes = new TQGroupBox( this, "FileTypes" );
    FileTypes->setGeometry( TQRect( 20, 490, 551, 120 ) );

    ScanMail = new TQCheckBox( FileTypes, "ScanMail" );
    ScanMail->setGeometry( TQRect( 20, 20, 200, 21 ) );

    ScanHTML = new TQCheckBox( FileTypes, "ScanHTML" );
    ScanHTML->setGeometry( TQRect( 270, 20, 200, 21 ) );

    ScanPE = new TQCheckBox( FileTypes, "ScanPE" );
    ScanPE->setGeometry( TQRect( 20, 50, 220, 21 ) );

    ScanOle = new TQCheckBox( FileTypes, "ScanOle" );
    ScanOle->setGeometry( TQRect( 270, 50, 270, 21 ) );
    ScanOle->setChecked( FALSE );

    VirusBroken = new TQCheckBox( FileTypes, "VirusBroken" );
    VirusBroken->setGeometry( TQRect( 20, 80, 240, 20 ) );
    VirusBroken->setPaletteForegroundColor( TQColor( 255, 0, 0 ) );

    ExcludeQuarantine = new TQCheckBox( FileTypes, "ExcludeQuarantine" );
    ExcludeQuarantine->setGeometry( TQRect( 270, 80, 270, 21 ) );
    ExcludeQuarantine->setChecked( FALSE );

    OK = new TQPushButton( this, i18n( "OK" ) );
    OK->setGeometry( TQRect( 190, 626, 91, 31 ) );
    OK->setDefault( TRUE );

    connect( OK, SIGNAL(clicked()),
	SLOT(updateSettings()) );

    Cancel = new TQPushButton( this, i18n( "Cancel" ) );
    Cancel->setGeometry( TQRect( 300, 626, 91, 31 ) );
    connect( Cancel, SIGNAL(clicked()),
		SLOT(close()) );

    languageChange();
    resize( TQSize(589, 667).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );
    fetchSettings();

}

/*
 *  Destroys the object and frees any allocated resources
 */
KlamscanOptions::~KlamscanOptions()
{
    // no need to delete child widgets, TQt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void KlamscanOptions::languageChange()
{
    setCaption( tr( "Scanning Options" ) );
    Archive_Support->setTitle( tr( "Archive Limits" ) );
    textLabel1_2_2->setText( i18n( "Maximum Level of Recursion" ) );
    textLabel1_2->setText( i18n( "MBs to Extract:" ) );
    textLabel1_2_3->setText( i18n( "Compression Ratio" ) );
    textLabel1->setText( i18n( "Number of Files to Extract:" ) );
    VirusLimitsExceeded->setText( i18n( "Mark as Virus if Limits Exceeded" ) );
    VirusEncrypted->setText( i18n( "Mark as Virus if Encrypted" ) );
    ArchiveTypes->setTitle( i18n( "Archive Types" ) );
    ScanZip->setText( i18n( "Scan Zip Files using" ) );
    ScanRar->setText( i18n( "Scan RAR Files using" ) );
    ScanArj->setText( i18n( "Scan ARJ Files using" ) );
    ScanZoo->setText( i18n( "Scan ZOO Files using" ) );
    ScanLzh->setText( i18n( "Scan LZH Files using" ) );
    ScanJar->setText( i18n( "Scan JAR Files using" ) );
    ScanDeb->setText( i18n( "Scan DEB Files using" ) );
    ScanTar->setText( i18n( "Scan TAR Files using" ) );
    ScanTgz->setText( i18n( "Scan TGZ Files using" ) );
    FileTypes->setTitle( i18n( "Special File Types" ) );
    ScanMail->setText( i18n( "Scan Files Containing Email(s)" ) );
    ScanHTML->setText( i18n( "Scan HTML Files for Exploits" ) );
    ScanPE->setText( i18n( "Scan 'Portable Executable' Files" ) );
    ScanOle->setText( i18n( "Scan the Macros in Microsoft Office Files" ) );
    VirusBroken->setText( i18n( "Treat a Broken Executable as Virus" ) );
    ExcludeQuarantine->setText( i18n( "Exclude Quarantine Directory" ) );
    OK->setText( i18n( "OK" ) );
    Cancel->setText( i18n( "Cancel" ) );
}

void KlamscanOptions::updateSettings()
{
	TDEConfig* config = TDEGlobal::config();
	config->setGroup("Klamscan");

	config->writeEntry("NoFilesToExtract", NoFilesToExtract->text());
	config->writeEntry("MBsToExtract", MBsToExtract->text()+"M");
	config->writeEntry("RecursionLevel", RecursionLevel->text());
	config->writeEntry("CompressionRatio", CompressionRatio->text());
	
	if (VirusLimitsExceeded->isChecked())
		config->writeEntry("VirusLimitsExceeded", "Yes");
	else
		config->writeEntry("VirusLimitsExceeded", "No");

	if (VirusEncrypted->isChecked())
		config->writeEntry("VirusEncrypted", "Yes");
	else
		config->writeEntry("VirusEncrypted", "No");
		
	if (ScanMail->isChecked())
		config->writeEntry("ScanMail", "Yes");
	else
		config->writeEntry("ScanMail", "No");

	if (ScanHTML->isChecked())
		config->writeEntry("ScanHTML", "Yes");
	else
		config->writeEntry("ScanHTML", "No");
	
	if (ScanPE->isChecked())
		config->writeEntry("ScanPE", "Yes");
	else
		config->writeEntry("ScanPE", "No");
	
	if (ScanOle->isChecked())
		config->writeEntry("ScanOle", "Yes");
	else
		config->writeEntry("ScanOle", "No");

	if (VirusBroken->isChecked())
		config->writeEntry("VirusBroken", "Yes");
	else
		config->writeEntry("VirusBroken", "No");
	
	if (ExcludeQuarantine->isChecked())
		config->writeEntry("ExcludeQuarantine", "Yes");
	else
		config->writeEntry("ExcludeQuarantine", "No");

	
	if (ScanZip->isChecked()){
		config->writeEntry("ScanZip", "Yes");
		config->writeEntry("ZipUsing", ZipUsing->url());
	}else
		config->writeEntry("ScanZip", "No");
	
	if (ScanRar->isChecked()){
		config->writeEntry("ScanRar", "Yes");
		config->writeEntry("RarUsing", RarUsing->url());
	}else
		config->writeEntry("ScanRar", "No");
	
	if (ScanArj->isChecked()){
		config->writeEntry("ScanArj", "Yes");
		config->writeEntry("ArjUsing", ArjUsing->url());
	}else
		config->writeEntry("ScanArj", "No");

	if (ScanZoo->isChecked()){
		config->writeEntry("ScanZoo", "Yes");
		config->writeEntry("ZooUsing", ZooUsing->url());
	}else
		config->writeEntry("ScanZoo", "No");

	if (ScanLzh->isChecked()){
		config->writeEntry("ScanLzh", "Yes");
		config->writeEntry("LzhUsing", LzhUsing->url());
	}else
		config->writeEntry("ScanLzh", "No");

	if (ScanJar->isChecked()){
		config->writeEntry("ScanJar", "Yes");
		config->writeEntry("JarUsing", JarUsing->url());
	}else
		config->writeEntry("ScanJar", "No");

	if (ScanDeb->isChecked()){
		config->writeEntry("ScanDeb", "Yes");
		config->writeEntry("DebUsing", DebUsing->url());
	}else
		config->writeEntry("ScanDeb", "No");

	if (ScanTar->isChecked()){
		config->writeEntry("ScanTar", "Yes");
		config->writeEntry("TarUsing", TarUsing->url());
	}else
		config->writeEntry("ScanTar", "No");

	if (ScanTgz->isChecked()){
		config->writeEntry("ScanTgz", "Yes");
		config->writeEntry("TgzUsing", TgzUsing->url());
	}else
		config->writeEntry("ScanTgz", "No");


	//kdDebug() << ZipUsing->url() << endl;
	config->sync();
	close();
}

void KlamscanOptions::fetchSettings()
{
	config = TDEGlobal::config();
	config->setGroup("Klamscan");

	
	NoFilesToExtract->setValue(TQString(config->readEntry("NoFilesToExtract")).toInt());
	MBsToExtract->setValue(TQString(config->readEntry("MBsToExtract")).replace("M","").toInt());
	CompressionRatio->setValue(TQString(config->readEntry("CompressionRatio")).toInt());
	RecursionLevel->setValue(TQString(config->readEntry("RecursionLevel")).toInt());

	if (config->readEntry("VirusLimitsExceeded") == "Yes")
		VirusLimitsExceeded->setChecked(true);
	else
		VirusLimitsExceeded->setChecked(false);

	if (config->readEntry("VirusEncrypted") == "Yes")
		VirusEncrypted->setChecked(true);
	else
		VirusEncrypted->setChecked(false);

	if (config->readEntry("ScanMail") == "Yes")
		ScanMail->setChecked(true);
	else
		ScanMail->setChecked(false);

	if (config->readEntry("ScanHTML") == "Yes")
		ScanHTML->setChecked(true);
	else
		ScanHTML->setChecked(false);

	if (config->readEntry("ScanPE") == "Yes")
		ScanPE->setChecked(true);
	else
		ScanPE->setChecked(false);

	if (config->readEntry("ScanOle") == "Yes")
		ScanOle->setChecked(true);
	else
		ScanOle->setChecked(false);

	if (config->readEntry("VirusBroken") == "Yes")
		VirusBroken->setChecked(true);
	else
		VirusBroken->setChecked(false);

	if (config->readEntry("ExcludeQuarantine") == "Yes")
		ExcludeQuarantine->setChecked(true);
	else
		ExcludeQuarantine->setChecked(false);



	if (config->readEntry("ScanZip") == "Yes"){
		ScanZip->setChecked(true);
		ZipUsing->setURL(config->readEntry("ZipUsing"));
	}else
		ScanZip->setChecked(false);

	if (config->readEntry("ScanRar") == "Yes"){
		ScanRar->setChecked(true);
		RarUsing->setURL(config->readEntry("RarUsing"));
	}else
		ScanRar->setChecked(false);

	if (config->readEntry("ScanArj") == "Yes"){
		ScanArj->setChecked(true);
		ArjUsing->setURL(config->readEntry("ArjUsing"));
	}else
		ScanArj->setChecked(false);

	if (config->readEntry("ScanZoo") == "Yes"){
		ScanZoo->setChecked(true);
		ZooUsing->setURL(config->readEntry("ZooUsing"));
	}else
		ScanZoo->setChecked(false);

	if (config->readEntry("ScanLzh") == "Yes"){
		ScanLzh->setChecked(true);
		LzhUsing->setURL(config->readEntry("LzhUsing"));
	}else
		ScanLzh->setChecked(false);

	if (config->readEntry("ScanJar") == "Yes"){
		ScanJar->setChecked(true);
		JarUsing->setURL(config->readEntry("JarUsing"));
	}else
		ScanJar->setChecked(false);

	if (config->readEntry("ScanDeb") == "Yes"){
		ScanDeb->setChecked(true);
		DebUsing->setURL(config->readEntry("DebUsing"));
	}else
		ScanDeb->setChecked(false);

	if (config->readEntry("ScanTar") == "Yes"){
		ScanTar->setChecked(true);
		TarUsing->setURL(config->readEntry("TarUsing"));
	}else
		ScanTar->setChecked(false);

	if (config->readEntry("ScanTgz") == "Yes"){
		ScanTgz->setChecked(true);
		TgzUsing->setURL(config->readEntry("TgzUsing"));
	}else
		ScanTgz->setChecked(false);

}

#include "klamscanoptions.moc"
