/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** TQt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/
#include "config.h"
#include "klamav.h"
#include <tdeapplication.h>
#include <tdelocale.h>
#include <tqpushbutton.h>
#include <tqpixmap.h>
#include <stdlib.h>
#include <kstandarddirs.h>
#include <kurl.h>

TQString databasepath;
TQString quarantinepath;



void
FirstRunWizard::init()
{

    // remove unwanted buttons
    cancelButton()->hide();
    helpButton()->hide();
    backButton()->hide();

    TQString homepath = getenv("HOME");
    databasepath = homepath + "/.klamav/database";
    DatabaseLocation->setURL(databasepath);

    quarantinepath = homepath + "/.klamav/quarantine";
    QuarantineLocation->setURL(quarantinepath);

    setFinishEnabled ( WizardPage, true );

}

// void
// FirstRunWizard::destroy()
// {
// 
// 
//     TDEConfig* config = klamav->TDEGlobal::config();
//     config->setGroup("Freshklam");
// 
//     //Configure Database Path
//     TQStringList lastDownloadPaths;
//     if (DatabaseLocation->url() != "")
//         lastDownloadPaths.prepend( TQString("%1").arg(DatabaseLocation->url()));
//     else
//         lastDownloadPaths.prepend( TQString("%1").arg(databasepath));
//     config->writeEntry("lastDownloadPaths", lastDownloadPaths);
//     config->sync();
// 
//     //Configure Quarantine Path
//     TQStringList lastQuarLocations;
// 
//     config->setGroup("Kuarantine");
// 
//     if (QuarantineLocation->url() != "")
//         lastQuarLocations.prepend( TQString("%1").arg(QuarantineLocation->url()));
//     else
//         lastQuarLocations.prepend( TQString("%1").arg(quarantinepath));
//     config->writeEntry("KuarantineLocations", lastQuarLocations);
//     config->sync();
// 
//     //Download an updated database?
//     if (CheckForDatabaseUpdates->isChecked())
//         tdemain->firstDownload = true;
// }

KURL
FirstRunWizard::databasePath( ) //virtual
{
    return DatabaseLocation->url();
}

KURL
FirstRunWizard::quarantinePath( ) //virtual
{
    return QuarantineLocation->url();
}

TQString
FirstRunWizard::defaultDatabasePath( ) //virtual
{
    return databasepath;
}

TQString
FirstRunWizard::defaultQuarantinePath( ) //virtual
{
    return quarantinepath;
}


bool
FirstRunWizard::downloadDatabase( ) //virtual
{
    if (CheckForDatabaseUpdates->isChecked())
        return true;
    return false;
}
