/***************************************************************************
 *
 * tdenetman.cpp - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

// TDE includes
#include <kdebug.h>
#include <tdelocale.h>
#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

// KNM includes
#include "tdenetman.h"
#include "tdenetman-tray.h"

#include <stdio.h>

// TQt includes
#include <tqstring.h>
#include <tqobject.h>

// TDE includes
#include <tdeglobal.h>
#include <kiconloader.h>

extern TDENetworkConnectionStatus::TDENetworkConnectionStatus nm_device_state_global;

class TDENetworkManagerPrivate
{
	public:
		TDENetworkManagerPrivate() {}
		~TDENetworkManagerPrivate() {}

		static TDENetworkManager* _ctx;
};

TDENetworkManager* TDENetworkManagerPrivate::_ctx = NULL;

TDENetworkManager* TDENetworkManager::getInstance()
{
	return TDENetworkManagerPrivate::_ctx;
}

void
TDENetworkManager::slotShutDown()
{
	//
}

void TDENetworkManager::timerEvent( TQTimerEvent *e )
{
	Tray* tray = Tray::getInstance();
	tray->slotUpdateDeviceState(nm_device_state_global, TDENetworkConnectionStatus::Invalid, TQString());
}

TDENetworkManager::TDENetworkManager() : KUniqueApplication()
{
	d = new TDENetworkManagerPrivate();
	d->_ctx = this;

	// we need to get informed when shutting down
	connect(this, TQT_SIGNAL(shutDown()), this, TQT_SLOT(slotShutDown()));

	// create the main-tray-icon
	Tray* tray = Tray::getInstance();
	tray->show();
	setMainWidget(tray);
}

TDENetworkManager::~TDENetworkManager()
{
	delete d;
}

#include "tdenetman.moc"

