/***************************************************************************
 *
 * tdenetman-authenticationdialog.h - A NetworkManager frontend for TDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_VPNAUTHENTICATIONDIALOG_H
#define TDENETWORKMANAGER_VPNAUTHENTICATIONDIALOG_H

#include <tqdir.h>
#include <tqobject.h>
#include <kprocess.h>
#include <tdeconfig.h>

#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

#include "tdenetman.h"
#include "vpnauthentication.h"
#include "tdenetman-vpnplugin.h"
#include "tdenetman-vpnmanager.h"

class TDENetworkManager;
class ManageConnectionsDialog;
class VPNService;

class VPNAuthenticationDialog : public AuthenticationDialog
{
	TQ_OBJECT
  
	public:
		VPNAuthenticationDialog(TDEVPNConnection* conn = NULL, TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0);
		~VPNAuthenticationDialog();
		void setPasswords(TDENetworkSettingsMap secrets);
		virtual bool close(bool);

	protected slots:
		void ok();
		void cancel();

	private:
		VPNAuthenticationWidget* _vpnAuthWidget;
		TDEVPNConnection* _conn;

	signals:
		void done(bool, TQStringList &, bool, bool);
};

#endif /* TDENETWORKMANAGER_VPNAUTHENTICATIONDIALOG_H */
