/***************************************************************************
 *
 * tdenetman-connection_editor.h - A NetworkManager frontend for TDE
 *
 * Copyright (C) 2005, 2006 Novell, Inc.
 *
 * Author: Helmut Schaa <hschaa@suse.de>, <helmut.schaa@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef TDENETWORKMANAGER_CONNECTION_EDITOR_H
#define TDENETWORKMANAGER_CONNECTION_EDITOR_H

// tqt headers
#include <tqvaluelist.h>

// tqt autogenerated headers
#include "connection_editor.h"

// TDE headers
#include <tdehardwaredevices.h>
#include <tdenetworkconnections.h>

class TQWidget;
class Device;

namespace ConnectionSettings
{
	class WidgetInterface;
	class ConnectionSetting;
}

class ConnectionEditorImpl : public ConnectionEditor
{
	TQ_OBJECT
  
	public:
		ConnectionEditorImpl(TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0);
		~ConnectionEditorImpl();

	protected slots:
		void slotRemoveCurrentConnection();
		void slotEditCurrentConnection();
		void slotNewWirelessConnection();
		void slotNewWiredConnection();
		void slotEditNewConnection(TDENetworkConnection* conn);
		void slotRefreshConnectionList();
		void slotNewVPNConnection();

	private:
		void fillConnectionList();
};

#endif /* TDENETWORKMANAGER_CONNECTION_EDITOR_H*/
