/***************************************************************************
 *   Copyright (C) 2005 by David Saxton                                    *
 *   david@bluehaze.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef CIWIDGETMGR_H
#define CIWIDGETMGR_H

#include <tqmap.h>
#include <tqstring.h>

class Button;
class CNItem;
class Slider;
class TQCanvas;
class Widget;

typedef TQMap<TQString, Widget*> WidgetMap;

/**
This class handles the widgets (those things associated with CNItems that use TQWidgets.
This class is pretty much to maintain a tidy interface: the functions could just as well be
all shoved in CNItem, but that gets messy.
@author David Saxton
*/
class CIWidgetMgr
{
public:
	CIWidgetMgr( TQCanvas *canvas, CNItem *item );
	virtual ~CIWidgetMgr();
	
	/**
	 * Set the top-left position from which mouse events are interpreted and the
	 * widgets are drawn from.
	 */
	void setWidgetsPos( const TQPoint &pos );
	/**
	 * Returns a pointer to the widget with the given id, or NULL if no such
	 * widgets are found.
	 */
	Widget *widgetWithID( const TQString &id ) const;
	Button *button( const TQString &id ) const;
	Slider *slider( const TQString &id ) const;
	void setButtonState( const TQString &id, int state );
	/**
	 * Adds a slider with the given id and values to the position
	 */
	Slider* addSlider( const TQString &id, int minValue, int maxValue, int pageStep, int value, Qt::Orientation orientation, const TQRect & pos );
	/**
	 * Essentially the same as addDisplayText, but displays a button with
	 * text on it. The virtual functions buttonPressed( const TQString &id ) and
	 * buttonReleased( const TQString &id ) are called as appropriate with button id
	 */
	Button* addButton( const TQString &id, const TQRect & pos, const TQString &display, bool toggle = false );
	/**
	 * Adds a button with a TQPixmap pixmap on it instead of text
	 * @see void addButton( const TQString &id, TQRect pos, const TQString &display )
	 */
	Button* addButton( const TQString &id, const TQRect & pos, TQPixmap pixmap, bool toggle = false );
	/**
	 * Removes the widget with the given id.
	 */
	void removeWidget( const TQString & id );
	/**
	 * Sets whether or not to draw the widgets (drawing widgets mucks up SVG
	 * export). This function just calls either hide() or show() in each widget.
	 */
	void setDrawWidgets( bool draw );
	
	bool mousePressEvent( const EventInfo &info );
	bool mouseReleaseEvent( const EventInfo &info );
	bool mouseDoubleClickEvent ( const EventInfo &info );
	bool mouseMoveEvent( const EventInfo &info );
	bool wheelEvent( const EventInfo &info );
	void enterEvent();
	void leaveEvent();
	
	virtual void buttonStateChanged( const TQString &/*id*/, bool /*on*/ ) {};
	virtual void sliderValueChanged( const TQString &/*id*/, int /*value*/ ) {};
	
	int mgrX() const { return m_pos.x(); }
	int mgrY() const { return m_pos.y(); }
	/**
	 * Draw the widgets using the given painter. This function isn't actually
	 * used to draw the widgets on the canvas, as they are TQCanvasItems
	 * themselves, but allows other classes (e.g. ItemLibrary) to draw them
	 * using a special painter.
	 */
	void drawWidgets( TQPainter &p );
	
protected:
	WidgetMap m_widgetMap;
	TQPoint m_pos;
	TQCanvas *p_canvas;
	CNItem *p_cnItem;
};

#endif
