/*
 *   Copyright (C) 2005 by Ian Monroe <ian@monroe.nu>
 *   Released under GPL 2 or later, see COPYING
 */

#include "eqdialog.h"
#include "equalizercanvasview.h"
#include "stdinreader.h"
#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdecmdlineargs.h>


#include <tqcanvas.h>
#include <tqlayout.h>

#include <tqsocketnotifier.h>
#include <tqtextstream.h>


static const char description[] =
    I18N_NOOP("An Amarok Equalizer using a line graph");

static const char version[] = "0.5";

int main(int argc, char **argv)
{
    TDEAboutData about("Graph Equalizer", I18N_NOOP("Graph Equalizer"), version, description,
             TDEAboutData::License_GPL, "(C) 2005 Ian Monroe", 0, 0, "ian@monroe.nu");
    about.addAuthor( "Ian Monroe", 0, "ian@monroe.nu" );
    TDECmdLineArgs::init( argc, argv, &about );
    TDEApplication app;
    EqDialog *mainWin = new EqDialog();
//     mainWin = new EqualizerGraph(0,"equalizerdialog");
//     TQCanvas canvas;
//     canvas.resize(400, 200);
//     EqualizerCanvasView* eq = new EqualizerCanvasView(&canvas,mainWin,"eqcanvasview");
//     mainWin->getHLayout()->addWidget(eq);
//    app.setMainWidget( mainWin );
    mainWin->show();
    StdinReader* listen = new StdinReader(mainWin, "ioListener");
    CallAmarok* ca = new CallAmarok(mainWin,"ca", mainWin->canvasView,mainWin->preampSlider);
    mainWin->connect(listen, TQT_SIGNAL(openWindow()), mainWin, TQT_SLOT(show()));
    mainWin->connect(mainWin->canvasView,TQT_SIGNAL(eqChanged()),ca, TQT_SLOT(updateEq()));
    mainWin->connect(mainWin->preampSlider,TQT_SIGNAL(sliderReleased()),ca, TQT_SLOT(updateEq()));
    return app.exec();
}

